/*
 * Decompiled with CFR 0.152.
 */
package org.jdesktop.j3d.examples.text2d;

import java.awt.AWTEvent;
import java.awt.event.KeyEvent;
import java.util.Enumeration;
import javax.media.j3d.Behavior;
import javax.media.j3d.BoundingSphere;
import javax.media.j3d.Bounds;
import javax.media.j3d.Transform3D;
import javax.media.j3d.TransformGroup;
import javax.media.j3d.WakeupCondition;
import javax.media.j3d.WakeupCriterion;
import javax.media.j3d.WakeupOnAWTEvent;
import javax.media.j3d.WakeupOr;
import javax.vecmath.Point3d;
import javax.vecmath.Vector3f;

class MoverBehavior
extends Behavior {
    WakeupOnAWTEvent w1 = new WakeupOnAWTEvent(401);
    WakeupCriterion[] w2 = new WakeupCriterion[]{this.w1};
    WakeupCondition w = new WakeupOr(this.w2);
    TransformGroup viewTransformGroup;
    double rotation = 0.0;

    public void initialize() {
        this.wakeupOn(this.w);
    }

    public void processStimulus(Enumeration criteria) {
        while (criteria.hasMoreElements()) {
            WakeupCriterion genericEvt = (WakeupCriterion)criteria.nextElement();
            if (!(genericEvt instanceof WakeupOnAWTEvent)) continue;
            WakeupOnAWTEvent ev = (WakeupOnAWTEvent)genericEvt;
            AWTEvent[] events = ev.getAWTEvent();
            this.processManualEvent(events);
        }
        this.wakeupOn(this.w);
    }

    void processManualEvent(AWTEvent[] events) {
        for (int i = 0; i < events.length; ++i) {
            KeyEvent event;
            if (!(events[i] instanceof KeyEvent) || (event = (KeyEvent)events[i]).getKeyCode() == 61) continue;
            Transform3D t = new Transform3D();
            this.viewTransformGroup.getTransform(t);
            Vector3f viewDir = new Vector3f(0.0f, 0.0f, -1.0f);
            Vector3f translation = new Vector3f();
            t.get(translation);
            t.transform(viewDir);
            if (event.getKeyCode() == 38) {
                translation.x += viewDir.x;
                translation.y += viewDir.y;
                translation.z += viewDir.z;
            } else if (event.getKeyCode() == 40) {
                translation.x -= viewDir.x;
                translation.y -= viewDir.y;
                translation.z -= viewDir.z;
            } else if (event.getKeyCode() == 39) {
                this.rotation += -0.1;
            } else if (event.getKeyCode() == 37) {
                this.rotation += 0.1;
            }
            t.rotY(this.rotation);
            t.setTranslation(translation);
            this.viewTransformGroup.setTransform(t);
        }
    }

    public MoverBehavior(TransformGroup trans) {
        this.viewTransformGroup = trans;
        BoundingSphere bound = new BoundingSphere(new Point3d(0.0, 0.0, 0.0), 10000.0);
        this.setSchedulingBounds((Bounds)bound);
    }
}

