/*
 * Decompiled with CFR 0.152.
 */
package org.jdesktop.j3d.examples.text2d;

import com.sun.j3d.utils.applet.MainFrame;
import com.sun.j3d.utils.geometry.Text2D;
import com.sun.j3d.utils.universe.SimpleUniverse;
import java.applet.Applet;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.GraphicsConfiguration;
import javax.media.j3d.Alpha;
import javax.media.j3d.Appearance;
import javax.media.j3d.BoundingSphere;
import javax.media.j3d.Bounds;
import javax.media.j3d.BranchGroup;
import javax.media.j3d.Canvas3D;
import javax.media.j3d.Node;
import javax.media.j3d.PolygonAttributes;
import javax.media.j3d.RotationInterpolator;
import javax.media.j3d.Transform3D;
import javax.media.j3d.TransformGroup;
import javax.vecmath.Color3f;
import javax.vecmath.Point3d;
import javax.vecmath.Vector3f;
import org.jdesktop.j3d.examples.text2d.MoverBehavior;

public class Text2DTest
extends Applet {
    private SimpleUniverse u = null;

    public BranchGroup createSceneGraph() {
        BranchGroup objRoot = new BranchGroup();
        TransformGroup objScale = new TransformGroup();
        Transform3D t3d = new Transform3D();
        t3d.setScale(0.4);
        objScale.setTransform(t3d);
        objRoot.addChild((Node)objScale);
        TransformGroup objTrans = new TransformGroup();
        objTrans.setCapability(18);
        BoundingSphere bounds = new BoundingSphere(new Point3d(0.0, 0.0, 0.0), 100.0);
        float yPos = -0.5f;
        Text2D textObject = new Text2D("Rotating Yellow Text", new Color3f(1.0f, 1.0f, 0.0f), "Serif", 60, 1);
        Appearance app = textObject.getAppearance();
        PolygonAttributes pa = app.getPolygonAttributes();
        if (pa == null) {
            pa = new PolygonAttributes();
        }
        pa.setCullFace(0);
        if (app.getPolygonAttributes() == null) {
            app.setPolygonAttributes(pa);
        }
        objTrans.addChild((Node)textObject);
        Transform3D textTranslation = new Transform3D();
        textTranslation.setTranslation(new Vector3f(0.0f, yPos, 0.0f));
        TransformGroup textTranslationGroup = new TransformGroup(textTranslation);
        textTranslationGroup.addChild((Node)objTrans);
        objScale.addChild((Node)textTranslationGroup);
        textObject = new Text2D("Blue 40point Text", new Color3f(0.0f, 0.0f, 1.0f), "Serif", 40, 1);
        textTranslation = new Transform3D();
        textTranslation.setTranslation(new Vector3f(0.0f, yPos += 0.5f, 0.0f));
        textTranslationGroup = new TransformGroup(textTranslation);
        textTranslationGroup.addChild((Node)textObject);
        objScale.addChild((Node)textTranslationGroup);
        textObject = new Text2D("Green Italic Text", new Color3f(0.0f, 1.0f, 0.0f), "Serif", 70, 2);
        textTranslation = new Transform3D();
        textTranslation.setTranslation(new Vector3f(0.0f, yPos += 0.5f, 0.0f));
        textTranslationGroup = new TransformGroup(textTranslation);
        textTranslationGroup.addChild((Node)textObject);
        objScale.addChild((Node)textTranslationGroup);
        yPos += 0.5f;
        Transform3D yAxis = new Transform3D();
        Alpha rotationAlpha = new Alpha(-1, 1, 0L, 0L, 4000L, 0L, 0L, 0L, 0L, 0L);
        RotationInterpolator rotator = new RotationInterpolator(rotationAlpha, objTrans, yAxis, 0.0f, (float)Math.PI * 2);
        rotator.setSchedulingBounds((Bounds)bounds);
        objTrans.addChild((Node)rotator);
        return objRoot;
    }

    public void init() {
        this.setLayout(new BorderLayout());
        GraphicsConfiguration config = SimpleUniverse.getPreferredConfiguration();
        Canvas3D c = new Canvas3D(config);
        this.add("Center", (Component)c);
        BranchGroup scene = this.createSceneGraph();
        this.u = new SimpleUniverse(c);
        MoverBehavior navigator = new MoverBehavior(this.u.getViewingPlatform().getViewPlatformTransform());
        scene.addChild((Node)navigator);
        scene.compile();
        this.u.getViewingPlatform().setNominalViewingTransform();
        this.u.addBranchGraph(scene);
    }

    public void destroy() {
        this.u.cleanup();
    }

    public static void main(String[] args) {
        new MainFrame((Applet)new Text2DTest(), 256, 256);
    }
}

