/*
 * Decompiled with CFR 0.152.
 */
package org.jdesktop.j3d.examples.texture;

import com.sun.j3d.utils.applet.MainFrame;
import com.sun.j3d.utils.geometry.Box;
import com.sun.j3d.utils.image.TextureLoader;
import com.sun.j3d.utils.universe.SimpleUniverse;
import java.applet.Applet;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.GraphicsConfiguration;
import java.net.MalformedURLException;
import java.net.URL;
import javax.media.j3d.Alpha;
import javax.media.j3d.Appearance;
import javax.media.j3d.BoundingSphere;
import javax.media.j3d.Bounds;
import javax.media.j3d.BranchGroup;
import javax.media.j3d.Canvas3D;
import javax.media.j3d.Node;
import javax.media.j3d.RotationInterpolator;
import javax.media.j3d.Texture;
import javax.media.j3d.TextureAttributes;
import javax.media.j3d.Transform3D;
import javax.media.j3d.TransformGroup;
import javax.vecmath.Point3d;
import org.jdesktop.j3d.examples.Resources;

public class TextureImage
extends Applet {
    private static final String defaultFileName = "resources/images/stone.jpg";
    private URL texImage = null;
    private SimpleUniverse u = null;

    public BranchGroup createSceneGraph() {
        BranchGroup objRoot = new BranchGroup();
        TransformGroup objTrans = new TransformGroup();
        objTrans.setCapability(18);
        objRoot.addChild((Node)objTrans);
        Appearance app = new Appearance();
        Texture tex = new TextureLoader(this.texImage, (Component)this).getTexture();
        app.setTexture(tex);
        TextureAttributes texAttr = new TextureAttributes();
        texAttr.setTextureMode(2);
        app.setTextureAttributes(texAttr);
        Box textureCube = new Box(0.4f, 0.4f, 0.4f, 2, app);
        objTrans.addChild((Node)textureCube);
        Transform3D yAxis = new Transform3D();
        Alpha rotationAlpha = new Alpha(-1, 1, 0L, 0L, 4000L, 0L, 0L, 0L, 0L, 0L);
        RotationInterpolator rotator = new RotationInterpolator(rotationAlpha, objTrans, yAxis, 0.0f, (float)Math.PI * 2);
        BoundingSphere bounds = new BoundingSphere(new Point3d(0.0, 0.0, 0.0), 100.0);
        rotator.setSchedulingBounds((Bounds)bounds);
        objTrans.addChild((Node)rotator);
        objRoot.compile();
        return objRoot;
    }

    public TextureImage() {
    }

    public TextureImage(URL url) {
        this.texImage = url;
    }

    public void init() {
        if (this.texImage == null) {
            this.texImage = Resources.getResource(defaultFileName);
            if (this.texImage == null) {
                System.err.println("resources/images/stone.jpg not found");
                System.exit(1);
            }
        }
        this.setLayout(new BorderLayout());
        GraphicsConfiguration config = SimpleUniverse.getPreferredConfiguration();
        Canvas3D c = new Canvas3D(config);
        this.add("Center", (Component)c);
        BranchGroup scene = this.createSceneGraph();
        this.u = new SimpleUniverse(c);
        this.u.getViewingPlatform().setNominalViewingTransform();
        this.u.addBranchGraph(scene);
    }

    public void destroy() {
        this.u.cleanup();
    }

    public static void main(String[] args) {
        URL url;
        block6: {
            url = null;
            if (args.length > 0) {
                try {
                    String name = args[0];
                    if (name.startsWith("http:") || name.startsWith("https:") || name.startsWith("ftp:") || name.startsWith("file:")) {
                        url = new URL(name);
                        break block6;
                    }
                    url = new URL("file:" + name);
                }
                catch (MalformedURLException ex) {
                    System.out.println(ex.getMessage());
                    System.exit(1);
                }
            } else {
                url = Resources.getResource(defaultFileName);
                if (url == null) {
                    System.err.println("resources/images/stone.jpg not found");
                    System.exit(1);
                }
            }
        }
        new MainFrame((Applet)new TextureImage(url), 256, 256);
    }
}

