/*
 * Decompiled with CFR 0.152.
 */
package org.jdesktop.j3d.examples.texture_by_ref;

import com.sun.j3d.utils.image.TextureLoader;
import java.awt.Component;
import java.awt.image.BufferedImage;
import java.net.URL;
import java.util.Enumeration;
import javax.media.j3d.Appearance;
import javax.media.j3d.Behavior;
import javax.media.j3d.ImageComponent;
import javax.media.j3d.ImageComponent2D;
import javax.media.j3d.Texture;
import javax.media.j3d.Texture2D;
import javax.media.j3d.WakeupCondition;
import javax.media.j3d.WakeupCriterion;
import javax.media.j3d.WakeupOnElapsedFrames;
import org.jdesktop.j3d.examples.texture_by_ref.ImageOps;
import org.jdesktop.j3d.examples.texture_by_ref.TextureByReference;

public class AnimateTexturesBehavior
extends Behavior {
    private int current;
    private int max;
    private ImageComponent2D[] images;
    private Texture2D texture;
    private Appearance appearance;
    private WakeupCriterion wakeupC;
    private boolean flip;
    private int currentType;
    public static final int TYPE_CUSTOM_RGBA = 1;
    public static final int TYPE_CUSTOM_RGB = 2;
    private int customType;

    public AnimateTexturesBehavior(Texture2D texP, URL[] fnames, Appearance appP, TextureByReference applet) {
        int size = fnames.length;
        this.images = new ImageComponent2D[size];
        for (int i = 0; i < size; ++i) {
            TextureLoader loader = new TextureLoader(fnames[i], 6, (Component)applet);
            this.images[i] = loader.getImage();
            BufferedImage bImage = this.images[i].getImage();
            this.currentType = 6;
            bImage = ImageOps.convertImage(bImage, this.currentType);
            this.flip = true;
            ImageOps.flipImage(bImage);
            this.images[i].set(bImage);
            this.images[i].setCapability(2);
            this.images[i].setCapability(1);
        }
        this.texture = texP;
        this.current = 0;
        this.max = size;
        this.wakeupC = new WakeupOnElapsedFrames(20);
        this.appearance = appP;
    }

    public void initialize() {
        this.texture.setImage(0, (ImageComponent)this.images[this.current]);
        this.current = this.current < this.max - 1 ? ++this.current : 0;
        this.wakeupOn((WakeupCondition)this.wakeupC);
    }

    public void processStimulus(Enumeration criteria) {
        this.texture.setImage(0, (ImageComponent)this.images[this.current]);
        this.appearance.setTexture((Texture)this.texture);
        this.current = this.current < this.max - 1 ? ++this.current : 0;
        this.wakeupOn((WakeupCondition)this.wakeupC);
    }

    public void setFlipImages(boolean b) {
        if (b != this.flip) {
            int format = this.images[0].getFormat();
            boolean byRef = this.images[0].isByReference();
            boolean yUp = this.images[0].isYUp();
            for (int i = 0; i < this.images.length; ++i) {
                BufferedImage bImage = this.images[i].getImage();
                ImageOps.flipImage(bImage);
                if (byRef && bImage.getType() != this.currentType) {
                    bImage = this.currentType != 0 ? ImageOps.convertImage(bImage, this.currentType) : (this.customType == 1 ? ImageOps.convertToCustomRGBA(bImage) : ImageOps.convertToCustomRGB(bImage));
                }
                this.images[i] = new ImageComponent2D(format, bImage, byRef, yUp);
                this.images[i].setCapability(2);
                this.images[i].setCapability(1);
            }
            this.flip = b;
        }
    }

    public void setYUp(boolean b) {
        if (b != this.images[0].isYUp()) {
            int format = this.images[0].getFormat();
            boolean byRef = this.images[0].isByReference();
            for (int i = 0; i < this.images.length; ++i) {
                BufferedImage bImage = this.images[i].getImage();
                if (byRef && bImage.getType() != this.currentType) {
                    bImage = this.currentType != 0 ? ImageOps.convertImage(bImage, this.currentType) : (this.customType == 1 ? ImageOps.convertToCustomRGBA(bImage) : ImageOps.convertToCustomRGB(bImage));
                }
                this.images[i] = new ImageComponent2D(format, bImage, byRef, b);
                this.images[i].setCapability(2);
                this.images[i].setCapability(1);
            }
        }
    }

    public void setByReference(boolean b) {
        if (b != this.images[0].isByReference()) {
            int format = this.images[0].getFormat();
            boolean yUp = this.images[0].isYUp();
            for (int i = 0; i < this.images.length; ++i) {
                BufferedImage bImage = this.images[i].getImage();
                if (bImage.getType() != this.currentType && b) {
                    bImage = this.currentType != 0 ? ImageOps.convertImage(bImage, this.currentType) : (this.customType == 1 ? ImageOps.convertToCustomRGBA(bImage) : ImageOps.convertToCustomRGB(bImage));
                }
                this.images[i] = new ImageComponent2D(format, bImage, b, yUp);
                this.images[i].setCapability(2);
                this.images[i].setCapability(1);
            }
        }
    }

    public void setFrameDelay(int delay) {
        this.wakeupC = new WakeupOnElapsedFrames(delay);
    }

    public void setImageType(int newType) {
        this.currentType = newType;
        if (this.images[0].isByReference()) {
            int format = this.images[0].getFormat();
            boolean yUp = this.images[0].isYUp();
            boolean byRef = true;
            for (int i = 0; i < this.images.length; ++i) {
                BufferedImage bImage = this.images[i].getImage();
                bImage = ImageOps.convertImage(bImage, this.currentType);
                this.images[i] = new ImageComponent2D(format, bImage, byRef, yUp);
                this.images[i].setCapability(2);
                this.images[i].setCapability(1);
            }
        }
    }

    public void setImageTypeCustomRGBA() {
        this.currentType = 0;
        this.customType = 1;
        if (this.images[0].isByReference()) {
            int format = this.images[0].getFormat();
            boolean yUp = this.images[0].isYUp();
            boolean byRef = true;
            for (int i = 0; i < this.images.length; ++i) {
                BufferedImage bImage = this.images[i].getImage();
                bImage = ImageOps.convertToCustomRGBA(bImage);
                this.images[i] = new ImageComponent2D(format, bImage, byRef, yUp);
                this.images[i].setCapability(2);
                this.images[i].setCapability(1);
            }
        }
    }

    public void setImageTypeCustomRGB() {
        this.currentType = 0;
        this.customType = 2;
        if (this.images[0].isByReference()) {
            int format = this.images[0].getFormat();
            boolean yUp = this.images[0].isYUp();
            boolean byRef = true;
            for (int i = 0; i < this.images.length; ++i) {
                BufferedImage bImage = this.images[i].getImage();
                bImage = ImageOps.convertToCustomRGB(bImage);
                this.images[i] = new ImageComponent2D(format, bImage, byRef, yUp);
                this.images[i].setCapability(2);
                this.images[i].setCapability(1);
            }
        }
    }
}

