/*
 * Decompiled with CFR 0.152.
 */
package org.jdesktop.j3d.examples.texture_by_ref;

import java.awt.color.ColorSpace;
import java.awt.image.BufferedImage;
import java.awt.image.ComponentColorModel;
import java.awt.image.DataBufferByte;
import java.awt.image.Raster;
import java.awt.image.WritableRaster;

public class ImageOps {
    public static void flipImage(BufferedImage bImage) {
        int width = bImage.getWidth();
        int height = bImage.getHeight();
        int[] rgbArray = new int[width * height];
        bImage.getRGB(0, 0, width, height, rgbArray, 0, width);
        int[] tempArray = new int[width * height];
        int y2 = 0;
        for (int y = height - 1; y >= 0; --y) {
            for (int x = 0; x < width; ++x) {
                tempArray[y2 * width + x] = rgbArray[y * width + x];
            }
            ++y2;
        }
        bImage.setRGB(0, 0, width, height, tempArray, 0, width);
    }

    public static BufferedImage convertImage(BufferedImage bImage, int type) {
        int width = bImage.getWidth();
        int height = bImage.getHeight();
        BufferedImage newImage = new BufferedImage(width, height, type);
        int[] rgbArray = new int[width * height];
        bImage.getRGB(0, 0, width, height, rgbArray, 0, width);
        newImage.setRGB(0, 0, width, height, rgbArray, 0, width);
        return newImage;
    }

    static void printType(BufferedImage bImage) {
        int type = bImage.getType();
        if (type == 6) {
            System.out.println("TYPE_4BYTE_ABGR");
        } else if (type == 2) {
            System.out.println("TYPE_INT_ARGB");
        } else if (type == 5) {
            System.out.println("TYPE_3BYTE_BGR");
        } else if (type == 0) {
            System.out.println("TYPE_CUSTOM");
        } else {
            System.out.println(type);
        }
    }

    public static BufferedImage convertToCustomRGBA(BufferedImage bImage) {
        if (bImage.getType() != 2) {
            ImageOps.convertImage(bImage, 2);
        }
        int width = bImage.getWidth();
        int height = bImage.getHeight();
        ColorSpace cs = ColorSpace.getInstance(1000);
        int[] nBits = new int[]{8, 8, 8, 8};
        ComponentColorModel cm = new ComponentColorModel(cs, nBits, true, false, 1, 0);
        int[] bandOffset = new int[]{0, 1, 2, 3};
        WritableRaster newRaster = Raster.createInterleavedRaster(0, width, height, width * 4, 4, bandOffset, null);
        byte[] byteData = ((DataBufferByte)newRaster.getDataBuffer()).getData();
        Raster origRaster = bImage.getData();
        int[] pixel = new int[4];
        int k = 0;
        for (int j = 0; j < height; ++j) {
            for (int i = 0; i < width; ++i) {
                pixel = origRaster.getPixel(i, j, pixel);
                byteData[k++] = (byte)pixel[0];
                byteData[k++] = (byte)pixel[1];
                byteData[k++] = (byte)pixel[2];
                byteData[k++] = (byte)pixel[3];
            }
        }
        BufferedImage newImage = new BufferedImage(cm, newRaster, false, null);
        return newImage;
    }

    public static BufferedImage convertToCustomRGB(BufferedImage bImage) {
        if (bImage.getType() != 2) {
            ImageOps.convertImage(bImage, 2);
        }
        int width = bImage.getWidth();
        int height = bImage.getHeight();
        ColorSpace cs = ColorSpace.getInstance(1000);
        int[] nBits = new int[]{8, 8, 8};
        ComponentColorModel cm = new ComponentColorModel(cs, nBits, false, false, 1, 0);
        int[] bandOffset = new int[]{0, 1, 2};
        WritableRaster newRaster = Raster.createInterleavedRaster(0, width, height, width * 3, 3, bandOffset, null);
        byte[] byteData = ((DataBufferByte)newRaster.getDataBuffer()).getData();
        Raster origRaster = bImage.getData();
        int[] pixel = new int[4];
        int k = 0;
        for (int j = 0; j < height; ++j) {
            for (int i = 0; i < width; ++i) {
                pixel = origRaster.getPixel(i, j, pixel);
                byteData[k++] = (byte)pixel[0];
                byteData[k++] = (byte)pixel[1];
                byteData[k++] = (byte)pixel[2];
            }
        }
        BufferedImage newImage = new BufferedImage(cm, newRaster, false, null);
        return newImage;
    }
}

