/*
 * Decompiled with CFR 0.152.
 */
package org.jdesktop.j3d.examples.texture_by_ref;

import javax.media.j3d.Appearance;
import javax.media.j3d.Geometry;
import javax.media.j3d.Shape3D;
import javax.media.j3d.TriangleArray;
import javax.vecmath.Point2f;
import javax.vecmath.Point3f;
import javax.vecmath.TexCoord2f;
import javax.vecmath.Tuple2f;
import javax.vecmath.Tuple3f;
import javax.vecmath.Vector3f;

public class Tetrahedron
extends Shape3D {
    private static final float sqrt3 = (float)Math.sqrt(3.0);
    private static final float sqrt3_3 = sqrt3 / 3.0f;
    private static final float sqrt24_3 = (float)Math.sqrt(24.0) / 3.0f;
    private static final float ycenter = 0.5f * sqrt24_3;
    private static final float zcenter = -sqrt3_3;
    private static final Point3f p1 = new Point3f(-1.0f, -ycenter, -zcenter);
    private static final Point3f p2 = new Point3f(1.0f, -ycenter, -zcenter);
    private static final Point3f p3 = new Point3f(0.0f, -ycenter, -sqrt3 - zcenter);
    private static final Point3f p4 = new Point3f(0.0f, sqrt24_3 - ycenter, 0.0f);
    private static final Point3f[] verts = new Point3f[]{p1, p2, p4, p1, p4, p3, p2, p3, p4, p1, p3, p2};
    private Point2f[] texCoord = new Point2f[]{new Point2f(-0.25f, 0.0f), new Point2f(1.25f, 0.0f), new Point2f(0.5f, 2.0f)};
    private TriangleArray geometryByRef;
    private TriangleArray geometryByCopy;
    private Point3f[] verticesArray = new Point3f[12];
    private TexCoord2f[] textureCoordsArray = new TexCoord2f[12];
    private Vector3f[] normalsArray = new Vector3f[12];

    public Tetrahedron() {
        this(false);
    }

    public Tetrahedron(boolean byRef) {
        if (byRef) {
            this.createGeometryByRef();
            this.setGeometry((Geometry)this.geometryByRef);
        } else {
            this.createGeometryByCopy();
            this.setGeometry((Geometry)this.geometryByCopy);
        }
        this.setCapability(12);
        this.setCapability(13);
        this.setAppearance(new Appearance());
    }

    public void createGeometryByRef() {
        int i;
        this.geometryByRef = new TriangleArray(12, 163);
        for (i = 0; i < 12; ++i) {
            this.verticesArray[i] = new Point3f(verts[i]);
        }
        this.geometryByRef.setCoordRef3f(this.verticesArray);
        for (i = 0; i < 12; ++i) {
            this.textureCoordsArray[i] = new TexCoord2f((Tuple2f)this.texCoord[i % 3]);
        }
        this.geometryByRef.setTexCoordRef2f(0, this.textureCoordsArray);
        Vector3f normal = new Vector3f();
        Vector3f v1 = new Vector3f();
        Vector3f v2 = new Vector3f();
        Point3f[] pts = new Point3f[3];
        for (int face = 0; face < 4; ++face) {
            pts[0] = new Point3f(verts[face * 3]);
            pts[1] = new Point3f(verts[face * 3 + 1]);
            pts[2] = new Point3f(verts[face * 3 + 2]);
            v1.sub((Tuple3f)pts[1], (Tuple3f)pts[0]);
            v2.sub((Tuple3f)pts[2], (Tuple3f)pts[0]);
            normal.cross(v1, v2);
            normal.normalize();
            for (i = 0; i < 3; ++i) {
                this.normalsArray[face * 3 + i] = new Vector3f(normal);
            }
        }
        this.geometryByRef.setNormalRef3f(this.normalsArray);
    }

    public void createGeometryByCopy() {
        int i;
        this.geometryByCopy = new TriangleArray(12, 35);
        this.geometryByCopy.setCoordinates(0, verts);
        for (i = 0; i < 12; ++i) {
            this.geometryByCopy.setTextureCoordinate(0, i, new TexCoord2f((Tuple2f)this.texCoord[i % 3]));
        }
        Vector3f normal = new Vector3f();
        Vector3f v1 = new Vector3f();
        Vector3f v2 = new Vector3f();
        Point3f[] pts = new Point3f[3];
        for (i = 0; i < 3; ++i) {
            pts[i] = new Point3f();
        }
        for (int face = 0; face < 4; ++face) {
            this.geometryByCopy.getCoordinates(face * 3, pts);
            v1.sub((Tuple3f)pts[1], (Tuple3f)pts[0]);
            v2.sub((Tuple3f)pts[2], (Tuple3f)pts[0]);
            normal.cross(v1, v2);
            normal.normalize();
            for (i = 0; i < 3; ++i) {
                this.geometryByCopy.setNormal(face * 3 + i, normal);
            }
        }
    }

    public void setByReference(boolean b) {
        if (b) {
            if (this.geometryByRef == null) {
                this.createGeometryByRef();
            }
            this.setGeometry((Geometry)this.geometryByRef);
        } else {
            if (this.geometryByCopy == null) {
                this.createGeometryByCopy();
            }
            this.setGeometry((Geometry)this.geometryByCopy);
        }
    }
}

