/*
 * Decompiled with CFR 0.152.
 */
package org.jdesktop.j3d.examples.virtual_input_device;

import java.awt.BorderLayout;
import java.awt.Frame;
import java.awt.Panel;
import javax.media.j3d.InputDevice;
import javax.media.j3d.Sensor;
import javax.media.j3d.SensorRead;
import javax.media.j3d.Transform3D;
import javax.vecmath.Tuple3f;
import javax.vecmath.Vector3f;
import org.jdesktop.j3d.examples.virtual_input_device.ButtonPositionControls;
import org.jdesktop.j3d.examples.virtual_input_device.PositionControls;
import org.jdesktop.j3d.examples.virtual_input_device.RotationControls;
import org.jdesktop.j3d.examples.virtual_input_device.WheelControls;

public class VirtualInputDevice
implements InputDevice {
    private Vector3f position = new Vector3f();
    private Transform3D newTransform = new Transform3D();
    Sensor[] sensors = new Sensor[1];
    private RotationControls rotControls;
    private PositionControls positionControls;
    private Transform3D rotTransX = new Transform3D();
    private Transform3D rotTransY = new Transform3D();
    private Transform3D rotTransZ = new Transform3D();
    private Vector3f initPos = new Vector3f();
    private int processingMode;
    private SensorRead sensorRead = new SensorRead();
    private boolean printvalues = false;
    private int xscreeninitloc = 400;
    private int yscreeninitloc = 0;
    private int xscreensize = 400;
    private int yscreensize = 200;
    private float xobjinitloc = 0.0f;
    private float yobjinitloc = 0.0f;
    private float zobjinitloc = 2.2f;
    private float xaxisrotinit = 0.0f;
    private float yaxisrotinit = 0.0f;
    private float zaxisrotinit = 0.0f;

    public VirtualInputDevice(String[] args) {
        for (int i = 0; i < args.length && args[i] != null; i += 2) {
            if (args[i] == "printvalues") {
                this.printvalues = Boolean.valueOf(args[i + 1]);
                continue;
            }
            if (args[i] == "xscreeninitloc") {
                this.xscreeninitloc = Integer.valueOf(args[i + 1]);
                continue;
            }
            if (args[i] == "yscreeninitloc") {
                this.yscreeninitloc = Integer.valueOf(args[i + 1]);
                continue;
            }
            if (args[i] == "xscreensize") {
                this.xscreensize = Integer.valueOf(args[i + 1]);
                continue;
            }
            if (args[i] == "yscreensize") {
                this.yscreensize = Integer.valueOf(args[i + 1]);
                continue;
            }
            if (args[i] == "xobjinitloc") {
                this.xobjinitloc = Float.valueOf(args[i + 1]).floatValue();
                continue;
            }
            if (args[i] == "yobjinitloc") {
                this.yobjinitloc = Float.valueOf(args[i + 1]).floatValue();
                continue;
            }
            if (args[i] != "zobjinitloc") continue;
            this.zobjinitloc = Integer.valueOf(args[i + 1]).floatValue();
        }
        if (this.printvalues) {
            System.out.println("Initial values for VirtualInputDevice:");
            System.out.println("xscreeninitloc = " + this.xscreeninitloc);
            System.out.println("yscreeninitloc = " + this.yscreeninitloc);
            System.out.println("xscreeninitsize = " + this.xscreensize);
            System.out.println("yscreeninitsize = " + this.yscreensize);
            System.out.println("xobjinitloc = " + this.xobjinitloc);
            System.out.println("yobjinitloc = " + this.yobjinitloc);
            System.out.println("zobjinitloc = " + this.zobjinitloc);
            System.out.println("xaxisrotinit = " + this.xaxisrotinit);
            System.out.println("yaxisrotinit = " + this.yaxisrotinit);
            System.out.println("zaxisrotinit = " + this.zaxisrotinit);
        }
        Frame deviceFrame = new Frame();
        deviceFrame.setSize(this.xscreensize, this.yscreensize);
        deviceFrame.setLocation(this.xscreeninitloc, this.yscreeninitloc);
        deviceFrame.setTitle("Virtual Input Device");
        ButtonPositionControls positionControls = new ButtonPositionControls(this.xobjinitloc, this.yobjinitloc, this.zobjinitloc);
        WheelControls rotControls = new WheelControls(this.xaxisrotinit, this.yaxisrotinit, this.zaxisrotinit);
        positionControls.setDevice(this);
        Panel devicePanel = new Panel();
        devicePanel.setLayout(new BorderLayout());
        devicePanel.add("East", positionControls);
        devicePanel.add("West", rotControls);
        deviceFrame.add(devicePanel);
        deviceFrame.pack();
        deviceFrame.setVisible(true);
        this.initPos.set(this.xobjinitloc, this.yobjinitloc, this.zobjinitloc);
        this.positionControls = positionControls;
        this.rotControls = rotControls;
        this.processingMode = 5;
        this.sensors[0] = new Sensor((InputDevice)this);
    }

    public void close() {
    }

    public int getProcessingMode() {
        return this.processingMode;
    }

    public int getSensorCount() {
        return this.sensors.length;
    }

    public Sensor getSensor(int sensorIndex) {
        return this.sensors[sensorIndex];
    }

    public boolean initialize() {
        return true;
    }

    public void pollAndProcessInput() {
        this.sensorRead.setTime(System.currentTimeMillis());
        this.rotTransX.rotX((double)(-this.rotControls.getXAngle()));
        this.rotTransY.rotY((double)(-this.rotControls.getYAngle()));
        this.rotTransZ.rotZ((double)(-this.rotControls.getZAngle()));
        this.positionControls.getPosition(this.position);
        this.newTransform.set(this.position);
        this.newTransform.mul(this.rotTransX);
        this.newTransform.mul(this.rotTransY);
        this.newTransform.mul(this.rotTransZ);
        this.sensorRead.set(this.newTransform);
        this.sensors[0].setNextSensorRead(this.sensorRead);
    }

    public void processStreamInput() {
    }

    public void setNominalPositionAndOrientation() {
        this.sensorRead.setTime(System.currentTimeMillis());
        this.rotTransX.rotX((double)this.xaxisrotinit);
        this.rotTransY.rotY((double)this.yaxisrotinit);
        this.rotTransZ.rotZ((double)this.zaxisrotinit);
        this.position.set((Tuple3f)this.initPos);
        this.newTransform.set(this.position);
        this.newTransform.mul(this.rotTransX);
        this.newTransform.mul(this.rotTransY);
        this.newTransform.mul(this.rotTransZ);
        this.sensorRead.set(this.newTransform);
        this.sensors[0].setNextSensorRead(this.sensorRead);
        this.rotControls.reset();
        this.positionControls.setPosition(this.initPos);
    }

    public void setProcessingMode(int mode) {
        switch (mode) {
            case 3: 
            case 4: 
            case 5: {
                this.processingMode = mode;
                break;
            }
            default: {
                throw new IllegalArgumentException("Processing mode must be one of DEMAND_DRIVEN, NON_BLOCKING, or BLOCKING");
            }
        }
    }
}

