/*
 * Decompiled with CFR 0.152.
 */
package org.jdesktop.j3d.examples.virtual_input_device;

import java.awt.Canvas;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Point;
import java.awt.Polygon;
import java.awt.Rectangle;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionListener;
import java.awt.geom.AffineTransform;
import org.jdesktop.j3d.examples.virtual_input_device.RotationControls;

public class WheelControls
extends Canvas
implements RotationControls,
MouseMotionListener,
MouseListener {
    private static final int NONE = 0;
    private static final int SLIDE_Y = 1;
    private static final int SLIDE_X = 2;
    private static final int SLIDE_Z = 3;
    private int mode = 0;
    private Dimension size;
    private int thickness;
    private int diameter;
    private int space;
    private int pipSize;
    private int pipOffset;
    private int margin;
    private Polygon yPip;
    private Rectangle yBackClip;
    private Polygon xPip;
    private Rectangle xBackClip;
    private Polygon zPip;
    private Rectangle yArea;
    private Rectangle xArea;
    private Rectangle zArea;
    private Point oldMousePos = new Point();
    float yAngle = 0.0f;
    float xAngle = 0.0f;
    float zAngle = 0.0f;
    float yOrigAngle;
    float xOrigAngle;
    float zOrigAngle;
    float angleStep = 0.10471976f;

    public WheelControls() {
        this(0.0f, 0.0f, 0.0f);
    }

    public WheelControls(float rotX, float rotY, float rotZ) {
        this.size = new Dimension(200, 200);
        this.xAngle = this.constrainAngle(rotX);
        this.yAngle = this.constrainAngle(rotY);
        this.zAngle = this.constrainAngle(rotZ);
        this.yOrigAngle = this.yAngle;
        this.xOrigAngle = this.xAngle;
        this.zOrigAngle = this.zAngle;
        this.setSizes();
        this.yPip = new Polygon();
        this.yPip.addPoint(0, 0);
        this.yPip.addPoint(-this.pipSize / 2, this.pipSize);
        this.yPip.addPoint(this.pipSize / 2, this.pipSize);
        this.xPip = new Polygon();
        this.xPip.addPoint(0, 0);
        this.xPip.addPoint(this.pipSize, -this.pipSize / 2);
        this.xPip.addPoint(this.pipSize, this.pipSize / 2);
        this.zPip = new Polygon();
        this.zPip.addPoint(this.diameter / 2, this.pipOffset);
        this.zPip.addPoint(this.diameter / 2 - this.pipSize / 2, this.pipOffset - this.pipSize);
        this.zPip.addPoint(this.diameter / 2 + this.pipSize / 2, this.pipOffset - this.pipSize);
        this.addMouseListener(this);
        this.addMouseMotionListener(this);
    }

    private void setSizes() {
        this.margin = 10;
        int width = this.size.width - this.margin * 2;
        this.thickness = width * 7 / 100;
        this.diameter = width * 70 / 100;
        this.space = width * 10 / 100;
        this.pipSize = width * 7 / 100;
        this.pipOffset = this.thickness / 2;
    }

    public void paint(Graphics g) {
        Graphics2D g2 = (Graphics2D)g;
        g.drawOval(this.margin, this.margin, this.diameter, this.diameter);
        this.zArea = new Rectangle(this.margin, this.margin, this.diameter, this.diameter);
        this.drawZPip(g2, this.zAngle);
        g.drawRect(this.margin, this.margin + this.diameter + this.space, this.diameter, this.thickness);
        this.yArea = new Rectangle(this.margin, this.margin + this.diameter + this.space, this.margin + this.diameter, this.thickness + this.pipOffset);
        this.yBackClip = new Rectangle(this.margin - this.thickness, this.margin + this.diameter + this.space + this.thickness, this.margin + this.diameter + this.thickness * 2, this.thickness);
        this.drawYPip(g2, this.yAngle);
        g.drawRect(this.margin + this.diameter + this.space, this.margin, this.thickness, this.diameter);
        this.xArea = new Rectangle(this.margin + this.diameter + this.space, this.margin, this.thickness + this.pipOffset, this.margin + this.diameter);
        this.xBackClip = new Rectangle(this.margin + this.diameter + this.space + this.thickness, this.margin - this.thickness, this.thickness, this.margin + this.diameter + this.thickness * 2);
        this.drawXPip(g2, this.xAngle);
    }

    public float getXAngle() {
        return this.xAngle;
    }

    public float getYAngle() {
        return this.yAngle;
    }

    public float getZAngle() {
        return this.zAngle;
    }

    public void reset() {
        this.drawYPip((Graphics2D)this.getGraphics(), this.yAngle);
        this.yAngle = this.yOrigAngle;
        this.drawYPip((Graphics2D)this.getGraphics(), this.yAngle);
        this.drawXPip((Graphics2D)this.getGraphics(), this.xAngle);
        this.xAngle = this.xOrigAngle;
        this.drawXPip((Graphics2D)this.getGraphics(), this.xAngle);
        this.drawZPip((Graphics2D)this.getGraphics(), this.zAngle);
        this.zAngle = this.zOrigAngle;
        this.drawZPip((Graphics2D)this.getGraphics(), this.zAngle);
        this.oldMousePos.setLocation(0, 0);
    }

    private void drawXPip(Graphics2D g2, float angle) {
        AffineTransform trans = new AffineTransform();
        int xOrig = this.margin + this.diameter + this.space;
        int yOrig = this.margin;
        Color origColor = g2.getColor();
        int y = (double)angle <= Math.PI ? yOrig + this.diameter - (int)(Math.abs((double)angle - 1.5707963267948966) / 1.5707963267948966 * (double)this.diameter / 2.0) : yOrig + (int)(Math.abs((double)angle - 4.71238898038469) / 1.5707963267948966 * (double)this.diameter / 2.0);
        if ((double)angle < 1.5707963267948966 || (double)angle > 4.71238898038469) {
            g2.setColor(Color.red);
        } else {
            g2.setColor(Color.black);
            g2.setClip(this.xBackClip);
        }
        g2.setXORMode(this.getBackground());
        trans.setToTranslation(xOrig + this.pipOffset, y);
        g2.setTransform(trans);
        g2.fillPolygon(this.xPip);
        trans.setToIdentity();
        g2.setTransform(trans);
        g2.setColor(origColor);
        g2.setPaintMode();
    }

    private void drawYPip(Graphics2D g2, float angle) {
        AffineTransform trans = new AffineTransform();
        int xOrig = this.margin;
        int yOrig = this.margin + this.diameter + this.space;
        Color origColor = g2.getColor();
        int x = (double)angle <= Math.PI ? xOrig + this.diameter - (int)(Math.abs((double)angle - 1.5707963267948966) / 1.5707963267948966 * (double)this.diameter / 2.0) : xOrig + (int)(Math.abs((double)angle - 4.71238898038469) / 1.5707963267948966 * (double)this.diameter / 2.0);
        if ((double)angle < 1.5707963267948966 || (double)angle > 4.71238898038469) {
            g2.setColor(Color.red);
        } else {
            g2.setColor(Color.black);
            g2.setClip(this.yBackClip);
        }
        g2.setXORMode(this.getBackground());
        trans.setToTranslation(x, yOrig + this.pipOffset);
        g2.setTransform(trans);
        g2.fillPolygon(this.yPip);
        trans.setToIdentity();
        g2.setTransform(trans);
        g2.setColor(origColor);
        g2.setPaintMode();
    }

    private void drawZPip(Graphics2D g2, float zAngle) {
        AffineTransform trans = new AffineTransform();
        Color origColor = g2.getColor();
        trans.translate(this.margin, this.margin);
        trans.rotate(zAngle, this.diameter / 2, this.diameter / 2);
        g2.setXORMode(this.getBackground());
        g2.setTransform(trans);
        g2.setColor(Color.red);
        g2.fillPolygon(this.zPip);
        trans.setToIdentity();
        g2.setTransform(trans);
        g2.setColor(origColor);
        g2.setPaintMode();
    }

    public Dimension getPreferredSize() {
        return this.size;
    }

    public void setSize(Dimension d) {
        this.size.width = d.width < d.height ? (this.size.height = d.width) : (this.size.height = d.height);
        this.setSizes();
    }

    public void mouseClicked(MouseEvent e) {
    }

    public void mouseEntered(MouseEvent e) {
    }

    public void mouseExited(MouseEvent e) {
    }

    public void mousePressed(MouseEvent e) {
        if (this.yArea.contains(e.getPoint())) {
            this.mode = 1;
            this.oldMousePos = e.getPoint();
        } else if (this.xArea.contains(e.getPoint())) {
            this.mode = 2;
            this.oldMousePos = e.getPoint();
        } else if (this.zArea.contains(e.getPoint())) {
            this.mode = 3;
            this.oldMousePos = e.getPoint();
        }
    }

    public void mouseReleased(MouseEvent e) {
        this.mode = 0;
    }

    public void mouseDragged(MouseEvent e) {
        Point pos = e.getPoint();
        int diffX = pos.x - this.oldMousePos.x;
        int diffY = pos.y - this.oldMousePos.y;
        switch (this.mode) {
            case 0: {
                break;
            }
            case 1: {
                this.drawYPip((Graphics2D)((Canvas)e.getSource()).getGraphics(), this.yAngle);
                if (diffX < 0) {
                    this.yAngle -= this.angleStep;
                } else if (diffX > 0) {
                    this.yAngle += this.angleStep;
                }
                this.yAngle = this.constrainAngle(this.yAngle);
                this.drawYPip((Graphics2D)((Canvas)e.getSource()).getGraphics(), this.yAngle);
                this.oldMousePos = pos;
                break;
            }
            case 2: {
                this.drawXPip((Graphics2D)((Canvas)e.getSource()).getGraphics(), this.xAngle);
                if (diffY < 0) {
                    this.xAngle -= this.angleStep;
                } else if (diffY > 0) {
                    this.xAngle += this.angleStep;
                }
                this.xAngle = this.constrainAngle(this.xAngle);
                this.drawXPip((Graphics2D)((Canvas)e.getSource()).getGraphics(), this.xAngle);
                this.oldMousePos = pos;
                break;
            }
            case 3: {
                this.drawZPip((Graphics2D)((Canvas)e.getSource()).getGraphics(), this.zAngle);
                if (diffX < 0) {
                    this.zAngle -= this.angleStep;
                } else if (diffX > 0) {
                    this.zAngle += this.angleStep;
                }
                this.zAngle = this.constrainAngle(this.zAngle);
                this.drawZPip((Graphics2D)((Canvas)e.getSource()).getGraphics(), this.zAngle);
                this.oldMousePos = pos;
                break;
            }
            default: {
                throw new RuntimeException("Internal Error");
            }
        }
    }

    public void mouseMoved(MouseEvent e) {
    }

    private float constrainAngle(float angle) {
        if (angle > (float)Math.PI * 2) {
            return angle - (float)Math.PI * 2;
        }
        if (angle < 0.0f) {
            return angle + (float)Math.PI * 2;
        }
        return angle;
    }
}

