/*
 * Decompiled with CFR 0.152.
 */
package com.sun.j3d.utils.picking;

import com.sun.j3d.utils.picking.PickResult;
import javax.media.j3d.GeometryArray;
import javax.media.j3d.IndexedGeometryArray;
import javax.vecmath.Color3b;
import javax.vecmath.Color3f;
import javax.vecmath.Color4b;
import javax.vecmath.Color4f;
import javax.vecmath.Point3d;
import javax.vecmath.Point3f;
import javax.vecmath.TexCoord2f;
import javax.vecmath.TexCoord3f;
import javax.vecmath.Tuple3d;
import javax.vecmath.Vector3d;
import javax.vecmath.Vector3f;

public class PickIntersection {
    PickResult pickResult = null;
    double distance = -1.0;
    int geomIndex = 0;
    int[] primitiveVertexIndices = null;
    Point3d[] primitiveCoordinatesVW = null;
    Point3d pointCoordinatesVW = null;
    GeometryArray geom = null;
    IndexedGeometryArray iGeom = null;
    boolean hasNormals = false;
    boolean hasColors = false;
    boolean hasTexCoords = false;
    int[] primitiveCoordinateIndices;
    int[] primitiveNormalIndices;
    int[] primitiveColorIndices;
    int[] primitiveTexCoordIndices;
    Point3d[] primitiveCoordinates = null;
    Vector3f[] primitiveNormals = null;
    Color4f[] primitiveColors = null;
    TexCoord3f[] primitiveTexCoords = null;
    Point3d pointCoordinates = null;
    Vector3f pointNormal = null;
    Color4f pointColor = null;
    TexCoord3f pointTexCoord = null;
    int closestVertexIndex = -1;
    Point3d closestVertexCoordinates = null;
    Point3d closestVertexCoordinatesVW = null;
    double[] interpWeights;
    static final boolean debug = false;
    static final int X_AXIS = 1;
    static final int Y_AXIS = 2;
    static final int Z_AXIS = 3;
    static final double TOL = 1.0E-5;

    PickIntersection(PickResult pickResult, GeometryArray geometryArray) {
        int n;
        this.pickResult = pickResult;
        this.geom = geometryArray;
        if (this.geom == null) {
            GeometryArray[] geometryArrayArray = this.pickResult.getGeometryArrays();
            this.geom = geometryArrayArray[this.geomIndex];
        }
        if (this.geom instanceof IndexedGeometryArray) {
            this.iGeom = (IndexedGeometryArray)this.geom;
        }
        this.hasColors = 0 != ((n = this.geom.getVertexFormat()) & 0xC);
        this.hasNormals = 0 != (n & 2);
        this.hasTexCoords = 0 != (n & 0x60);
    }

    public String toString() {
        int n;
        String string = new String("PickIntersection: ");
        string = string + " pickResult = " + this.pickResult + "\n";
        string = string + " geomIndex = " + this.geomIndex + "\n";
        if (this.distance != -1.0) {
            string = string + " dist:" + this.distance + "\n";
        }
        if (this.pointCoordinates != null) {
            string = string + " pt:" + this.pointCoordinates + "\n";
        }
        if (this.pointCoordinatesVW != null) {
            string = string + " ptVW:" + this.pointCoordinatesVW + "\n";
        }
        if (this.primitiveCoordinateIndices != null) {
            string = string + " prim coordinate ind:\n";
            for (n = 0; n < this.primitiveCoordinateIndices.length; ++n) {
                string = string + " " + this.primitiveCoordinateIndices[n] + "\n";
            }
        }
        if (this.primitiveColorIndices != null) {
            string = string + " prim color ind:\n";
            for (n = 0; n < this.primitiveColorIndices.length; ++n) {
                string = string + " " + this.primitiveColorIndices[n] + "\n";
            }
        }
        if (this.primitiveNormalIndices != null) {
            string = string + " prim normal ind:\n";
            for (n = 0; n < this.primitiveNormalIndices.length; ++n) {
                string = string + " " + this.primitiveNormalIndices[n] + "\n";
            }
        }
        if (this.primitiveTexCoordIndices != null) {
            string = string + " prim texture ind:\n";
            for (n = 0; n < this.primitiveTexCoordIndices.length; ++n) {
                string = string + " " + this.primitiveTexCoordIndices[n] + "\n";
            }
        }
        if (this.closestVertexCoordinates != null) {
            string = string + " clos. vert:" + this.closestVertexCoordinates + "\n";
        }
        if (this.closestVertexCoordinatesVW != null) {
            string = string + " clos. vert:" + this.closestVertexCoordinatesVW + "\n";
        }
        if (this.closestVertexIndex != -1) {
            string = string + " clos. vert. ind.:" + this.closestVertexIndex + "\n";
        }
        return string;
    }

    String toString2() {
        int n;
        String string = new String("PickIntersection: ");
        string = string + " geomIndex = " + this.geomIndex + "\n";
        if (this.distance != -1.0) {
            string = string + " dist:" + this.distance + "\n";
        }
        if (this.pointCoordinates != null) {
            string = string + " pt:" + this.pointCoordinates + "\n";
        }
        if (this.pointCoordinatesVW != null) {
            string = string + " ptVW:" + this.pointCoordinatesVW + "\n";
        }
        if (this.primitiveCoordinateIndices != null) {
            string = string + " prim coordinate ind:\n";
            for (n = 0; n < this.primitiveCoordinateIndices.length; ++n) {
                string = string + " " + this.primitiveCoordinateIndices[n] + "\n";
            }
        }
        if (this.primitiveColorIndices != null) {
            string = string + " prim color ind:\n";
            for (n = 0; n < this.primitiveColorIndices.length; ++n) {
                string = string + " " + this.primitiveColorIndices[n] + "\n";
            }
        }
        if (this.primitiveNormalIndices != null) {
            string = string + " prim normal ind:\n";
            for (n = 0; n < this.primitiveNormalIndices.length; ++n) {
                string = string + " " + this.primitiveNormalIndices[n] + "\n";
            }
        }
        if (this.primitiveTexCoordIndices != null) {
            string = string + " prim texture ind:\n";
            for (n = 0; n < this.primitiveTexCoordIndices.length; ++n) {
                string = string + " " + this.primitiveTexCoordIndices[n] + "\n";
            }
        }
        if (this.closestVertexCoordinates != null) {
            string = string + " clos. vert:" + this.closestVertexCoordinates + "\n";
        }
        if (this.closestVertexCoordinatesVW != null) {
            string = string + " clos. vert:" + this.closestVertexCoordinatesVW + "\n";
        }
        if (this.closestVertexIndex != -1) {
            string = string + " clos. vert. ind.:" + this.closestVertexIndex + "\n";
        }
        return string;
    }

    PickResult getPickResult() {
        return this.pickResult;
    }

    void setGeomIndex(int n) {
        if (this.geomIndex != n) {
            int n2;
            GeometryArray[] geometryArrayArray = this.pickResult.getGeometryArrays();
            this.geom = geometryArrayArray[n];
            if (this.geom instanceof IndexedGeometryArray) {
                this.iGeom = (IndexedGeometryArray)this.geom;
            }
            this.hasColors = 0 != ((n2 = this.geom.getVertexFormat()) & 0xC);
            this.hasNormals = 0 != (n2 & 2);
            this.hasTexCoords = 0 != (n2 & 0x60);
        }
        this.geomIndex = n;
    }

    void setPointCoordinatesVW(Point3d point3d) {
        if (this.pointCoordinatesVW == null) {
            this.pointCoordinatesVW = new Point3d();
        }
        this.pointCoordinatesVW.x = point3d.x;
        this.pointCoordinatesVW.y = point3d.y;
        this.pointCoordinatesVW.z = point3d.z;
    }

    public Point3d getPointCoordinatesVW() {
        return this.pointCoordinatesVW;
    }

    public double getDistance() {
        return this.distance;
    }

    void setDistance(double d) {
        this.distance = d;
    }

    void setPrimitiveCoordinatesVW(Point3d[] point3dArray) {
        this.primitiveCoordinatesVW = new Point3d[point3dArray.length];
        System.arraycopy(point3dArray, 0, this.primitiveCoordinatesVW, 0, point3dArray.length);
    }

    public Point3d[] getPrimitiveCoordinatesVW() {
        return this.primitiveCoordinatesVW;
    }

    void setVertexIndices(int[] nArray) {
        this.primitiveVertexIndices = new int[nArray.length];
        System.arraycopy(nArray, 0, this.primitiveVertexIndices, 0, nArray.length);
    }

    public int[] getPrimitiveVertexIndices() {
        return this.primitiveVertexIndices;
    }

    public int getGeometryArrayIndex() {
        return this.geomIndex;
    }

    public GeometryArray getGeometryArray() {
        if (this.geom == null) {
            int n;
            GeometryArray[] geometryArrayArray = this.pickResult.getGeometryArrays();
            this.geom = geometryArrayArray[this.geomIndex];
            if (this.geom instanceof IndexedGeometryArray) {
                this.iGeom = (IndexedGeometryArray)this.geom;
            }
            this.hasColors = 0 != ((n = this.geom.getVertexFormat()) & 0xC);
            this.hasNormals = 0 != (n & 2);
            this.hasTexCoords = 0 != (n & 0x60);
        }
        return this.geom;
    }

    public boolean geometryIsIndexed() {
        GeometryArray geometryArray = this.getGeometryArray();
        return this.iGeom != null;
    }

    public Point3d getClosestVertexCoordinates() {
        if (this.closestVertexCoordinates == null) {
            int n = this.getClosestVertexIndex();
            int n2 = this.geom.getVertexFormat();
            int[] nArray = this.getPrimitiveCoordinateIndices();
            if ((n2 & 0x80) == 0) {
                this.closestVertexCoordinates = new Point3d();
                this.geom.getCoordinate(nArray[n], this.closestVertexCoordinates);
            } else if ((n2 & 0x100) == 0) {
                double[] dArray = this.geom.getCoordRefDouble();
                if (dArray == null) {
                    float[] fArray = this.geom.getCoordRefFloat();
                    if (fArray == null) {
                        Point3f[] point3fArray = this.geom.getCoordRef3f();
                        if (point3fArray == null) {
                            Point3d[] point3dArray = this.geom.getCoordRef3d();
                            this.closestVertexCoordinates = new Point3d(point3dArray[nArray[n]].x, point3dArray[nArray[n]].y, point3dArray[nArray[n]].z);
                        } else {
                            this.closestVertexCoordinates = new Point3d((double)point3fArray[nArray[n]].x, (double)point3fArray[nArray[n]].y, (double)point3fArray[nArray[n]].z);
                        }
                    } else {
                        int n3 = nArray[n] * 3;
                        this.closestVertexCoordinates = new Point3d((double)fArray[n3], (double)fArray[n3 + 1], (double)fArray[n3 + 2]);
                    }
                } else {
                    int n4 = nArray[n] * 3;
                    this.closestVertexCoordinates = new Point3d(dArray[n4], dArray[n4 + 1], dArray[n4 + 2]);
                }
            } else {
                float[] fArray = this.geom.getInterleavedVertices();
                int n5 = this.getInterleavedVertexOffset(this.geom);
                int n6 = n5 + 3;
                int n7 = n6 * nArray[n] + n5;
                this.closestVertexCoordinates = new Point3d((double)fArray[n7], (double)fArray[n7 + 1], (double)fArray[n7 + 2]);
            }
        }
        return this.closestVertexCoordinates;
    }

    public Point3d getClosestVertexCoordinatesVW() {
        if (this.closestVertexCoordinatesVW == null) {
            int n = this.getClosestVertexIndex();
            Point3d[] point3dArray = this.getPrimitiveCoordinatesVW();
            this.closestVertexCoordinatesVW = point3dArray[n];
        }
        return this.closestVertexCoordinatesVW;
    }

    public int getClosestVertexIndex() {
        if (this.closestVertexIndex == -1) {
            this.storeClosestVertex();
        }
        return this.closestVertexIndex;
    }

    void storeClosestVertex() {
        if (this.closestVertexIndex == -1) {
            double d = Double.MAX_VALUE;
            double d2 = Double.MAX_VALUE;
            int n = -1;
            for (int i = 0; i < this.primitiveCoordinatesVW.length; ++i) {
                d2 = this.pointCoordinatesVW.distance(this.primitiveCoordinatesVW[i]);
                if (!(d2 < d)) continue;
                n = i;
                d = d2;
            }
            this.closestVertexIndex = n;
        }
    }

    public int[] getPrimitiveCoordinateIndices() {
        if (this.primitiveCoordinateIndices == null) {
            if (this.geometryIsIndexed()) {
                this.primitiveCoordinateIndices = new int[this.primitiveVertexIndices.length];
                for (int i = 0; i < this.primitiveVertexIndices.length; ++i) {
                    this.primitiveCoordinateIndices[i] = this.iGeom.getCoordinateIndex(this.primitiveVertexIndices[i]);
                }
            } else {
                this.primitiveCoordinateIndices = this.primitiveVertexIndices;
            }
        }
        return this.primitiveCoordinateIndices;
    }

    public Point3d[] getPrimitiveCoordinates() {
        block16: {
            if (this.primitiveCoordinates != null) break block16;
            this.primitiveCoordinates = new Point3d[this.primitiveVertexIndices.length];
            int[] nArray = this.getPrimitiveCoordinateIndices();
            int n = this.geom.getVertexFormat();
            if ((n & 0x80) == 0) {
                for (int i = 0; i < nArray.length; ++i) {
                    this.primitiveCoordinates[i] = new Point3d();
                    this.geom.getCoordinate(nArray[i], this.primitiveCoordinates[i]);
                }
            } else if ((n & 0x100) == 0) {
                double[] dArray = this.geom.getCoordRefDouble();
                if (dArray == null) {
                    float[] fArray = this.geom.getCoordRefFloat();
                    if (fArray == null) {
                        Point3f[] point3fArray = this.geom.getCoordRef3f();
                        if (point3fArray == null) {
                            Point3d[] point3dArray = this.geom.getCoordRef3d();
                            for (int i = 0; i < nArray.length; ++i) {
                                this.primitiveCoordinates[i] = new Point3d(point3dArray[nArray[i]].x, point3dArray[nArray[i]].y, point3dArray[nArray[i]].z);
                            }
                        } else {
                            for (int i = 0; i < nArray.length; ++i) {
                                this.primitiveCoordinates[i] = new Point3d((double)point3fArray[nArray[i]].x, (double)point3fArray[nArray[i]].y, (double)point3fArray[nArray[i]].z);
                            }
                        }
                    } else {
                        for (int i = 0; i < nArray.length; ++i) {
                            int n2 = nArray[i] * 3;
                            this.primitiveCoordinates[i] = new Point3d((double)fArray[n2], (double)fArray[n2 + 1], (double)fArray[n2 + 2]);
                        }
                    }
                } else {
                    for (int i = 0; i < nArray.length; ++i) {
                        int n3 = nArray[i] * 3;
                        this.primitiveCoordinates[i] = new Point3d(dArray[n3], dArray[n3 + 1], dArray[n3 + 2]);
                    }
                }
            } else {
                float[] fArray = this.geom.getInterleavedVertices();
                int n4 = this.getInterleavedVertexOffset(this.geom);
                int n5 = n4 + 3;
                for (int i = 0; i < nArray.length; ++i) {
                    int n6 = n5 * nArray[i] + n4;
                    this.primitiveCoordinates[i] = new Point3d((double)fArray[n6], (double)fArray[n6 + 1], (double)fArray[n6 + 2]);
                }
            }
        }
        return this.primitiveCoordinates;
    }

    int getInterleavedVertexOffset(GeometryArray geometryArray) {
        int n = 0;
        int n2 = geometryArray.getVertexFormat();
        if ((n2 & 4) == 4) {
            n += 3;
        } else if ((n2 & 0xC) == 12) {
            n += 4;
        }
        if ((n2 & 2) != 0) {
            n += 3;
        }
        if ((n2 & 0x20) == 32) {
            n += 2 * geometryArray.getTexCoordSetCount();
        } else if ((n2 & 0x40) == 64) {
            n += 3 * geometryArray.getTexCoordSetCount();
        }
        return n;
    }

    int getInterleavedStride(GeometryArray geometryArray) {
        int n = 3;
        int n2 = geometryArray.getVertexFormat();
        if ((n2 & 4) == 4) {
            n += 3;
        } else if ((n2 & 0xC) == 12) {
            n += 4;
        }
        if ((n2 & 2) != 0) {
            n += 3;
        }
        if ((n2 & 0x20) == 32) {
            n += 2 * geometryArray.getTexCoordSetCount();
        } else if ((n2 & 0x40) == 64) {
            n += 3 * geometryArray.getTexCoordSetCount();
        }
        return n;
    }

    int getInterleavedColorOffset(GeometryArray geometryArray) {
        int n = 0;
        int n2 = geometryArray.getVertexFormat();
        if ((n2 & 0x20) == 32) {
            n += 2 * geometryArray.getTexCoordSetCount();
        } else if ((n2 & 0x40) == 64) {
            n += 3 * geometryArray.getTexCoordSetCount();
        }
        return n;
    }

    int getInterleavedNormalOffset(GeometryArray geometryArray) {
        int n = 0;
        int n2 = geometryArray.getVertexFormat();
        if ((n2 & 0x20) == 32) {
            n += 2 * geometryArray.getTexCoordSetCount();
        } else if ((n2 & 0x40) == 64) {
            n += 3 * geometryArray.getTexCoordSetCount();
        }
        if ((n2 & 4) == 4) {
            n += 3;
        } else if ((n2 & 0xC) == 12) {
            n += 4;
        }
        return n;
    }

    public int[] getPrimitiveNormalIndices() {
        if (this.hasNormals && this.primitiveNormalIndices == null) {
            if (this.geometryIsIndexed()) {
                this.primitiveNormalIndices = new int[this.primitiveVertexIndices.length];
                for (int i = 0; i < this.primitiveVertexIndices.length; ++i) {
                    this.primitiveNormalIndices[i] = this.iGeom.getNormalIndex(this.primitiveVertexIndices[i]);
                }
            } else {
                this.primitiveNormalIndices = this.primitiveVertexIndices;
            }
        }
        return this.primitiveNormalIndices;
    }

    public Vector3f[] getPrimitiveNormals() {
        block10: {
            if (!this.hasNormals || this.primitiveNormals != null) break block10;
            this.primitiveNormals = new Vector3f[this.primitiveVertexIndices.length];
            int[] nArray = this.getPrimitiveNormalIndices();
            int n = this.geom.getVertexFormat();
            if ((n & 0x80) == 0) {
                for (int i = 0; i < nArray.length; ++i) {
                    this.primitiveNormals[i] = new Vector3f();
                    this.geom.getNormal(nArray[i], this.primitiveNormals[i]);
                }
            } else if ((n & 0x100) == 0) {
                float[] fArray = this.geom.getNormalRefFloat();
                if (fArray != null) {
                    for (int i = 0; i < nArray.length; ++i) {
                        int n2 = nArray[i] * 3;
                        this.primitiveNormals[i] = new Vector3f(fArray[n2], fArray[n2 + 1], fArray[n2 + 2]);
                    }
                } else {
                    Vector3f[] vector3fArray = this.geom.getNormalRef3f();
                    for (int i = 0; i < nArray.length; ++i) {
                        this.primitiveNormals[i] = new Vector3f(vector3fArray[nArray[i]].x, vector3fArray[nArray[i]].y, vector3fArray[nArray[i]].z);
                    }
                }
            } else {
                float[] fArray = this.geom.getInterleavedVertices();
                int n3 = this.getInterleavedColorOffset(this.geom);
                int n4 = this.getInterleavedStride(this.geom);
                for (int i = 0; i < nArray.length; ++i) {
                    int n5 = n4 * nArray[i] + n3;
                    this.primitiveNormals[i] = new Vector3f(fArray[n5], fArray[n5 + 1], fArray[n5 + 2]);
                }
            }
        }
        return this.primitiveNormals;
    }

    public int[] getPrimitiveColorIndices() {
        if (this.hasColors && this.primitiveColorIndices == null) {
            if (this.geometryIsIndexed()) {
                this.primitiveColorIndices = new int[this.primitiveVertexIndices.length];
                for (int i = 0; i < this.primitiveVertexIndices.length; ++i) {
                    this.primitiveColorIndices[i] = this.iGeom.getColorIndex(this.primitiveVertexIndices[i]);
                }
            } else {
                this.primitiveColorIndices = this.primitiveVertexIndices;
            }
        }
        return this.primitiveColorIndices;
    }

    public Color4f[] getPrimitiveColors() {
        block31: {
            if (!this.hasColors || this.primitiveColors != null) break block31;
            this.primitiveColors = new Color4f[this.primitiveVertexIndices.length];
            int[] nArray = this.getPrimitiveColorIndices();
            int n = this.geom.getVertexFormat();
            if ((n & 0x80) == 0) {
                if ((n & 0xC) == 12) {
                    for (int i = 0; i < nArray.length; ++i) {
                        this.primitiveColors[i] = new Color4f();
                        this.geom.getColor(nArray[i], this.primitiveColors[i]);
                    }
                } else {
                    Color3f color3f = new Color3f();
                    for (int i = 0; i < nArray.length; ++i) {
                        this.primitiveColors[i] = new Color4f();
                        this.geom.getColor(nArray[i], color3f);
                        this.primitiveColors[i].x = color3f.x;
                        this.primitiveColors[i].y = color3f.y;
                        this.primitiveColors[i].z = color3f.z;
                        this.primitiveColors[i].w = 1.0f;
                    }
                }
            } else if ((n & 0x100) == 0) {
                float[] fArray = this.geom.getColorRefFloat();
                if (fArray == null) {
                    byte[] byArray = this.geom.getColorRefByte();
                    if (byArray == null) {
                        Color3f[] color3fArray = this.geom.getColorRef3f();
                        if (color3fArray == null) {
                            Color4f[] color4fArray = this.geom.getColorRef4f();
                            if (color4fArray == null) {
                                Color3b[] color3bArray = this.geom.getColorRef3b();
                                if (color3bArray == null) {
                                    Color4b[] color4bArray = this.geom.getColorRef4b();
                                    for (int i = 0; i < nArray.length; ++i) {
                                        this.primitiveColors[i] = new Color4f((float)color4bArray[nArray[i]].x, (float)color4bArray[nArray[i]].y, (float)color4bArray[nArray[i]].z, (float)color4bArray[nArray[i]].w);
                                    }
                                } else {
                                    for (int i = 0; i < nArray.length; ++i) {
                                        this.primitiveColors[i] = new Color4f((float)color3bArray[nArray[i]].x, (float)color3bArray[nArray[i]].y, (float)color3bArray[nArray[i]].z, 1.0f);
                                    }
                                }
                            } else {
                                for (int i = 0; i < nArray.length; ++i) {
                                    this.primitiveColors[i] = new Color4f(color4fArray[nArray[i]].x, color4fArray[nArray[i]].y, color4fArray[nArray[i]].z, color4fArray[nArray[i]].w);
                                }
                            }
                        } else {
                            for (int i = 0; i < nArray.length; ++i) {
                                this.primitiveColors[i] = new Color4f(color3fArray[nArray[i]].x, color3fArray[nArray[i]].y, color3fArray[nArray[i]].z, 1.0f);
                            }
                        }
                    } else if ((n & 0xC) == 12) {
                        for (int i = 0; i < nArray.length; ++i) {
                            int n2 = nArray[i] << 2;
                            this.primitiveColors[i] = new Color4f((float)byArray[n2], (float)byArray[n2 + 1], (float)byArray[n2 + 2], (float)byArray[n2 + 3]);
                        }
                    } else {
                        for (int i = 0; i < nArray.length; ++i) {
                            int n3 = nArray[i] * 3;
                            this.primitiveColors[i] = new Color4f((float)byArray[n3], (float)byArray[n3 + 1], (float)byArray[n3 + 2], 1.0f);
                        }
                    }
                } else if ((n & 0xC) == 12) {
                    for (int i = 0; i < nArray.length; ++i) {
                        int n4 = nArray[i] << 2;
                        this.primitiveColors[i] = new Color4f(fArray[n4], fArray[n4 + 1], fArray[n4 + 2], fArray[n4 + 3]);
                    }
                } else {
                    for (int i = 0; i < nArray.length; ++i) {
                        int n5 = nArray[i] * 3;
                        this.primitiveColors[i] = new Color4f(fArray[n5], fArray[n5 + 1], fArray[n5 + 2], 1.0f);
                    }
                }
            } else {
                float[] fArray = this.geom.getInterleavedVertices();
                int n6 = this.getInterleavedColorOffset(this.geom);
                int n7 = this.getInterleavedStride(this.geom);
                for (int i = 0; i < nArray.length; ++i) {
                    int n8 = n7 * nArray[i] + n6;
                    this.primitiveColors[i] = (n & 0xC) == 12 ? new Color4f(fArray[n8], fArray[n8 + 1], fArray[n8 + 2], fArray[n8 + 3]) : new Color4f(fArray[n8], fArray[n8 + 1], fArray[n8 + 2], 1.0f);
                }
            }
        }
        return this.primitiveColors;
    }

    public int[] getPrimitiveTexCoordIndices(int n) {
        if (this.hasTexCoords && this.primitiveTexCoordIndices == null) {
            if (this.geometryIsIndexed()) {
                this.primitiveTexCoordIndices = new int[this.primitiveVertexIndices.length];
                for (int i = 0; i < this.primitiveVertexIndices.length; ++i) {
                    this.primitiveTexCoordIndices[i] = this.iGeom.getTextureCoordinateIndex(n, this.primitiveVertexIndices[i]);
                }
            } else {
                this.primitiveTexCoordIndices = this.primitiveVertexIndices;
            }
        }
        return this.primitiveTexCoordIndices;
    }

    public TexCoord3f[] getPrimitiveTexCoords(int n) {
        block16: {
            if (this.primitiveTexCoords != null) break block16;
            this.primitiveTexCoords = new TexCoord3f[this.primitiveVertexIndices.length];
            int[] nArray = this.getPrimitiveTexCoordIndices(n);
            int n2 = this.geom.getVertexFormat();
            if ((n2 & 0x80) == 0) {
                for (int i = 0; i < nArray.length; ++i) {
                    this.primitiveTexCoords[i] = new TexCoord3f();
                    this.geom.getTextureCoordinate(n, nArray[i], this.primitiveTexCoords[i]);
                }
            } else if ((n2 & 0x100) == 0) {
                float[] fArray = this.geom.getTexCoordRefFloat(n);
                if (fArray != null) {
                    if ((n2 & 0x20) == 32) {
                        for (int i = 0; i < nArray.length; ++i) {
                            int n3 = nArray[i] << 1;
                            this.primitiveTexCoords[i] = new TexCoord3f(fArray[n3], fArray[n3 + 1], 0.0f);
                        }
                    } else {
                        for (int i = 0; i < nArray.length; ++i) {
                            int n4 = nArray[i] * 3;
                            this.primitiveTexCoords[i] = new TexCoord3f(fArray[n4], fArray[n4 + 1], fArray[n4 + 2]);
                        }
                    }
                } else {
                    TexCoord2f[] texCoord2fArray = this.geom.getTexCoordRef2f(n);
                    if (texCoord2fArray != null) {
                        for (int i = 0; i < nArray.length; ++i) {
                            this.primitiveTexCoords[i] = new TexCoord3f(texCoord2fArray[nArray[i]].x, texCoord2fArray[nArray[i]].y, 0.0f);
                        }
                    } else {
                        TexCoord3f[] texCoord3fArray = this.geom.getTexCoordRef3f(n);
                        for (int i = 0; i < nArray.length; ++i) {
                            this.primitiveTexCoords[i] = new TexCoord3f(texCoord3fArray[nArray[i]].x, texCoord3fArray[nArray[i]].y, texCoord3fArray[nArray[i]].z);
                        }
                    }
                }
            } else {
                float[] fArray = this.geom.getInterleavedVertices();
                int n5 = this.getInterleavedStride(this.geom);
                int n6 = (n2 & 0x20) == 32 ? n << 1 : n * 3;
                for (int i = 0; i < nArray.length; ++i) {
                    int n7 = n5 * nArray[i];
                    this.primitiveTexCoords[i] = (n2 & 0x20) == 32 ? new TexCoord3f(fArray[n7 + n6], fArray[n7 + 1 + n6], 0.0f) : new TexCoord3f(fArray[n7 + n6], fArray[n7 + 1 + n6], fArray[n7 + 2 + n6]);
                }
            }
        }
        return this.primitiveTexCoords;
    }

    public Point3d getPointCoordinates() {
        if (this.pointCoordinates == null) {
            double[] dArray = this.getInterpWeights();
            Point3d[] point3dArray = this.getPrimitiveCoordinates();
            this.pointCoordinates = new Point3d();
            for (int i = 0; i < dArray.length; ++i) {
                this.pointCoordinates.x += dArray[i] * point3dArray[i].x;
                this.pointCoordinates.y += dArray[i] * point3dArray[i].y;
                this.pointCoordinates.z += dArray[i] * point3dArray[i].z;
            }
        }
        return this.pointCoordinates;
    }

    public Vector3f getPointNormal() {
        if (this.hasNormals && this.pointNormal == null) {
            double[] dArray = this.getInterpWeights();
            Vector3f[] vector3fArray = this.getPrimitiveNormals();
            this.pointNormal = new Vector3f();
            for (int i = 0; i < dArray.length; ++i) {
                this.pointNormal.x += (float)dArray[i] * vector3fArray[i].x;
                this.pointNormal.y += (float)dArray[i] * vector3fArray[i].y;
                this.pointNormal.z += (float)dArray[i] * vector3fArray[i].z;
            }
        }
        return this.pointNormal;
    }

    public Color4f getPointColor() {
        if (this.hasColors && this.pointColor == null) {
            double[] dArray = this.getInterpWeights();
            Color4f[] color4fArray = this.getPrimitiveColors();
            this.pointColor = new Color4f();
            for (int i = 0; i < dArray.length; ++i) {
                this.pointColor.x += (float)dArray[i] * color4fArray[i].x;
                this.pointColor.y += (float)dArray[i] * color4fArray[i].y;
                this.pointColor.z += (float)dArray[i] * color4fArray[i].z;
                this.pointColor.w += (float)dArray[i] * color4fArray[i].w;
            }
        }
        return this.pointColor;
    }

    public TexCoord3f getPointTextureCoordinate(int n) {
        if (this.hasTexCoords && this.pointTexCoord == null) {
            double[] dArray = this.getInterpWeights();
            TexCoord3f[] texCoord3fArray = this.getPrimitiveTexCoords(n);
            this.pointTexCoord = new TexCoord3f();
            for (int i = 0; i < dArray.length; ++i) {
                this.pointTexCoord.x += (float)dArray[i] * texCoord3fArray[i].x;
                this.pointTexCoord.y += (float)dArray[i] * texCoord3fArray[i].y;
                this.pointTexCoord.z += (float)dArray[i] * texCoord3fArray[i].z;
            }
        }
        return this.pointTexCoord;
    }

    double abs(double d) {
        if (d < 0.0) {
            return -d;
        }
        return d;
    }

    int maxAxis(Vector3d vector3d) {
        int n = 1;
        double d = this.abs(vector3d.x);
        if (this.abs(vector3d.y) > d) {
            n = 2;
            d = this.abs(vector3d.y);
        }
        if (this.abs(vector3d.z) > d) {
            n = 3;
        }
        return n;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    boolean interpTriangle(int n, int n2, int n3, Point3d[] point3dArray, Point3d point3d) {
        double d;
        double d2;
        int n4;
        int n5;
        int n6;
        int n7;
        double[] dArray;
        Vector3d vector3d = new Vector3d();
        Vector3d vector3d2 = new Vector3d();
        Vector3d vector3d3 = new Vector3d();
        vector3d.sub((Tuple3d)point3dArray[n2], (Tuple3d)point3dArray[n]);
        vector3d2.sub((Tuple3d)point3dArray[n3], (Tuple3d)point3dArray[n]);
        vector3d3.sub((Tuple3d)point3dArray[n3], (Tuple3d)point3dArray[n2]);
        double d3 = vector3d.lengthSquared();
        double d4 = vector3d2.lengthSquared();
        double d5 = vector3d3.lengthSquared();
        Vector3d vector3d4 = vector3d;
        double d6 = d3;
        if (d4 > d6) {
            vector3d4 = vector3d2;
            d6 = d4;
        }
        if (d5 > d6) {
            vector3d4 = vector3d3;
        }
        if ((dArray = new double[]{PickIntersection.getInterpFactorForBase(point3d, point3dArray[n2], point3dArray[n3], n7 = this.maxAxis(vector3d4)), PickIntersection.getInterpFactorForBase(point3d, point3dArray[n3], point3dArray[n], n7), PickIntersection.getInterpFactorForBase(point3d, point3dArray[n], point3dArray[n2], n7)})[0] < 0.0 || dArray[0] > 1.0) {
            n6 = n;
            n5 = n2;
            n4 = n3;
            d2 = dArray[2];
            d = 1.0 - dArray[1];
        } else if (dArray[1] < 0.0 || dArray[1] > 1.0) {
            n6 = n2;
            n5 = n3;
            n4 = n;
            d2 = dArray[0];
            d = 1.0 - dArray[2];
        } else {
            n6 = n3;
            n5 = n;
            n4 = n2;
            d2 = dArray[1];
            d = 1.0 - dArray[0];
        }
        Point3d point3d2 = new Point3d(d * point3dArray[n4].x + (1.0 - d) * point3dArray[n6].x, d * point3dArray[n4].y + (1.0 - d) * point3dArray[n6].y, d * point3dArray[n4].z + (1.0 - d) * point3dArray[n6].z);
        Point3d point3d3 = new Point3d(d2 * point3dArray[n5].x + (1.0 - d2) * point3dArray[n6].x, d2 * point3dArray[n5].y + (1.0 - d2) * point3dArray[n6].y, d2 * point3dArray[n5].z + (1.0 - d2) * point3dArray[n6].z);
        vector3d.sub((Tuple3d)point3d2, (Tuple3d)point3d3);
        int n8 = this.maxAxis(vector3d);
        double d7 = PickIntersection.getInterpFactor(point3d, point3d3, point3d2, n8);
        if (d7 < 0.0) {
            if (!(d7 + 1.0E-5 >= 0.0)) return false;
            d7 = 0.0;
        } else if (d7 > 1.0) {
            if (!(d7 - 1.0E-5 <= 1.0)) return false;
            d7 = 1.0;
        }
        this.interpWeights[n6] = 1.0 - d7 * d - d2 + d7 * d2;
        this.interpWeights[n4] = d7 * d;
        this.interpWeights[n5] = d2 - d7 * d2;
        return true;
    }

    double[] getInterpWeights() {
        Point3d point3d = this.getPointCoordinatesVW();
        Point3d[] point3dArray = this.getPrimitiveCoordinatesVW();
        if (this.interpWeights != null) {
            return this.interpWeights;
        }
        this.interpWeights = new double[point3dArray.length];
        switch (point3dArray.length) {
            case 1: {
                this.interpWeights[0] = 1.0;
                break;
            }
            case 2: {
                double d;
                Vector3d vector3d = new Vector3d();
                vector3d.sub((Tuple3d)point3dArray[1], (Tuple3d)point3dArray[0]);
                int n = this.maxAxis(vector3d);
                this.interpWeights[0] = d = (double)PickIntersection.getInterpFactor(point3d, point3dArray[1], point3dArray[0], n);
                this.interpWeights[1] = 1.0 - d;
                break;
            }
            case 3: {
                if (this.interpTriangle(0, 1, 2, point3dArray, point3d)) break;
                throw new RuntimeException("Interp point outside triangle");
            }
            case 4: {
                if (this.interpTriangle(0, 1, 2, point3dArray, point3d) || this.interpTriangle(0, 2, 3, point3dArray, point3d)) break;
                throw new RuntimeException("Interp point outside quad");
            }
            default: {
                throw new RuntimeException("Unexpected number of points.");
            }
        }
        return this.interpWeights;
    }

    private static float getInterpFactor(Point3d point3d, Point3d point3d2, Point3d point3d3, int n) {
        float f;
        switch (n) {
            case 1: {
                if (point3d2.x == point3d3.x) {
                    f = 0.0f;
                    break;
                }
                f = (float)((point3d2.x - point3d.x) / (point3d2.x - point3d3.x));
                break;
            }
            case 2: {
                if (point3d2.y == point3d3.y) {
                    f = 0.0f;
                    break;
                }
                f = (float)((point3d2.y - point3d.y) / (point3d2.y - point3d3.y));
                break;
            }
            case 3: {
                if (point3d2.z == point3d3.z) {
                    f = 0.0f;
                    break;
                }
                f = (float)((point3d2.z - point3d.z) / (point3d2.z - point3d3.z));
                break;
            }
            default: {
                throw new RuntimeException("invalid axis parameter " + n + " (must be 0-2)");
            }
        }
        return f;
    }

    private static float getInterpFactorForBase(Point3d point3d, Point3d point3d2, Point3d point3d3, int n) {
        float f;
        switch (n) {
            case 1: {
                if (point3d2.x == point3d3.x) {
                    f = Float.MAX_VALUE;
                    break;
                }
                f = (float)((point3d2.x - point3d.x) / (point3d2.x - point3d3.x));
                break;
            }
            case 2: {
                if (point3d2.y == point3d3.y) {
                    f = Float.MAX_VALUE;
                    break;
                }
                f = (float)((point3d2.y - point3d.y) / (point3d2.y - point3d3.y));
                break;
            }
            case 3: {
                if (point3d2.z == point3d3.z) {
                    f = Float.MAX_VALUE;
                    break;
                }
                f = (float)((point3d2.z - point3d.z) / (point3d2.z - point3d3.z));
                break;
            }
            default: {
                throw new RuntimeException("invalid axis parameter " + n + " (must be 0-2)");
            }
        }
        return f;
    }
}

