/*
 * Decompiled with CFR 0.152.
 */
package net.java.games.joal.util;

import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.nio.DoubleBuffer;
import java.nio.FloatBuffer;
import java.nio.IntBuffer;
import java.nio.LongBuffer;
import java.nio.ShortBuffer;

public class BufferUtils {
    public static final int SIZEOF_BYTE = 1;
    public static final int SIZEOF_SHORT = 2;
    public static final int SIZEOF_INT = 4;
    public static final int SIZEOF_FLOAT = 4;
    public static final int SIZEOF_LONG = 8;
    public static final int SIZEOF_DOUBLE = 8;

    public static ByteBuffer newByteBuffer(int n) {
        ByteBuffer byteBuffer = ByteBuffer.allocateDirect(n);
        byteBuffer.order(ByteOrder.nativeOrder());
        return byteBuffer;
    }

    public static DoubleBuffer newDoubleBuffer(int n) {
        ByteBuffer byteBuffer = BufferUtils.newByteBuffer(n * 8);
        return byteBuffer.asDoubleBuffer();
    }

    public static FloatBuffer newFloatBuffer(int n) {
        ByteBuffer byteBuffer = BufferUtils.newByteBuffer(n * 4);
        return byteBuffer.asFloatBuffer();
    }

    public static IntBuffer newIntBuffer(int n) {
        ByteBuffer byteBuffer = BufferUtils.newByteBuffer(n * 4);
        return byteBuffer.asIntBuffer();
    }

    public static LongBuffer newLongBuffer(int n) {
        ByteBuffer byteBuffer = BufferUtils.newByteBuffer(n * 8);
        return byteBuffer.asLongBuffer();
    }

    public static ShortBuffer newShortBuffer(int n) {
        ByteBuffer byteBuffer = BufferUtils.newByteBuffer(n * 2);
        return byteBuffer.asShortBuffer();
    }

    public static ByteBuffer copyByteBuffer(ByteBuffer byteBuffer) {
        ByteBuffer byteBuffer2 = BufferUtils.newByteBuffer(byteBuffer.remaining());
        byteBuffer.mark();
        byteBuffer2.put(byteBuffer);
        byteBuffer.reset();
        byteBuffer2.rewind();
        return byteBuffer2;
    }

    public static DoubleBuffer copyDoubleBuffer(DoubleBuffer doubleBuffer) {
        return BufferUtils.copyDoubleBufferAsByteBuffer(doubleBuffer).asDoubleBuffer();
    }

    public static FloatBuffer copyFloatBuffer(FloatBuffer floatBuffer) {
        return BufferUtils.copyFloatBufferAsByteBuffer(floatBuffer).asFloatBuffer();
    }

    public static IntBuffer copyIntBuffer(IntBuffer intBuffer) {
        return BufferUtils.copyIntBufferAsByteBuffer(intBuffer).asIntBuffer();
    }

    public static LongBuffer copyLongBuffer(LongBuffer longBuffer) {
        return BufferUtils.copyLongBufferAsByteBuffer(longBuffer).asLongBuffer();
    }

    public static ShortBuffer copyShortBuffer(ShortBuffer shortBuffer) {
        return BufferUtils.copyShortBufferAsByteBuffer(shortBuffer).asShortBuffer();
    }

    public static ByteBuffer copyDoubleBufferAsByteBuffer(DoubleBuffer doubleBuffer) {
        ByteBuffer byteBuffer = BufferUtils.newByteBuffer(doubleBuffer.remaining() * 8);
        doubleBuffer.mark();
        byteBuffer.asDoubleBuffer().put(doubleBuffer);
        doubleBuffer.reset();
        byteBuffer.rewind();
        return byteBuffer;
    }

    public static ByteBuffer copyFloatBufferAsByteBuffer(FloatBuffer floatBuffer) {
        ByteBuffer byteBuffer = BufferUtils.newByteBuffer(floatBuffer.remaining() * 4);
        floatBuffer.mark();
        byteBuffer.asFloatBuffer().put(floatBuffer);
        floatBuffer.reset();
        byteBuffer.rewind();
        return byteBuffer;
    }

    public static ByteBuffer copyIntBufferAsByteBuffer(IntBuffer intBuffer) {
        ByteBuffer byteBuffer = BufferUtils.newByteBuffer(intBuffer.remaining() * 4);
        intBuffer.mark();
        byteBuffer.asIntBuffer().put(intBuffer);
        intBuffer.reset();
        byteBuffer.rewind();
        return byteBuffer;
    }

    public static ByteBuffer copyLongBufferAsByteBuffer(LongBuffer longBuffer) {
        ByteBuffer byteBuffer = BufferUtils.newByteBuffer(longBuffer.remaining() * 8);
        longBuffer.mark();
        byteBuffer.asLongBuffer().put(longBuffer);
        longBuffer.reset();
        byteBuffer.rewind();
        return byteBuffer;
    }

    public static ByteBuffer copyShortBufferAsByteBuffer(ShortBuffer shortBuffer) {
        ByteBuffer byteBuffer = BufferUtils.newByteBuffer(shortBuffer.remaining() * 2);
        shortBuffer.mark();
        byteBuffer.asShortBuffer().put(shortBuffer);
        shortBuffer.reset();
        byteBuffer.rewind();
        return byteBuffer;
    }
}

