/*
 * Decompiled with CFR 0.152.
 */
package com.sun.opengl.util.texture;

import java.awt.AlphaComposite;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.color.ColorSpace;
import java.awt.image.BufferedImage;
import java.awt.image.ColorModel;
import java.awt.image.ComponentColorModel;
import java.awt.image.ComponentSampleModel;
import java.awt.image.DataBuffer;
import java.awt.image.DataBufferByte;
import java.awt.image.DataBufferDouble;
import java.awt.image.DataBufferFloat;
import java.awt.image.DataBufferInt;
import java.awt.image.DataBufferShort;
import java.awt.image.DataBufferUShort;
import java.awt.image.MultiPixelPackedSampleModel;
import java.awt.image.SampleModel;
import java.awt.image.SinglePixelPackedSampleModel;
import java.awt.image.WritableRaster;
import java.nio.Buffer;
import java.nio.ByteBuffer;
import java.nio.DoubleBuffer;
import java.nio.FloatBuffer;
import java.nio.IntBuffer;
import java.nio.LongBuffer;
import java.nio.ShortBuffer;

public class TextureData {
    private int width;
    private int height;
    private int border;
    private int pixelFormat;
    private int pixelType;
    private int internalFormat;
    private boolean mipmap;
    private boolean dataIsCompressed;
    private boolean mustFlipVertically;
    private Buffer buffer;
    private Buffer[] mipmapData;
    private Flusher flusher;
    private int rowLength;
    private int alignment;
    private int estimatedMemorySize;
    private BufferedImage imageForLazyCustomConversion;
    private boolean expectingEXTABGR;
    private boolean haveEXTABGR;
    private static final ColorModel rgbaColorModel = new ComponentColorModel(ColorSpace.getInstance(1000), new int[]{8, 8, 8, 8}, true, true, 3, 0);
    private static final ColorModel rgbColorModel = new ComponentColorModel(ColorSpace.getInstance(1000), new int[]{8, 8, 8, 0}, false, false, 1, 0);

    public TextureData(int n, int n2, int n3, int n4, int n5, int n6, boolean bl, boolean bl2, boolean bl3, Buffer buffer, Flusher flusher) throws IllegalArgumentException {
        if (bl && bl2) {
            throw new IllegalArgumentException("Can not generate mipmaps for compressed textures");
        }
        this.width = n2;
        this.height = n3;
        this.border = n4;
        this.pixelFormat = n5;
        this.pixelType = n6;
        this.internalFormat = n;
        this.mipmap = bl;
        this.dataIsCompressed = bl2;
        this.mustFlipVertically = bl3;
        this.buffer = buffer;
        this.flusher = flusher;
        this.alignment = 1;
        this.estimatedMemorySize = this.estimatedMemorySize(buffer);
    }

    public TextureData(int n, int n2, int n3, int n4, int n5, int n6, boolean bl, boolean bl2, Buffer[] bufferArray, Flusher flusher) throws IllegalArgumentException {
        this.width = n2;
        this.height = n3;
        this.border = n4;
        this.pixelFormat = n5;
        this.pixelType = n6;
        this.internalFormat = n;
        this.dataIsCompressed = bl;
        this.mustFlipVertically = bl2;
        this.mipmapData = (Buffer[])bufferArray.clone();
        this.flusher = flusher;
        this.alignment = 1;
        for (int i = 0; i < bufferArray.length; ++i) {
            this.estimatedMemorySize += this.estimatedMemorySize(bufferArray[i]);
        }
    }

    public TextureData(int n, int n2, boolean bl, BufferedImage bufferedImage) {
        this.internalFormat = n == 0 ? (bufferedImage.getColorModel().hasAlpha() ? 6408 : 6407) : n;
        this.createFromImage(bufferedImage);
        this.mipmap = bl;
        this.estimatedMemorySize = this.estimatedMemorySize(this.buffer);
    }

    public int getWidth() {
        return this.width;
    }

    public int getHeight() {
        return this.height;
    }

    public int getBorder() {
        return this.border;
    }

    public int getPixelFormat() {
        return this.pixelFormat;
    }

    public int getPixelType() {
        return this.pixelType;
    }

    public int getInternalFormat() {
        return this.internalFormat;
    }

    public boolean getMipmap() {
        return this.mipmap;
    }

    public boolean isDataCompressed() {
        return this.dataIsCompressed;
    }

    public boolean getMustFlipVertically() {
        return this.mustFlipVertically;
    }

    public Buffer getBuffer() {
        if (this.imageForLazyCustomConversion != null && (!this.expectingEXTABGR || this.expectingEXTABGR && !this.haveEXTABGR)) {
            this.createFromCustom(this.imageForLazyCustomConversion);
        }
        return this.buffer;
    }

    public Buffer[] getMipmapData() {
        return this.mipmapData;
    }

    public int getAlignment() {
        return this.alignment;
    }

    public int getRowLength() {
        return this.rowLength;
    }

    public void setWidth(int n) {
        this.width = n;
    }

    public void setHeight(int n) {
        this.height = n;
    }

    public void setBorder(int n) {
        this.border = n;
    }

    public void setPixelFormat(int n) {
        this.pixelFormat = n;
    }

    public void setPixelType(int n) {
        this.pixelType = n;
    }

    public void setInternalFormat(int n) {
        this.internalFormat = n;
    }

    public void setMipmap(boolean bl) {
        this.mipmap = bl;
    }

    public void setIsDataCompressed(boolean bl) {
        this.dataIsCompressed = bl;
    }

    public void setMustFlipVertically(boolean bl) {
        this.mustFlipVertically = bl;
    }

    public void setBuffer(Buffer buffer) {
        this.buffer = buffer;
    }

    public void setAlignment(int n) {
        this.alignment = n;
    }

    public void setRowLength(int n) {
        this.rowLength = n;
    }

    public void setHaveEXTABGR(boolean bl) {
        this.haveEXTABGR = bl;
    }

    public int getEstimatedMemorySize() {
        return this.estimatedMemorySize;
    }

    public void flush() {
        if (this.flusher != null) {
            this.flusher.flush();
            this.flusher = null;
        }
    }

    private void createNIOBufferFromImage(BufferedImage bufferedImage) {
        DataBuffer dataBuffer = bufferedImage.getRaster().getDataBuffer();
        if (dataBuffer instanceof DataBufferByte) {
            this.buffer = ByteBuffer.wrap(((DataBufferByte)dataBuffer).getData());
        } else {
            if (dataBuffer instanceof DataBufferDouble) {
                throw new RuntimeException("DataBufferDouble rasters not supported by OpenGL");
            }
            if (dataBuffer instanceof DataBufferFloat) {
                this.buffer = FloatBuffer.wrap(((DataBufferFloat)dataBuffer).getData());
            } else if (dataBuffer instanceof DataBufferInt) {
                this.buffer = IntBuffer.wrap(((DataBufferInt)dataBuffer).getData());
            } else if (dataBuffer instanceof DataBufferShort) {
                this.buffer = ShortBuffer.wrap(((DataBufferShort)dataBuffer).getData());
            } else if (dataBuffer instanceof DataBufferUShort) {
                this.buffer = ShortBuffer.wrap(((DataBufferUShort)dataBuffer).getData());
            } else {
                throw new RuntimeException("Unexpected DataBuffer type?");
            }
        }
    }

    private void createFromImage(BufferedImage bufferedImage) {
        int n;
        this.pixelType = 0;
        this.mustFlipVertically = true;
        this.width = bufferedImage.getWidth();
        this.height = bufferedImage.getHeight();
        SampleModel sampleModel = bufferedImage.getRaster().getSampleModel();
        if (sampleModel instanceof SinglePixelPackedSampleModel) {
            n = ((SinglePixelPackedSampleModel)sampleModel).getScanlineStride();
        } else if (sampleModel instanceof MultiPixelPackedSampleModel) {
            n = ((MultiPixelPackedSampleModel)sampleModel).getScanlineStride();
        } else if (sampleModel instanceof ComponentSampleModel) {
            n = ((ComponentSampleModel)sampleModel).getScanlineStride();
        } else {
            this.setupLazyCustomConversion(bufferedImage);
            return;
        }
        switch (bufferedImage.getType()) {
            case 1: {
                this.pixelFormat = 32993;
                this.pixelType = 33639;
                this.rowLength = n;
                this.alignment = 4;
                break;
            }
            case 3: {
                this.pixelFormat = 32993;
                this.pixelType = 33639;
                this.rowLength = n;
                this.alignment = 4;
                break;
            }
            case 4: {
                this.pixelFormat = 6408;
                this.pixelType = 33639;
                this.rowLength = n;
                this.alignment = 4;
                break;
            }
            case 5: {
                if (n % 3 == 0) {
                    this.pixelFormat = 32992;
                    this.pixelType = 5121;
                    this.rowLength = n / 3;
                    this.alignment = 1;
                    break;
                }
                this.setupLazyCustomConversion(bufferedImage);
                return;
            }
            case 7: {
                if (n % 4 == 0) {
                    // empty if block
                }
                this.setupLazyCustomConversion(bufferedImage);
                return;
            }
            case 8: {
                this.pixelFormat = 6407;
                this.pixelType = 33635;
                this.rowLength = n;
                this.alignment = 2;
                break;
            }
            case 9: {
                this.pixelFormat = 32993;
                this.pixelType = 33638;
                this.rowLength = n;
                this.alignment = 2;
                break;
            }
            case 10: {
                this.pixelFormat = 6409;
                this.pixelType = 5121;
                this.rowLength = n;
                this.alignment = 1;
                break;
            }
            case 11: {
                this.pixelFormat = 6409;
                this.pixelType = 5123;
                this.rowLength = n;
                this.alignment = 2;
                break;
            }
            default: {
                ColorModel colorModel = bufferedImage.getColorModel();
                if (colorModel.equals(rgbColorModel)) {
                    this.pixelFormat = 6407;
                    this.pixelType = 5121;
                    this.rowLength = n / 3;
                    this.alignment = 1;
                    break;
                }
                if (colorModel.equals(rgbaColorModel)) {
                    this.pixelFormat = 6408;
                    this.pixelType = 5121;
                    this.rowLength = n / 4;
                    this.alignment = 4;
                    break;
                }
                this.setupLazyCustomConversion(bufferedImage);
                return;
            }
        }
        this.createNIOBufferFromImage(bufferedImage);
    }

    private void setupLazyCustomConversion(BufferedImage bufferedImage) {
        this.imageForLazyCustomConversion = bufferedImage;
        boolean bl = bufferedImage.getColorModel().hasAlpha();
        this.pixelFormat = bl ? 6408 : 6407;
        this.alignment = 1;
        this.rowLength = this.width;
        boolean bl2 = bufferedImage.getType() == 2;
        DataBuffer dataBuffer = bufferedImage.getRaster().getDataBuffer();
        if (dataBuffer instanceof DataBufferByte || bl2) {
            if (this.pixelType == 0) {
                this.pixelType = 5121;
            }
        } else {
            if (dataBuffer instanceof DataBufferDouble) {
                throw new RuntimeException("DataBufferDouble rasters not supported by OpenGL");
            }
            if (dataBuffer instanceof DataBufferFloat) {
                if (this.pixelType == 0) {
                    this.pixelType = 5126;
                }
            } else if (dataBuffer instanceof DataBufferInt) {
                if (this.pixelType == 0) {
                    this.pixelType = 5125;
                }
            } else if (dataBuffer instanceof DataBufferShort) {
                if (this.pixelType == 0) {
                    this.pixelType = 5122;
                }
            } else if (dataBuffer instanceof DataBufferUShort) {
                if (this.pixelType == 0) {
                    this.pixelType = 5123;
                }
            } else {
                throw new RuntimeException("Unexpected DataBuffer type?");
            }
        }
    }

    private void createFromCustom(BufferedImage bufferedImage) {
        int n = bufferedImage.getWidth();
        int n2 = bufferedImage.getHeight();
        boolean bl = bufferedImage.getColorModel().hasAlpha();
        ColorModel colorModel = null;
        int n3 = bufferedImage.getRaster().getDataBuffer().getDataType();
        if (bufferedImage.getType() == 2) {
            n3 = 0;
        }
        colorModel = n3 == 0 ? (bl ? rgbaColorModel : rgbColorModel) : (bl ? new ComponentColorModel(ColorSpace.getInstance(1000), null, true, true, 3, n3) : new ComponentColorModel(ColorSpace.getInstance(1000), null, false, false, 1, n3));
        boolean bl2 = colorModel.isAlphaPremultiplied();
        WritableRaster writableRaster = colorModel.createCompatibleWritableRaster(n, n2);
        BufferedImage bufferedImage2 = new BufferedImage(colorModel, writableRaster, bl2, null);
        Graphics2D graphics2D = bufferedImage2.createGraphics();
        graphics2D.setComposite(AlphaComposite.Src);
        graphics2D.drawImage((Image)bufferedImage, 0, 0, null);
        graphics2D.dispose();
        this.createNIOBufferFromImage(bufferedImage2);
    }

    private int estimatedMemorySize(Buffer buffer) {
        if (buffer == null) {
            return 0;
        }
        int n = buffer.capacity();
        if (buffer instanceof ByteBuffer) {
            return n;
        }
        if (buffer instanceof IntBuffer) {
            return n * 4;
        }
        if (buffer instanceof FloatBuffer) {
            return n * 4;
        }
        if (buffer instanceof ShortBuffer) {
            return n * 2;
        }
        if (buffer instanceof LongBuffer) {
            return n * 8;
        }
        if (buffer instanceof DoubleBuffer) {
            return n * 8;
        }
        throw new RuntimeException("Unexpected buffer type " + buffer.getClass().getName());
    }

    public static interface Flusher {
        public void flush();
    }
}

