/*
 * Decompiled with CFR 0.152.
 */
package simple.xml.load;

import java.lang.reflect.Method;
import java.util.Map;
import simple.xml.load.LabelMap;
import simple.xml.load.Scanner;

final class Schema {
    private LabelMap attributes;
    private LabelMap elements;
    private Method commit;
    private Method validate;
    private Method persist;
    private Method complete;
    private Map table;

    public Schema(Scanner schema, Map table) {
        this.attributes = schema.getAttributes();
        this.elements = schema.getElements();
        this.validate = schema.getValidate();
        this.complete = schema.getComplete();
        this.commit = schema.getCommit();
        this.persist = schema.getPersist();
        this.table = table;
    }

    public LabelMap getAttributes() {
        return this.attributes;
    }

    public LabelMap getElements() {
        return this.elements;
    }

    public void commit(Object source) throws Exception {
        if (this.commit != null) {
            if (this.isContextual(this.commit)) {
                this.commit.invoke(source, this.table);
            } else {
                this.commit.invoke(source, new Object[0]);
            }
        }
    }

    public void validate(Object source) throws Exception {
        if (this.validate != null) {
            if (this.isContextual(this.validate)) {
                this.validate.invoke(source, this.table);
            } else {
                this.validate.invoke(source, new Object[0]);
            }
        }
    }

    public void persist(Object source) throws Exception {
        if (this.persist != null) {
            if (this.isContextual(this.persist)) {
                this.persist.invoke(source, this.table);
            } else {
                this.persist.invoke(source, new Object[0]);
            }
        }
    }

    public void complete(Object source) throws Exception {
        if (this.complete != null) {
            if (this.isContextual(this.complete)) {
                this.complete.invoke(source, this.table);
            } else {
                this.complete.invoke(source, new Object[0]);
            }
        }
    }

    private boolean isContextual(Method method) throws Exception {
        Class<?>[] list = method.getParameterTypes();
        if (list.length == 1) {
            return Map.class.equals(list[0]);
        }
        return false;
    }
}

