/*
 * Decompiled with CFR 0.152.
 */
package simple.xml.stream;

import java.io.Writer;
import java.util.HashSet;
import java.util.Set;
import simple.xml.stream.Format;
import simple.xml.stream.Formatter;
import simple.xml.stream.Node;
import simple.xml.stream.NodeMap;
import simple.xml.stream.OutputDocument;
import simple.xml.stream.OutputElement;
import simple.xml.stream.OutputNode;
import simple.xml.stream.OutputStack;

final class NodeWriter {
    private OutputStack stack;
    private Formatter writer;
    private Set active;

    public NodeWriter(Writer result) {
        this(result, new Format());
    }

    public NodeWriter(Writer result, Format format) {
        this.writer = new Formatter(result, format);
        this.active = new HashSet();
        this.stack = new OutputStack(this.active);
    }

    public OutputNode writeRoot() throws Exception {
        OutputDocument root = new OutputDocument(this, this.stack);
        if (this.stack.isEmpty()) {
            this.writer.writeProlog();
        }
        return root;
    }

    public boolean isCommitted(OutputNode node) {
        return !this.active.contains(node);
    }

    public void commit(OutputNode parent) throws Exception {
        if (this.stack.contains(parent)) {
            OutputNode top = this.stack.top();
            if (!this.isCommitted(top)) {
                this.writeAttributes(top);
            }
            while (this.stack.top() != parent) {
                this.writeEnd(this.stack.pop());
            }
            this.writeEnd(parent);
            this.stack.pop();
        }
    }

    public OutputNode writeElement(OutputNode parent, String name) throws Exception {
        if (this.stack.isEmpty()) {
            return this.writeStart(name);
        }
        if (this.stack.contains(parent)) {
            OutputNode top = this.stack.top();
            if (!this.isCommitted(top)) {
                this.writeAttributes(top);
            }
            while (this.stack.top() != parent) {
                this.writeEnd(this.stack.pop());
            }
            return this.writeStart(name);
        }
        return null;
    }

    private OutputNode writeStart(String name) throws Exception {
        OutputElement node = new OutputElement(this, name);
        if (name != null) {
            this.writer.writeStart(name);
        }
        return this.stack.push(node);
    }

    private void writeEnd(OutputNode node) throws Exception {
        String value = node.getValue();
        String name = node.getName();
        if (value != null) {
            this.writer.writeText(value);
        }
        this.writer.writeEnd(name);
        this.writer.flush();
    }

    private void writeAttributes(OutputNode node) throws Exception {
        NodeMap map = node.getAttributes();
        for (String name : map) {
            Node entry = map.get(name);
            String value = entry.getValue();
            this.writer.writeAttribute(name, value);
        }
        this.active.remove(node);
    }
}

