/*
 * Decompiled with CFR 0.152.
 */
package simple.xml.load;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.TreeSet;
import simple.xml.load.Factory;
import simple.xml.load.InstantiationException;
import simple.xml.load.Source;
import simple.xml.stream.InputNode;

final class CollectionFactory
extends Factory {
    public CollectionFactory(Source root, Class field) {
        super(root, field);
    }

    public Collection getInstance(InputNode node) throws Exception {
        Class type = this.getOverride(node);
        if (type != null) {
            return this.getInstance(type);
        }
        if (!this.isInstantiable(this.field)) {
            this.field = this.getConversion(this.field);
        }
        if (!this.isCollection(this.field)) {
            throw new InstantiationException("Type is not a collection %s", this.field);
        }
        return (Collection)this.field.newInstance();
    }

    public Collection getInstance(Class type) throws Exception {
        if (!this.isInstantiable(type)) {
            throw new InstantiationException("Could not instantiate class %s", type);
        }
        if (!this.isCollection(type)) {
            throw new InstantiationException("Type is not a collection %s", type);
        }
        return (Collection)type.newInstance();
    }

    public Class getConversion(Class type) throws Exception {
        if (type.isAssignableFrom(ArrayList.class)) {
            return ArrayList.class;
        }
        if (type.isAssignableFrom(HashSet.class)) {
            return HashSet.class;
        }
        if (type.isAssignableFrom(TreeSet.class)) {
            return TreeSet.class;
        }
        throw new InstantiationException("Cannot instantiate %s", type);
    }

    private boolean isCollection(Class type) {
        return Collection.class.isAssignableFrom(type);
    }
}

