/*
 * Decompiled with CFR 0.152.
 */
package simple.xml.load;

import java.lang.annotation.Annotation;
import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import simple.xml.Attribute;
import simple.xml.Element;
import simple.xml.ElementList;
import simple.xml.load.AttributeLabel;
import simple.xml.load.ElementLabel;
import simple.xml.load.ElementListLabel;
import simple.xml.load.Label;

final class LabelFactory {
    LabelFactory() {
    }

    public static Label getInstance(Field field, Annotation label) {
        try {
            Constructor factory = LabelFactory.getConstructor(label);
            if (!field.isAccessible()) {
                field.setAccessible(true);
            }
            return (Label)factory.newInstance(field, label);
        }
        catch (Exception e) {
            return null;
        }
    }

    private static Constructor getConstructor(Annotation label) throws Exception {
        return LabelFactory.getEntry(label).getConstructor();
    }

    private static Entry getEntry(Annotation label) throws Exception {
        if (label instanceof Element) {
            return new Entry(ElementLabel.class, Element.class);
        }
        if (label instanceof ElementList) {
            return new Entry(ElementListLabel.class, ElementList.class);
        }
        if (label instanceof Attribute) {
            return new Entry(AttributeLabel.class, Attribute.class);
        }
        throw new RuntimeException("Annotation not supported");
    }

    private static class Entry {
        public Class argument;
        public Class label;

        public Entry(Class label, Class argument) {
            this.argument = argument;
            this.label = label;
        }

        public Constructor getConstructor() throws Exception {
            return this.getConstructor(Field.class);
        }

        private Constructor getConstructor(Class type) throws Exception {
            return this.label.getConstructor(type, this.argument);
        }
    }
}

