/*
 * Decompiled with CFR 0.152.
 */
package simple.xml.load;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Reader;
import java.io.StringReader;
import java.io.Writer;
import java.util.HashMap;
import java.util.Map;
import simple.xml.Serializer;
import simple.xml.filter.Filter;
import simple.xml.filter.PlatformFilter;
import simple.xml.load.DefaultStrategy;
import simple.xml.load.Source;
import simple.xml.load.Strategy;
import simple.xml.load.Traverser;
import simple.xml.stream.Format;
import simple.xml.stream.InputNode;
import simple.xml.stream.NodeBuilder;
import simple.xml.stream.OutputNode;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Persister
implements Serializer {
    private Strategy strategy;
    private Filter filter;
    private Format format;

    public Persister() {
        this(new HashMap());
    }

    public Persister(Map filter) {
        this(new PlatformFilter(filter));
    }

    public Persister(Filter filter) {
        this((Strategy)new DefaultStrategy(), filter);
    }

    public Persister(Strategy strategy) {
        this(strategy, new HashMap());
    }

    public Persister(Format format) {
        this((Strategy)new DefaultStrategy(), format);
    }

    public Persister(Filter filter, Format format) {
        this((Strategy)new DefaultStrategy(), filter, format);
    }

    public Persister(Strategy strategy, Format format) {
        this(strategy, new HashMap(), format);
    }

    public Persister(Strategy strategy, Map data) {
        this(strategy, new PlatformFilter(data));
    }

    public Persister(Strategy strategy, Filter filter) {
        this(strategy, filter, new Format());
    }

    public Persister(Strategy strategy, Map data, Format format) {
        this(strategy, new PlatformFilter(data), format);
    }

    public Persister(Strategy strategy, Filter filter, Format format) {
        this.strategy = strategy;
        this.filter = filter;
        this.format = format;
    }

    @Override
    public <T> T read(Class<? extends T> type, String source) throws Exception {
        return this.read(type, new StringReader(source));
    }

    @Override
    public <T> T read(Class<? extends T> type, File source) throws Exception {
        return this.read(type, new FileInputStream(source));
    }

    @Override
    public <T> T read(Class<? extends T> type, InputStream source) throws Exception {
        return this.read(type, source, "utf-8");
    }

    @Override
    public <T> T read(Class<? extends T> type, InputStream source, String charset) throws Exception {
        return this.read(type, new InputStreamReader(source, charset));
    }

    @Override
    public <T> T read(Class<? extends T> type, Reader source) throws Exception {
        return this.read(type, NodeBuilder.read(source));
    }

    public <T> T read(Class<? extends T> type, InputNode source) throws Exception {
        return this.read(type, source, this.filter);
    }

    private <T> T read(Class<? extends T> type, InputNode node, Filter filter) throws Exception {
        return this.read(type, node, new Source(this.strategy, filter));
    }

    private <T> T read(Class<? extends T> type, InputNode node, Source source) throws Exception {
        return (T)new Traverser(source).read(node, type);
    }

    public void write(Object source, OutputNode root) throws Exception {
        this.write(source, root, this.filter);
    }

    private void write(Object source, OutputNode root, Filter filter) throws Exception {
        this.write(source, root, new Source(this.strategy, filter));
    }

    private void write(Object source, OutputNode node, Source root) throws Exception {
        new Traverser(root).write(node, source);
    }

    @Override
    public void write(Object source, File out) throws Exception {
        this.write(source, new FileOutputStream(out));
    }

    @Override
    public void write(Object source, OutputStream out) throws Exception {
        this.write(source, out, "utf-8");
    }

    @Override
    public void write(Object source, OutputStream out, String charset) throws Exception {
        this.write(source, new OutputStreamWriter(out, charset));
    }

    @Override
    public void write(Object source, Writer out) throws Exception {
        this.write(source, NodeBuilder.write(out, this.format));
    }
}

