/*
 * Decompiled with CFR 0.152.
 */
package simple.xml.load;

import simple.xml.load.Converter;
import simple.xml.load.ElementException;
import simple.xml.load.PrimitiveFactory;
import simple.xml.load.Source;
import simple.xml.stream.InputNode;
import simple.xml.stream.OutputNode;
import simple.xml.stream.Position;

final class Primitive
implements Converter {
    private PrimitiveFactory factory;
    private Source root;

    public Primitive(Source root, Class type) {
        this.factory = new PrimitiveFactory(root, type);
        this.root = root;
    }

    public Object read(InputNode node) throws Exception {
        Position line = node.getPosition();
        String name = node.getName();
        String value = node.getValue();
        if (value == null) {
            throw new ElementException("Element %s is empty at %s", name, line);
        }
        String text = this.root.getProperty(value);
        return this.factory.getInstance(text);
    }

    public void write(OutputNode node, Object source) throws Exception {
        Class<?> type = source.getClass();
        String text = this.getText(source, type);
        node.setValue(text);
    }

    private String getText(Object source, Class type) {
        if (!type.isEnum()) {
            return String.valueOf(source);
        }
        Enum value = (Enum)source;
        return value.name();
    }
}

