/*
 * Decompiled with CFR 0.152.
 */
package simple.xml.load;

import java.lang.reflect.Constructor;
import simple.xml.load.ConstructorCache;
import simple.xml.load.Factory;
import simple.xml.load.Source;

final class PrimitiveFactory
extends Factory {
    private static ConstructorCache cache = new ConstructorCache();

    public PrimitiveFactory(Source root, Class field) {
        super(root, field);
    }

    public Object getInstance(String text) throws Exception {
        if (this.field == String.class) {
            return text;
        }
        if (this.field.isEnum()) {
            return this.getEnumeration(text);
        }
        return this.getPrimitive(text);
    }

    private Object getEnumeration(String text) throws Exception {
        return Enum.valueOf(this.field, text);
    }

    private Object getPrimitive(String text) throws Exception {
        Constructor method = (Constructor)cache.get(this.field);
        if (method != null) {
            return method.newInstance(text);
        }
        method = this.getConstructor(this.field);
        if (method != null) {
            cache.cache(this.field, method);
        }
        return method.newInstance(text);
    }

    private Constructor getConstructor(Class type) throws Exception {
        Class replace = this.getConversion(type);
        return replace.getConstructor(String.class);
    }

    public Class getConversion(Class type) {
        if (type.equals(Integer.TYPE)) {
            return Integer.class;
        }
        if (type.equals(Boolean.TYPE)) {
            return Boolean.class;
        }
        if (type.equals(Float.TYPE)) {
            return Float.class;
        }
        if (type.equals(Long.TYPE)) {
            return Long.class;
        }
        if (type.equals(Double.TYPE)) {
            return Double.class;
        }
        if (type.equals(Byte.TYPE)) {
            return Byte.class;
        }
        if (type.equals(Short.TYPE)) {
            return Short.class;
        }
        return type;
    }
}

