/*
 * Decompiled with CFR 0.152.
 */
package simple.xml.load;

import simple.xml.Root;
import simple.xml.load.Composite;
import simple.xml.load.RootException;
import simple.xml.load.Source;
import simple.xml.stream.InputNode;
import simple.xml.stream.OutputNode;
import simple.xml.stream.Position;

final class Traverser {
    private Source root;

    public Traverser(Source root) {
        this.root = root;
    }

    public Object read(InputNode node, Class type) throws Exception {
        Composite factory = this.getComposite(type);
        Object value = factory.read(node);
        return this.read(node, value);
    }

    private Object read(InputNode node, Object value) throws Exception {
        Class<?> type = value.getClass();
        Root label = this.getRoot(type);
        if (label == null) {
            throw new RootException("No root annotation defined for %s", type);
        }
        Position line = node.getPosition();
        String name = node.getName();
        String root = label.name();
        if (!root.equalsIgnoreCase(name)) {
            throw new RootException("Annotation %s does not match XML element %s at %s", label, name, line);
        }
        return value;
    }

    public void write(OutputNode node, Object source) throws Exception {
        this.write(node, source, source.getClass());
    }

    public void write(OutputNode node, Object source, Class expect) throws Exception {
        Class<?> type = source.getClass();
        Root label = this.getRoot(type);
        if (label == null) {
            throw new RootException("No root annotation defined for %s", type);
        }
        this.write(node, source, expect, label.name());
    }

    private void write(OutputNode node, Object source, Class expect, String name) throws Exception {
        OutputNode child = node.getChild(name);
        Class<?> type = source.getClass();
        if (node != null) {
            this.root.setOverride(expect, source, child);
        }
        Composite composite = this.getComposite(type);
        composite.write(child, source);
        child.commit();
    }

    private Composite getComposite(Class type) {
        return new Composite(this.root, type);
    }

    private Root getRoot(Class type) throws Exception {
        while (type != null) {
            if (type.isAnnotationPresent(Root.class)) {
                return type.getAnnotation(Root.class);
            }
            type = type.getSuperclass();
        }
        return null;
    }
}

