/*
 * Decompiled with CFR 0.152.
 */
package simple.xml.stream;

import java.io.Writer;
import simple.xml.stream.Format;
import simple.xml.stream.Indenter;
import simple.xml.stream.NodeException;

final class Formatter {
    private static final char[] LESS = new char[]{'&', 'l', 't', ';'};
    private static final char[] GREATER = new char[]{'&', 'g', 't', ';'};
    private static final char[] DOUBLE = new char[]{'&', 'q', 'u', 'o', 't', ';'};
    private static final char[] SINGLE = new char[]{'&', 'a', 'p', 'o', 's', ';'};
    private static final char[] AND = new char[]{'&', 'a', 'm', 'p', ';'};
    private Indenter indenter;
    private Writer result;
    private String encoding;
    private Tag last;

    public Formatter(Writer result, Format format) {
        this.indenter = new Indenter(format);
        this.encoding = format.getEncoding();
        this.result = result;
    }

    public void writeProlog() throws Exception {
        if (this.encoding != null) {
            this.write("<?xml version='1.0' encoding='");
            this.write(this.encoding);
            this.write("'?>\n");
        }
    }

    public void writeStart(String name) throws Exception {
        String text = this.indenter.push();
        if (this.last == Tag.START) {
            this.write('>');
        }
        this.write(text);
        this.write('<');
        this.write(name);
        this.last = Tag.START;
    }

    public void writeAttribute(String name, String value) throws Exception {
        if (this.last != Tag.START) {
            throw new NodeException("Start element required");
        }
        this.write(' ');
        this.write(name);
        this.write('=');
        this.write('\"');
        this.escape(value);
        this.write('\"');
    }

    public void writeText(String text) throws Exception {
        if (this.last == Tag.START) {
            this.write('>');
        }
        this.escape(text);
        this.last = Tag.TEXT;
    }

    public void writeEnd(String name) throws Exception {
        String text = this.indenter.pop();
        if (this.last == Tag.START) {
            this.write('/');
            this.write('>');
        } else {
            if (this.last != Tag.TEXT) {
                this.write(text);
            }
            if (this.last != Tag.START) {
                this.write('<');
                this.write('/');
                this.write(name);
                this.write('>');
            }
        }
        this.last = Tag.END;
    }

    public void flush() throws Exception {
        this.result.flush();
    }

    private void write(char ch) throws Exception {
        this.result.write(ch);
    }

    private void write(char[] plain) throws Exception {
        this.result.write(plain);
    }

    private void write(String plain) throws Exception {
        this.result.write(plain);
    }

    private void escape(String value) throws Exception {
        int size = value.length();
        for (int i = 0; i < size; ++i) {
            this.escape(value.charAt(i));
        }
    }

    private void escape(char ch) throws Exception {
        char[] text = this.symbol(ch);
        if (text != null) {
            this.write(text);
        } else {
            this.write(ch);
        }
    }

    private String unicode(char ch) {
        return Integer.toString(ch);
    }

    private boolean isText(char ch) {
        switch (ch) {
            case '\t': 
            case '\n': 
            case '\r': 
            case ' ': {
                return true;
            }
        }
        if (ch > ' ' && ch <= '~') {
            return ch != '\u00f7';
        }
        return false;
    }

    private char[] symbol(char ch) {
        switch (ch) {
            case '<': {
                return LESS;
            }
            case '>': {
                return GREATER;
            }
            case '\"': {
                return DOUBLE;
            }
            case '\'': {
                return SINGLE;
            }
            case '&': {
                return AND;
            }
        }
        return null;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static enum Tag {
        START,
        TEXT,
        END;

    }
}

