/*
 * Decompiled with CFR 0.152.
 */
package demos.util;

import com.sun.opengl.util.texture.spi.DDSImage;
import demos.util.DxTex;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.image.BufferedImage;
import java.awt.image.WritableRaster;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.IOException;
import java.io.PrintStream;
import java.nio.ByteBuffer;
import javax.swing.ImageIcon;
import javax.swing.JDesktopPane;
import javax.swing.JFileChooser;
import javax.swing.JFrame;
import javax.swing.JInternalFrame;
import javax.swing.JLabel;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.JScrollPane;
import javax.swing.KeyStroke;
import javax.swing.SwingUtilities;
import javax.swing.event.InternalFrameAdapter;
import javax.swing.event.InternalFrameEvent;
import javax.swing.event.InternalFrameListener;
import javax.swing.filechooser.FileFilter;

public class DxTex {
    private InternalFrameListener frameListener;
    private File defaultDirectory;
    private JDesktopPane desktop;
    private static String endl = System.getProperty("line.separator");
    private JMenu mipMapMenu;

    public static void main(String[] stringArray) {
        new DxTex().run(stringArray);
    }

    private void run(String[] stringArray) {
        this.defaultDirectory = new File(System.getProperty("user.dir"));
        JFrame jFrame = new JFrame("DirectX Texture Tool");
        jFrame.setDefaultCloseOperation(3);
        JMenuBar jMenuBar = new JMenuBar();
        JMenu jMenu = DxTex.createMenu("File", 'F', 0);
        JMenuItem jMenuItem = DxTex.createMenuItem("Open...", new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                DxTex.this.openFile();
            }
        }, 79, 2, 'O', 0);
        jMenu.add(jMenuItem);
        jMenuItem = DxTex.createMenuItem("Exit", new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                System.exit(0);
            }
        }, 81, 2, 'x', 1);
        jMenu.add(jMenuItem);
        jMenuBar.add(jMenu);
        jMenu = DxTex.createMenu("MipMap", 'M', 0);
        jMenu.setEnabled(false);
        this.mipMapMenu = jMenu;
        jMenuBar.add(jMenu);
        jFrame.setJMenuBar(jMenuBar);
        this.desktop = new JDesktopPane();
        jFrame.getContentPane().add(this.desktop);
        jFrame.setSize(640, 480);
        jFrame.show();
        this.frameListener = new InternalFrameAdapter(){

            public void internalFrameActivated(InternalFrameEvent internalFrameEvent) {
                JInternalFrame jInternalFrame = internalFrameEvent.getInternalFrame();
                if (jInternalFrame instanceof ImageFrame) {
                    ImageFrame imageFrame = (ImageFrame)jInternalFrame;
                    if (imageFrame.getNumMipMaps() > 0) {
                        DxTex.this.mipMapMenu.removeAll();
                        for (int i = 0; i < imageFrame.getNumMipMaps(); ++i) {
                            JMenuItem jMenuItem;
                            int n = i;
                            String string = "Level " + (i + 1);
                            ActionListener actionListener = new ActionListener(this, imageFrame, n){
                                private final /* synthetic */ ImageFrame val$frame;
                                private final /* synthetic */ int val$map;
                                private final /* synthetic */ 3 this$1;
                                {
                                    this.this$1 = var1_1;
                                    this.val$frame = imageFrame;
                                    this.val$map = n;
                                }

                                public void actionPerformed(ActionEvent actionEvent) {
                                    SwingUtilities.invokeLater(new Runnable(this){
                                        private final /* synthetic */ 4 this$2;
                                        {
                                            this.this$2 = var1_1;
                                        }

                                        public void run() {
                                            4.access$300(this.this$2).setMipMapLevel(4.access$200(this.this$2));
                                        }
                                    });
                                }

                                static /* synthetic */ int access$200(4 var0) {
                                    return var0.val$map;
                                }

                                static /* synthetic */ ImageFrame access$300(4 var0) {
                                    return var0.val$frame;
                                }
                            };
                            if (i < 9) {
                                char c = (char)(48 + i + 1);
                                jMenuItem = DxTex.createMenuItem(string, actionListener, c, 6);
                            } else {
                                jMenuItem = DxTex.createMenuItem(string, actionListener);
                            }
                            DxTex.this.mipMapMenu.add(jMenuItem);
                        }
                        DxTex.this.mipMapMenu.setEnabled(true);
                    } else {
                        DxTex.this.mipMapMenu.setEnabled(false);
                    }
                } else {
                    DxTex.this.mipMapMenu.setEnabled(false);
                }
            }

            public void internalFrameClosing(InternalFrameEvent internalFrameEvent) {
                DxTex.this.desktop.remove(internalFrameEvent.getInternalFrame());
                DxTex.this.desktop.invalidate();
                DxTex.this.desktop.validate();
                DxTex.this.desktop.repaint();
                DxTex.this.desktop.requestFocus();
            }

            public void internalFrameClosed(InternalFrameEvent internalFrameEvent) {
                JInternalFrame jInternalFrame = internalFrameEvent.getInternalFrame();
                if (jInternalFrame instanceof ImageFrame) {
                    ((ImageFrame)jInternalFrame).close();
                }
            }
        };
        for (int i = 0; i < stringArray.length; ++i) {
            final File file = new File(stringArray[i]);
            SwingUtilities.invokeLater(new Runnable(){

                public void run() {
                    DxTex.this.openFile(file);
                }
            });
        }
    }

    private void openFile() {
        JFileChooser jFileChooser = new JFileChooser(this.defaultDirectory);
        jFileChooser.setMultiSelectionEnabled(false);
        jFileChooser.addChoosableFileFilter(new FileFilter(){

            public boolean accept(File file) {
                return file.isDirectory() || file.getName().endsWith(".dds");
            }

            public String getDescription() {
                return "Texture files (*.dds)";
            }
        });
        int n = jFileChooser.showOpenDialog(null);
        if (n == 0) {
            final File file = jFileChooser.getSelectedFile();
            this.defaultDirectory = file.getParentFile();
            SwingUtilities.invokeLater(new Runnable(){

                public void run() {
                    DxTex.this.openFile(file);
                }
            });
        }
    }

    private void openFile(File file) {
        try {
            DDSImage dDSImage = DDSImage.read((File)file);
            this.showImage(file.getName(), dDSImage, 0);
        }
        catch (IOException iOException) {
            this.showMessageDialog("Error while opening file:" + endl + DxTex.exceptionToString(iOException), "Error opening file", 2);
        }
    }

    private void showImage(String string, DDSImage dDSImage, int n) {
        try {
            ImageFrame imageFrame = new ImageFrame(string, dDSImage, n);
            this.desktop.add(imageFrame);
            imageFrame.show();
        }
        catch (Exception exception) {
            this.showMessageDialog("Error while loading file:" + endl + DxTex.exceptionToString(exception), "Error loading file", 2);
        }
    }

    private static JMenu createMenu(String string, char c, int n) {
        JMenu jMenu = new JMenu(string);
        jMenu.setMnemonic(c);
        jMenu.setDisplayedMnemonicIndex(n);
        return jMenu;
    }

    private static JMenuItem createMenuItem(String string, ActionListener actionListener) {
        JMenuItem jMenuItem = new JMenuItem(string);
        jMenuItem.addActionListener(actionListener);
        return jMenuItem;
    }

    private static JMenuItem createMenuItemInternal(String string, ActionListener actionListener, int n, int n2) {
        JMenuItem jMenuItem = DxTex.createMenuItem(string, actionListener);
        jMenuItem.setAccelerator(KeyStroke.getKeyStroke(n, n2));
        return jMenuItem;
    }

    private static JMenuItem createMenuItem(String string, ActionListener actionListener, int n) {
        return DxTex.createMenuItemInternal(string, actionListener, n, 0);
    }

    private static JMenuItem createMenuItem(String string, ActionListener actionListener, char c, int n) {
        JMenuItem jMenuItem = DxTex.createMenuItem(string, actionListener);
        jMenuItem.setMnemonic(c);
        jMenuItem.setDisplayedMnemonicIndex(n);
        return jMenuItem;
    }

    private static JMenuItem createMenuItem(String string, ActionListener actionListener, int n, int n2, char c, int n3) {
        JMenuItem jMenuItem = DxTex.createMenuItemInternal(string, actionListener, n, n2);
        jMenuItem.setMnemonic(c);
        jMenuItem.setDisplayedMnemonicIndex(n3);
        return jMenuItem;
    }

    private void showMessageDialog(final String string, final String string2, final int n) {
        SwingUtilities.invokeLater(new Runnable(){

            public void run() {
                JOptionPane.showInternalMessageDialog(DxTex.this.desktop, string, string2, n);
            }
        });
    }

    private static String exceptionToString(Exception exception) {
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        PrintStream printStream = new PrintStream(byteArrayOutputStream);
        exception.printStackTrace(printStream);
        return byteArrayOutputStream.toString();
    }

    class ImageFrame
    extends JInternalFrame {
        private String filename;
        private DDSImage image;
        private int mipMapLevel;
        private int curWidth;
        private int curHeight;
        private JLabel label;

        ImageFrame(String string, DDSImage dDSImage, int n) {
            this.filename = string;
            this.image = dDSImage;
            this.addInternalFrameListener(DxTex.this.frameListener);
            this.label = new JLabel();
            JScrollPane jScrollPane = new JScrollPane(this.label);
            this.getContentPane().add(jScrollPane);
            this.setSize(400, 400);
            this.setResizable(true);
            this.setIconifiable(true);
            this.setClosable(true);
            this.setMipMapLevel(n);
        }

        int getNumMipMaps() {
            return this.image.getNumMipMaps();
        }

        void setMipMapLevel(int n) {
            this.mipMapLevel = n;
            this.computeImage();
            this.resetTitle();
        }

        void close() {
            System.err.println("Closing files");
            this.image.close();
        }

        private void computeImage() {
            int n;
            this.image.getNumMipMaps();
            DDSImage.ImageInfo imageInfo = this.image.getMipMap(this.mipMapLevel);
            int n2 = imageInfo.getWidth();
            int n3 = imageInfo.getHeight();
            this.curWidth = n2;
            this.curHeight = n3;
            ByteBuffer byteBuffer = imageInfo.getData();
            BufferedImage bufferedImage = new BufferedImage(n2, n3, 5);
            WritableRaster writableRaster = bufferedImage.getRaster();
            if (this.image.getPixelFormat() == 21) {
                n = 4;
            } else if (this.image.getPixelFormat() == 20) {
                n = 3;
            } else {
                this.image.close();
                throw new RuntimeException("Unsupported pixel format " + this.image.getPixelFormat());
            }
            for (int i = 0; i < n3; ++i) {
                for (int j = 0; j < n2; ++j) {
                    writableRaster.setSample(j, i, 0, byteBuffer.get(n * (n2 * i + j) + 2) & 0xFF);
                    writableRaster.setSample(j, i, 1, byteBuffer.get(n * (n2 * i + j) + 1) & 0xFF);
                    writableRaster.setSample(j, i, 2, byteBuffer.get(n * (n2 * i + j) + 0) & 0xFF);
                }
            }
            this.label.setIcon(new ImageIcon(bufferedImage));
        }

        private void resetTitle() {
            this.setTitle(this.filename + " (" + this.curWidth + "x" + this.curHeight + ", mipmap " + (1 + this.mipMapLevel) + " of " + this.image.getNumMipMaps() + ")");
        }
    }
}

