/*
 * Decompiled with CFR 0.152.
 */
package demos.util;

import com.sun.opengl.util.BufferUtil;
import demos.util.FloatList;
import demos.util.IntList;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.nio.FloatBuffer;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.StringTokenizer;

public class ObjReader {
    private int verticesPerFace = -1;
    private FloatBuffer vertices;
    private FloatBuffer normals;
    private float[] aabbMin = new float[3];
    private float[] aabbMax = new float[3];
    private float[] center = new float[3];
    private float radius;
    private FloatList tmpVertices;
    private FloatList tmpVertexNormals;
    private IntList faceIndices;
    private IntList[] tmpFaceIndices;

    public ObjReader(String string) throws IOException {
        this(new File(string));
    }

    public ObjReader(InputStream inputStream) throws IOException {
        this(new InputStreamReader(inputStream));
    }

    public ObjReader(File file) throws IOException {
        this(new FileReader(file));
    }

    public ObjReader(Reader reader) throws IOException {
        BufferedReader bufferedReader = new BufferedReader(reader);
        String string = null;
        int n = 0;
        float[] fArray = new float[3];
        while ((string = bufferedReader.readLine()) != null) {
            ++n;
            if (string.length() <= 0) continue;
            char c = string.charAt(0);
            switch (c) {
                case '#': {
                    break;
                }
                case 'v': {
                    if (Character.isWhitespace(string.charAt(1))) {
                        this.addVertex(this.parseFloats(string, 3, fArray, n));
                        break;
                    }
                    if (string.startsWith("vn")) {
                        this.addVertexNormal(this.parseFloats(string, 3, fArray, n));
                        break;
                    }
                    throw new IOException("Unsupported vertex command on line " + n);
                }
                case 'f': {
                    this.parseIndices(string, n);
                }
            }
        }
        this.condenseIndices();
        this.computeBoundingBox();
    }

    public void rescale(float f) {
        for (int i = 0; i < this.vertices.capacity(); ++i) {
            this.vertices.put(i, this.vertices.get(i) * f);
        }
    }

    public FloatBuffer getVertices() {
        return this.vertices;
    }

    public FloatBuffer getVertexNormals() {
        return this.normals;
    }

    public int[] getFaceIndices() {
        return this.faceIndices.getData();
    }

    public int getVerticesPerFace() {
        return this.verticesPerFace;
    }

    public float[] getAABBMin() {
        return this.aabbMin;
    }

    public float[] getAABBMax() {
        return this.aabbMax;
    }

    public float[] getCenter() {
        return this.center;
    }

    public float getRadius() {
        return this.radius;
    }

    private void addVertex(float[] fArray) {
        if (this.tmpVertices == null) {
            this.tmpVertices = new FloatList();
        }
        for (int i = 0; i < 3; ++i) {
            this.tmpVertices.add(fArray[i]);
        }
    }

    private void addVertexNormal(float[] fArray) {
        if (this.tmpVertexNormals == null) {
            this.tmpVertexNormals = new FloatList();
        }
        for (int i = 0; i < 3; ++i) {
            this.tmpVertexNormals.add(fArray[i]);
        }
    }

    private float[] parseFloats(String string, int n, float[] fArray, int n2) throws IOException {
        StringTokenizer stringTokenizer = new StringTokenizer(string);
        stringTokenizer.nextToken();
        int n3 = 0;
        while (stringTokenizer.hasMoreTokens()) {
            if (n3 >= fArray.length) {
                throw new IOException("Too many floating-point values on line " + n2);
            }
            fArray[n3++] = Float.parseFloat(stringTokenizer.nextToken());
        }
        return fArray;
    }

    private void parseIndices(String string, int n) throws IOException {
        StringTokenizer stringTokenizer = new StringTokenizer(string);
        stringTokenizer.nextToken();
        ArrayList<String> arrayList = new ArrayList<String>();
        while (stringTokenizer.hasMoreTokens()) {
            arrayList.add(stringTokenizer.nextToken());
        }
        if (this.verticesPerFace < 0) {
            this.verticesPerFace = arrayList.size();
        } else if (this.verticesPerFace != arrayList.size()) {
            throw new IOException("Face on line " + n + " had " + arrayList.size() + " vertices, but had already previously set the number of vertices per face to " + this.verticesPerFace);
        }
        Iterator iterator = arrayList.iterator();
        while (iterator.hasNext()) {
            int n2;
            StringTokenizer stringTokenizer2;
            String string2 = (String)iterator.next();
            if (this.tmpFaceIndices == null) {
                stringTokenizer2 = new StringTokenizer(string2, "/");
                n2 = 0;
                while (stringTokenizer2.hasMoreTokens()) {
                    stringTokenizer2.nextToken();
                    ++n2;
                }
                this.tmpFaceIndices = new IntList[n2];
                for (int i = 0; i < n2; ++i) {
                    this.tmpFaceIndices[i] = new IntList();
                }
            }
            stringTokenizer2 = new StringTokenizer(string2, "/");
            n2 = 0;
            while (stringTokenizer2.hasMoreTokens()) {
                if (n2 >= this.tmpFaceIndices.length) {
                    throw new IOException("Expected all vertices to have " + this.tmpFaceIndices.length + " indices based on earlier input, but saw vertex with more on line " + n);
                }
                String string3 = stringTokenizer2.nextToken();
                int n3 = Integer.parseInt(string3);
                this.tmpFaceIndices[n2].add(n3);
                ++n2;
            }
        }
    }

    private void condenseIndices() {
        FloatList floatList = new FloatList();
        FloatList floatList2 = new FloatList();
        IntList intList = new IntList();
        int n = 0;
        HashMap<Indices, Integer> hashMap = new HashMap<Indices, Integer>();
        for (int i = 0; i < this.tmpFaceIndices[0].size(); ++i) {
            Indices indices = this.getIndices(i);
            Integer n2 = (Integer)hashMap.get(indices);
            if (n2 == null) {
                hashMap.put(indices, new Integer(n));
                int n3 = 3 * (indices.data[0] - 1);
                int n4 = 3 * (indices.data[1] - 1);
                floatList.add(this.tmpVertices.get(n3 + 0));
                floatList.add(this.tmpVertices.get(n3 + 1));
                floatList.add(this.tmpVertices.get(n3 + 2));
                floatList2.add(this.tmpVertexNormals.get(n4 + 0));
                floatList2.add(this.tmpVertexNormals.get(n4 + 1));
                floatList2.add(this.tmpVertexNormals.get(n4 + 2));
                intList.add(n);
                ++n;
                continue;
            }
            intList.add(n2);
        }
        floatList.trim();
        floatList2.trim();
        intList.trim();
        this.vertices = BufferUtil.newFloatBuffer((int)floatList.size());
        this.vertices.put(floatList.getData());
        this.vertices.rewind();
        this.normals = BufferUtil.newFloatBuffer((int)floatList2.size());
        this.normals.put(floatList2.getData());
        this.normals.rewind();
        this.faceIndices = intList;
        this.tmpVertices = null;
        this.tmpVertexNormals = null;
    }

    private void computeBoundingBox() {
        for (int i = 0; i < this.vertices.capacity(); i += 3) {
            if (i == 0) {
                this.aabbMin[0] = this.vertices.get(i + 0);
                this.aabbMin[1] = this.vertices.get(i + 1);
                this.aabbMin[2] = this.vertices.get(i + 2);
                this.aabbMax[0] = this.vertices.get(i + 0);
                this.aabbMax[1] = this.vertices.get(i + 1);
                this.aabbMax[2] = this.vertices.get(i + 2);
                continue;
            }
            this.aabbMin[0] = Math.min(this.aabbMin[0], this.vertices.get(i + 0));
            this.aabbMin[1] = Math.min(this.aabbMin[1], this.vertices.get(i + 1));
            this.aabbMin[2] = Math.min(this.aabbMin[2], this.vertices.get(i + 2));
            this.aabbMax[0] = Math.max(this.aabbMax[0], this.vertices.get(i + 0));
            this.aabbMax[1] = Math.max(this.aabbMax[1], this.vertices.get(i + 1));
            this.aabbMax[2] = Math.max(this.aabbMax[2], this.vertices.get(i + 2));
        }
        this.center[0] = 0.5f * (this.aabbMin[0] + this.aabbMax[0]);
        this.center[1] = 0.5f * (this.aabbMin[1] + this.aabbMax[1]);
        this.center[2] = 0.5f * (this.aabbMin[2] + this.aabbMax[2]);
        this.radius = (float)Math.sqrt((this.aabbMax[0] - this.center[0]) * (this.aabbMax[0] - this.center[0]) + (this.aabbMax[1] - this.center[1]) * (this.aabbMax[1] - this.center[1]) + (this.aabbMax[2] - this.center[2]) * (this.aabbMax[2] - this.center[2]));
    }

    private Indices getIndices(int n) {
        int[] nArray = new int[this.tmpFaceIndices.length];
        for (int i = 0; i < this.tmpFaceIndices.length; ++i) {
            nArray[i] = this.tmpFaceIndices[i].get(n);
        }
        return new Indices(nArray);
    }

    static class Indices {
        int[] data;

        Indices(int[] nArray) {
            this.data = nArray;
        }

        public boolean equals(Object object) {
            if (object == null || !(object instanceof Indices)) {
                return false;
            }
            Indices indices = (Indices)object;
            if (this.data.length != indices.data.length) {
                return false;
            }
            for (int i = 0; i < this.data.length; ++i) {
                if (this.data[i] == indices.data[i]) continue;
                return false;
            }
            return true;
        }

        public int hashCode() {
            int n = 0;
            for (int i = 0; i < this.data.length; ++i) {
                n ^= this.data[i];
            }
            return n;
        }
    }
}

