/*
 * Decompiled with CFR 0.152.
 */
package gleem;

import gleem.BSphere;
import gleem.BSphereProvider;
import gleem.CameraParameters;
import gleem.ManipManager;
import gleem.linalg.Mat4f;
import gleem.linalg.Rotf;
import gleem.linalg.Vec3f;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionAdapter;
import java.awt.event.MouseMotionListener;
import javax.media.opengl.GL;
import javax.media.opengl.GLAutoDrawable;
import javax.media.opengl.GLEventListener;

public class ExaminerViewer {
    private GLAutoDrawable window;
    private boolean interactionUnderway;
    private boolean iOwnInteraction;
    private boolean noAltKeyMode;
    private boolean autoRedrawMode = true;
    private boolean button1Down;
    private boolean button2Down;
    private int numMouseButtons;
    private int oldNumMouseButtons;
    private int lastX;
    private int lastY;
    private float minFocalDist = 1.0f;
    private Vec3f dolly = new Vec3f(0.0f, 0.0f, 10.0f);
    private Vec3f center = new Vec3f(0.0f, 0.0f, 0.0f);
    private Rotf orientation = new Rotf();
    private float rotateSpeed = 1.0f;
    private float minRotateSpeed = 1.0E-4f;
    private float dollySpeed = 2.0f;
    private float minDollySpeed = 1.0E-4f;
    private float zNear = 1.0f;
    private float zFar = 100.0f;
    private float vertFOVScale = 1.0f;
    private CameraParameters params = new CameraParameters();
    private BSphereProvider provider;
    private MouseMotionAdapter mouseMotionListener = new MouseMotionAdapter(){

        public void mouseDragged(MouseEvent mouseEvent) {
            ExaminerViewer.this.motionMethod(mouseEvent, mouseEvent.getX(), mouseEvent.getY());
        }

        public void mouseMoved(MouseEvent mouseEvent) {
            ExaminerViewer.this.passiveMotionMethod(mouseEvent);
        }
    };
    private MouseAdapter mouseListener = new MouseAdapter(){

        public void mousePressed(MouseEvent mouseEvent) {
            ExaminerViewer.this.mouseMethod(mouseEvent, mouseEvent.getModifiers(), true, mouseEvent.getX(), mouseEvent.getY());
        }

        public void mouseReleased(MouseEvent mouseEvent) {
            ExaminerViewer.this.mouseMethod(mouseEvent, mouseEvent.getModifiers(), false, mouseEvent.getX(), mouseEvent.getY());
        }
    };
    private GLEventListener glListener = new GLEventListener(){

        public void init(GLAutoDrawable gLAutoDrawable) {
        }

        public void display(GLAutoDrawable gLAutoDrawable) {
        }

        public void reshape(GLAutoDrawable gLAutoDrawable, int n, int n2, int n3, int n4) {
            ExaminerViewer.this.reshapeMethod(n3, n4);
        }

        public void displayChanged(GLAutoDrawable gLAutoDrawable, boolean bl, boolean bl2) {
        }
    };
    private static final float EPSILON = 1.0E-4f;

    public ExaminerViewer(int n) {
        this.numMouseButtons = n;
        this.oldNumMouseButtons = n;
    }

    public void attach(GLAutoDrawable gLAutoDrawable, BSphereProvider bSphereProvider) {
        this.window = gLAutoDrawable;
        this.provider = bSphereProvider;
        this.init();
        this.setupListeners();
    }

    public void detach() {
        this.removeListeners();
        this.window = null;
        this.provider = null;
    }

    public void update(GL gL) {
        this.recalc(gL);
    }

    public void updateInverseRotation(GL gL) {
        this.recalcInverseRotation(gL);
    }

    public void update() {
        this.recalc();
    }

    public void viewAll(GL gL) {
        float f;
        if (this.provider == null) {
            return;
        }
        float f2 = this.params.getVertFOV() * this.vertFOVScale;
        float f3 = 2.0f * f2;
        float f4 = f3 < (f = 2.0f * (float)Math.atan((double)this.params.getImagePlaneAspectRatio() * Math.tan(f2))) ? f3 : f;
        if (f4 == 0.0f) {
            throw new RuntimeException("Minimum field of view was zero");
        }
        BSphere bSphere = this.provider.getBoundingSphere();
        float f5 = bSphere.getRadius() / (float)Math.sin(f4 / 2.0f);
        this.dolly.setZ(f5);
        this.center.set(bSphere.getCenter());
        this.recalc(gL);
    }

    public CameraParameters getCameraParameters() {
        return this.params;
    }

    public void rotateFaster() {
        this.rotateSpeed *= 2.0f;
    }

    public void rotateSlower() {
        if (this.rotateSpeed < this.minRotateSpeed) {
            return;
        }
        this.rotateSpeed /= 2.0f;
    }

    public void dollyFaster() {
        this.dollySpeed *= 2.0f;
    }

    public void dollySlower() {
        if (this.dollySpeed < this.minDollySpeed) {
            return;
        }
        this.dollySpeed /= 2.0f;
    }

    public float getZNear() {
        return this.zNear;
    }

    public void setZNear(float f) {
        this.zNear = f;
    }

    public float getZFar() {
        return this.zFar;
    }

    public void setZFar(float f) {
        this.zFar = f;
    }

    public void setVertFOV(float f) {
        this.vertFOVScale = (float)((double)f / 0.7853981633974483);
    }

    public void setPosition(Vec3f vec3f) {
        Vec3f vec3f2 = this.orientation.rotateVector(Vec3f.NEG_Z_AXIS);
        vec3f2.scale(this.dolly.z());
        this.center.add(vec3f, vec3f2);
    }

    public void setOrientation(Rotf rotf) {
        this.orientation.set(rotf);
    }

    public void setNoAltKeyMode(boolean bl) {
        this.noAltKeyMode = bl;
        if (bl) {
            this.oldNumMouseButtons = this.numMouseButtons;
            this.numMouseButtons = 3;
        } else {
            this.numMouseButtons = this.oldNumMouseButtons;
        }
    }

    public boolean getNoAltKeyMode() {
        return this.noAltKeyMode;
    }

    public void setAutoRedrawMode(boolean bl) {
        this.autoRedrawMode = bl;
    }

    public boolean getAutoRedrawMode() {
        return this.autoRedrawMode;
    }

    public void rotateAboutFocalPoint(Rotf rotf) {
        this.orientation = rotf.times(this.orientation);
        this.orientation.normalize();
    }

    private void setupListeners() {
        ManipManager.getManipManager().removeMouseListeners(this.window);
        this.window.addMouseMotionListener((MouseMotionListener)this.mouseMotionListener);
        this.window.addMouseListener((MouseListener)this.mouseListener);
        this.window.addGLEventListener(this.glListener);
    }

    private void removeListeners() {
        if (this.window != null) {
            this.window.removeMouseMotionListener((MouseMotionListener)this.mouseMotionListener);
            this.window.removeMouseListener((MouseListener)this.mouseListener);
            this.window.removeGLEventListener(this.glListener);
            ManipManager.getManipManager().setupMouseListeners(this.window);
        }
    }

    private void passiveMotionMethod(MouseEvent mouseEvent) {
        ManipManager.getManipManager().mouseMoved(mouseEvent);
    }

    private boolean modifiersMatch(MouseEvent mouseEvent, int n) {
        if (this.noAltKeyMode) {
            if ((n & 0x10) != 0 && (n & 8) == 0 && (n & 4) == 0) {
                return !mouseEvent.isAltDown() && !mouseEvent.isMetaDown() && !mouseEvent.isControlDown() && !mouseEvent.isShiftDown();
            }
            return !mouseEvent.isControlDown() && !mouseEvent.isShiftDown();
        }
        return (mouseEvent.isAltDown() || mouseEvent.isMetaDown()) && !mouseEvent.isControlDown() && !mouseEvent.isShiftDown();
    }

    private void init() {
        this.interactionUnderway = false;
        this.iOwnInteraction = false;
        this.button1Down = false;
        this.button2Down = false;
        int n = this.window.getWidth();
        int n2 = this.window.getHeight();
        this.params.setOrientation(this.orientation);
        this.params.setPosition(this.computePosition(new Vec3f()));
        this.params.setForwardDirection(Vec3f.NEG_Z_AXIS);
        this.params.setUpDirection(Vec3f.Y_AXIS);
        this.params.setVertFOV(0.3926991f);
        this.params.setImagePlaneAspectRatio((float)n / (float)n2);
        this.params.setXSize(n);
        this.params.setYSize(n2);
    }

    private void motionMethod(MouseEvent mouseEvent, int n, int n2) {
        if (this.interactionUnderway && !this.iOwnInteraction) {
            ManipManager.getManipManager().mouseDragged(mouseEvent);
        } else {
            int n3 = n - this.lastX;
            int n4 = n2 - this.lastY;
            this.lastX = n;
            this.lastY = n2;
            if (this.button1Down && !this.button2Down) {
                float f = (float)(-Math.PI) * (float)n4 * this.rotateSpeed / 1000.0f;
                float f2 = (float)(-Math.PI) * (float)n3 * this.rotateSpeed / 1000.0f;
                Rotf rotf = new Rotf(Vec3f.X_AXIS, f);
                Rotf rotf2 = new Rotf(Vec3f.Y_AXIS, f2);
                Rotf rotf3 = rotf2.times(rotf);
                this.orientation = this.orientation.times(rotf3);
            } else if (this.button2Down && !this.button1Down) {
                Vec3f vec3f = new Vec3f(this.dollySpeed * -1.0f * (float)n3 / 100.0f, this.dollySpeed * (float)n4 / 100.0f, 0.0f);
                Vec3f vec3f2 = this.orientation.rotateVector(vec3f);
                this.center.add(vec3f2);
            } else if (this.button1Down && this.button2Down) {
                float f = this.dollySpeed * -1.0f * (float)n4 / 100.0f;
                float f3 = this.dolly.z() + f;
                if (f3 < this.minFocalDist) {
                    f3 = this.minFocalDist;
                }
                this.dolly.setZ(f3);
            }
            if (this.autoRedrawMode) {
                this.window.repaint();
            }
        }
    }

    private void mouseMethod(MouseEvent mouseEvent, int n, boolean bl, int n2, int n3) {
        if (this.interactionUnderway && !this.iOwnInteraction || !this.modifiersMatch(mouseEvent, n)) {
            if (bl) {
                this.interactionUnderway = true;
                this.iOwnInteraction = false;
                ManipManager.getManipManager().mousePressed(mouseEvent);
            } else {
                this.interactionUnderway = false;
                this.iOwnInteraction = false;
                ManipManager.getManipManager().mouseReleased(mouseEvent);
            }
        } else {
            if ((n & 0x10) != 0) {
                this.button1Down = bl;
            } else if (this.numMouseButtons != 3) {
                if ((n & 8) != 0) {
                    this.button2Down = bl;
                }
            } else if ((n & 4) != 0) {
                this.button2Down = bl;
            }
            this.lastX = n2;
            this.lastY = n3;
            if (this.button1Down || this.button2Down) {
                this.interactionUnderway = true;
                this.iOwnInteraction = true;
            } else {
                this.interactionUnderway = false;
                this.iOwnInteraction = false;
            }
            if (this.autoRedrawMode) {
                this.window.repaint();
            }
        }
    }

    private void reshapeMethod(int n, int n2) {
        float f = (float)n / (float)n2;
        float f2 = n >= n2 ? 45.0f : (float)Math.toDegrees(Math.atan(1.0f / f));
        this.params.setVertFOV((float)(Math.toRadians(f2 *= this.vertFOVScale) / 2.0));
        this.params.setImagePlaneAspectRatio(f);
        this.params.setXSize(n);
        this.params.setYSize(n2);
    }

    private void recalc() {
        Vec3f vec3f = new Vec3f();
        this.params.setPosition(this.computePosition(vec3f));
        this.orientation.rotateVector(Vec3f.NEG_Z_AXIS, vec3f);
        this.params.setForwardDirection(vec3f);
        this.orientation.rotateVector(Vec3f.Y_AXIS, vec3f);
        this.params.setUpDirection(vec3f);
        this.params.setOrientation(this.orientation);
        Mat4f mat4f = new Mat4f();
        mat4f.makeIdent();
        mat4f.setRotation(this.orientation);
        mat4f.setTranslation(this.params.getPosition());
        mat4f.invertRigid();
        this.params.setModelviewMatrix(mat4f);
        float f = this.zFar - this.zNear;
        float f2 = this.params.getImagePlaneAspectRatio();
        float f3 = this.params.getVertFOV();
        float f4 = (float)Math.sin(f3);
        if (f == 0.0f || f4 == 0.0f || f2 == 0.0f) {
            mat4f.makeIdent();
            this.params.setProjectionMatrix(mat4f);
            return;
        }
        float f5 = (float)Math.cos(f3) / f4;
        mat4f.makeIdent();
        mat4f.set(0, 0, f5 / f2);
        mat4f.set(1, 1, f5);
        mat4f.set(2, 2, -(this.zFar + this.zNear) / f);
        mat4f.set(3, 2, -1.0f);
        mat4f.set(2, 3, -2.0f * this.zNear * this.zFar / f);
        mat4f.set(3, 3, 0.0f);
        this.params.setProjectionMatrix(mat4f);
    }

    private void recalc(GL gL) {
        this.recalc();
        gL.glMatrixMode(5888);
        float[] fArray = new float[16];
        this.params.getModelviewMatrix().getColumnMajorData(fArray);
        gL.glLoadMatrixf(fArray, 0);
        gL.glMatrixMode(5889);
        this.params.getProjectionMatrix().getColumnMajorData(fArray);
        gL.glLoadMatrixf(fArray, 0);
    }

    private void recalcInverseRotation(GL gL) {
        Rotf rotf = this.orientation.inverse();
        Vec3f vec3f = new Vec3f();
        float f = this.orientation.get(vec3f);
        if (vec3f.lengthSquared() > 1.0E-4f) {
            gL.glRotatef((float)Math.toDegrees(f), vec3f.x(), vec3f.y(), vec3f.z());
        }
    }

    private Vec3f computePosition(Vec3f vec3f) {
        this.orientation.rotateVector(this.dolly, vec3f);
        vec3f.add(this.center);
        return vec3f;
    }
}

