/*
 * Decompiled with CFR 0.152.
 */
package gleem;

import gleem.CameraParameters;
import gleem.HitPoint;
import gleem.Manip;
import gleem.ManipPart;
import gleem.RightTruncPyrMapping;
import gleem.ScreenToRayMapping;
import gleem.WindowUpdateListener;
import gleem.linalg.Vec2f;
import gleem.linalg.Vec3f;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionAdapter;
import java.awt.event.MouseMotionListener;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import javax.media.opengl.GL;
import javax.media.opengl.GLAutoDrawable;

public class ManipManager {
    private ScreenToRayMapping mapping;
    private static ManipManager soleInstance;
    private Map windowToInfoMap = new HashMap();
    private Map manipToWindowMap = new HashMap();
    private MouseAdapter mouseListener = new MouseAdapter(){

        public void mousePressed(MouseEvent mouseEvent) {
            ManipManager.this.mousePressed(mouseEvent);
        }

        public void mouseReleased(MouseEvent mouseEvent) {
            ManipManager.this.mouseReleased(mouseEvent);
        }
    };
    private MouseMotionAdapter mouseMotionListener = new MouseMotionAdapter(){

        public void mouseDragged(MouseEvent mouseEvent) {
            ManipManager.this.mouseDragged(mouseEvent);
        }

        public void mouseMoved(MouseEvent mouseEvent) {
            ManipManager.this.mouseMoved(mouseEvent);
        }
    };
    private WindowUpdateListener defaultWindowListener = new WindowUpdateListener(){

        public void update(GLAutoDrawable gLAutoDrawable) {
            gLAutoDrawable.repaint();
        }
    };
    private WindowUpdateListener windowListener;
    static final /* synthetic */ boolean $assertionsDisabled;

    public static synchronized ManipManager getManipManager() {
        if (soleInstance == null) {
            soleInstance = new ManipManager();
        }
        return soleInstance;
    }

    public synchronized void registerWindow(GLAutoDrawable gLAutoDrawable) {
        this.windowToInfoMap.put(gLAutoDrawable, new WindowInfo());
        this.setupMouseListeners(gLAutoDrawable);
    }

    public synchronized void unregisterWindow(GLAutoDrawable gLAutoDrawable) {
        if (gLAutoDrawable == null) {
            return;
        }
        WindowInfo windowInfo = (WindowInfo)this.windowToInfoMap.get(gLAutoDrawable);
        if (windowInfo != null) {
            Object[] objectArray = windowInfo.manips.toArray();
            for (int i = 0; i < objectArray.length; ++i) {
                this.removeManipFromWindow((Manip)objectArray[i], gLAutoDrawable);
            }
            this.windowToInfoMap.remove(gLAutoDrawable);
            this.removeMouseListeners(gLAutoDrawable);
        }
    }

    public synchronized void showManipInWindow(Manip manip, GLAutoDrawable gLAutoDrawable) {
        WindowInfo windowInfo = (WindowInfo)this.windowToInfoMap.get(gLAutoDrawable);
        if (windowInfo == null) {
            throw new RuntimeException("Window not registered");
        }
        windowInfo.manips.add(manip);
        HashSet<GLAutoDrawable> hashSet = (HashSet<GLAutoDrawable>)this.manipToWindowMap.get(manip);
        if (hashSet == null) {
            hashSet = new HashSet<GLAutoDrawable>();
            this.manipToWindowMap.put(manip, hashSet);
        }
        hashSet.add(gLAutoDrawable);
    }

    public synchronized void removeManipFromWindow(Manip manip, GLAutoDrawable gLAutoDrawable) {
        WindowInfo windowInfo = (WindowInfo)this.windowToInfoMap.get(gLAutoDrawable);
        if (windowInfo == null) {
            throw new RuntimeException("Window not registered");
        }
        if (!windowInfo.manips.remove(manip)) {
            throw new RuntimeException("Manip not registered in window");
        }
        Set set = (Set)this.manipToWindowMap.get(manip);
        if (!$assertionsDisabled && set == null) {
            throw new AssertionError();
        }
        set.remove(gLAutoDrawable);
    }

    public synchronized void updateCameraParameters(GLAutoDrawable gLAutoDrawable, CameraParameters cameraParameters) {
        WindowInfo windowInfo = (WindowInfo)this.windowToInfoMap.get(gLAutoDrawable);
        if (windowInfo == null) {
            throw new RuntimeException("Window not registered");
        }
        windowInfo.params.set(cameraParameters);
    }

    public synchronized void setScreenToRayMapping(ScreenToRayMapping screenToRayMapping) {
        this.mapping = screenToRayMapping;
    }

    public synchronized ScreenToRayMapping getScreenToRayMapping() {
        return this.mapping;
    }

    public synchronized void setWindowUpdateListener(WindowUpdateListener windowUpdateListener) {
        this.windowListener = windowUpdateListener != null ? windowUpdateListener : this.defaultWindowListener;
    }

    public synchronized void render(GLAutoDrawable gLAutoDrawable, GL gL) {
        WindowInfo windowInfo = (WindowInfo)this.windowToInfoMap.get(gLAutoDrawable);
        if (windowInfo == null) {
            throw new RuntimeException("Window not registered");
        }
        Iterator iterator = windowInfo.manips.iterator();
        while (iterator.hasNext()) {
            ((Manip)iterator.next()).render(gL);
        }
    }

    public synchronized void setupMouseListeners(GLAutoDrawable gLAutoDrawable) {
        gLAutoDrawable.addMouseMotionListener((MouseMotionListener)this.mouseMotionListener);
        gLAutoDrawable.addMouseListener((MouseListener)this.mouseListener);
    }

    public synchronized void removeMouseListeners(GLAutoDrawable gLAutoDrawable) {
        gLAutoDrawable.removeMouseMotionListener((MouseMotionListener)this.mouseMotionListener);
        gLAutoDrawable.removeMouseListener((MouseListener)this.mouseListener);
    }

    public synchronized void mouseMoved(MouseEvent mouseEvent) {
        this.passiveMotionMethod((GLAutoDrawable)mouseEvent.getComponent(), mouseEvent.getX(), mouseEvent.getY());
    }

    public synchronized void mouseDragged(MouseEvent mouseEvent) {
        this.motionMethod((GLAutoDrawable)mouseEvent.getComponent(), mouseEvent.getX(), mouseEvent.getY());
    }

    public synchronized void mousePressed(MouseEvent mouseEvent) {
        this.mouseMethod((GLAutoDrawable)mouseEvent.getComponent(), mouseEvent.getModifiers(), true, mouseEvent.getX(), mouseEvent.getY());
    }

    public synchronized void mouseReleased(MouseEvent mouseEvent) {
        this.mouseMethod((GLAutoDrawable)mouseEvent.getComponent(), mouseEvent.getModifiers(), false, mouseEvent.getX(), mouseEvent.getY());
    }

    private ManipManager() {
        this.mapping = new RightTruncPyrMapping();
        this.setWindowUpdateListener(null);
    }

    private void motionMethod(GLAutoDrawable gLAutoDrawable, int n, int n2) {
        WindowInfo windowInfo = (WindowInfo)this.windowToInfoMap.get(gLAutoDrawable);
        if (windowInfo.dragging) {
            Vec3f vec3f = new Vec3f();
            Vec3f vec3f2 = new Vec3f();
            this.computeRay(windowInfo.params, n, n2, vec3f, vec3f2);
            windowInfo.curManip.drag(vec3f, vec3f2);
            this.fireUpdate(windowInfo.curManip);
        }
    }

    private void passiveMotionMethod(GLAutoDrawable gLAutoDrawable, int n, int n2) {
        WindowInfo windowInfo = (WindowInfo)this.windowToInfoMap.get(gLAutoDrawable);
        Vec3f vec3f = new Vec3f();
        Vec3f vec3f2 = new Vec3f();
        this.computeRay(windowInfo.params, n, n2, vec3f, vec3f2);
        ArrayList arrayList = new ArrayList();
        Object object = windowInfo.manips.iterator();
        while (object.hasNext()) {
            ((Manip)object.next()).intersectRay(vec3f, vec3f2, arrayList);
        }
        object = null;
        Iterator iterator = arrayList.iterator();
        while (iterator.hasNext()) {
            HitPoint hitPoint = (HitPoint)iterator.next();
            if (object != null && !(hitPoint.intPt.getT() < ((HitPoint)object).intPt.getT())) continue;
            object = hitPoint;
        }
        if (windowInfo.curHighlightedManip != null && (object == null || ((HitPoint)object).manipulator != windowInfo.curHighlightedManip || ((HitPoint)object).manipPart != windowInfo.curHighlightedManipPart)) {
            windowInfo.curHighlightedManip.clearHighlight();
            this.fireUpdate(windowInfo.curHighlightedManip);
        }
        if (object != null) {
            if (((HitPoint)object).manipulator != windowInfo.curHighlightedManip || ((HitPoint)object).manipPart != windowInfo.curHighlightedManipPart) {
                windowInfo.curHighlightedManip = ((HitPoint)object).manipulator;
                windowInfo.curHighlightedManipPart = ((HitPoint)object).manipPart;
                windowInfo.curHighlightedManip.highlight((HitPoint)object);
                this.fireUpdate(windowInfo.curHighlightedManip);
            }
        } else {
            windowInfo.curHighlightedManip = null;
        }
    }

    private void mouseMethod(GLAutoDrawable gLAutoDrawable, int n, boolean bl, int n2, int n3) {
        if ((n & 0x10) != 0) {
            WindowInfo windowInfo = (WindowInfo)this.windowToInfoMap.get(gLAutoDrawable);
            if (bl) {
                Vec3f vec3f = new Vec3f();
                Vec3f vec3f2 = new Vec3f();
                this.computeRay(windowInfo.params, n2, n3, vec3f, vec3f2);
                ArrayList arrayList = new ArrayList();
                Object object = windowInfo.manips.iterator();
                while (object.hasNext()) {
                    ((Manip)object.next()).intersectRay(vec3f, vec3f2, arrayList);
                }
                object = null;
                Iterator iterator = arrayList.iterator();
                while (iterator.hasNext()) {
                    HitPoint hitPoint = (HitPoint)iterator.next();
                    if (object != null && !(hitPoint.intPt.getT() < ((HitPoint)object).intPt.getT())) continue;
                    object = hitPoint;
                }
                if (object != null) {
                    if (windowInfo.curHighlightedManip != null) {
                        windowInfo.curHighlightedManip.clearHighlight();
                        this.fireUpdate(windowInfo.curHighlightedManip);
                        windowInfo.curHighlightedManip = null;
                    }
                    if ((n & 1) != 0) {
                        ((HitPoint)object).shiftDown = true;
                    }
                    ((HitPoint)object).manipulator.makeActive((HitPoint)object);
                    windowInfo.curManip = ((HitPoint)object).manipulator;
                    windowInfo.dragging = true;
                    this.fireUpdate(windowInfo.curManip);
                }
            } else if (windowInfo.curManip != null) {
                windowInfo.curManip.makeInactive();
                windowInfo.dragging = false;
                this.fireUpdate(windowInfo.curManip);
                windowInfo.curManip = null;
                this.passiveMotionMethod(gLAutoDrawable, n2, n3);
            }
        }
    }

    private Vec2f screenToNormalizedCoordinates(CameraParameters cameraParameters, int n, int n2) {
        return new Vec2f(((float)n / (float)(cameraParameters.xSize - 1) - 0.5f) * 2.0f, (0.5f - (float)n2 / (float)(cameraParameters.ySize - 1)) * 2.0f);
    }

    private void computeRay(CameraParameters cameraParameters, int n, int n2, Vec3f vec3f, Vec3f vec3f2) {
        if (this.mapping == null) {
            throw new RuntimeException("Screen to ray mapping was unspecified");
        }
        this.mapping.mapScreenToRay(this.screenToNormalizedCoordinates(cameraParameters, n, n2), cameraParameters, vec3f, vec3f2);
    }

    private void fireUpdate(Manip manip) {
        Set set = (Set)this.manipToWindowMap.get(manip);
        if (!$assertionsDisabled && set == null) {
            throw new AssertionError();
        }
        Iterator iterator = set.iterator();
        while (iterator.hasNext()) {
            this.windowListener.update((GLAutoDrawable)iterator.next());
        }
    }

    static {
        $assertionsDisabled = !ManipManager.class.desiredAssertionStatus();
    }

    class WindowInfo {
        Set manips = new HashSet();
        CameraParameters params = new CameraParameters();
        Manip curHighlightedManip;
        ManipPart curHighlightedManipPart;
        Manip curManip;
        boolean dragging;

        WindowInfo() {
        }
    }
}

