/*
 * Decompiled with CFR 0.152.
 */
package gleem;

import gleem.HitPoint;
import gleem.Manip;
import gleem.ManipPart;
import gleem.RayTriangleIntersection;
import gleem.linalg.IntersectionPoint;
import gleem.linalg.Mat4f;
import gleem.linalg.Vec3f;
import java.util.List;
import javax.media.opengl.GL;

public class ManipPartTriBased
extends ManipPart {
    private Vec3f color = new Vec3f(0.8f, 0.8f, 0.8f);
    private Vec3f highlightColor = new Vec3f(0.8f, 0.8f, 0.2f);
    private boolean highlighted = false;
    private boolean pickable = true;
    private boolean visible = true;
    private Vec3f[] vertices = null;
    private Vec3f[] normals = null;
    private int[] vertexIndices = null;
    private int[] normalIndices = null;
    private Mat4f xform = new Mat4f();
    private Vec3f[] curVertices;
    private Vec3f[] curNormals;

    public ManipPartTriBased() {
        this.xform.makeIdent();
        this.curVertices = null;
    }

    public void setColor(Vec3f vec3f) {
        this.color.set(vec3f);
    }

    public Vec3f getColor() {
        return new Vec3f(this.color);
    }

    public void setHighlightColor(Vec3f vec3f) {
        this.highlightColor.set(vec3f);
    }

    public Vec3f getHighlightColor() {
        return new Vec3f(this.highlightColor);
    }

    public void intersectRay(Vec3f vec3f, Vec3f vec3f2, List list, Manip manip) {
        this.consistencyCheck();
        if (!this.pickable) {
            return;
        }
        IntersectionPoint intersectionPoint = new IntersectionPoint();
        HitPoint hitPoint = new HitPoint();
        hitPoint.manipulator = manip;
        hitPoint.manipPart = this;
        for (int i = 0; i < this.vertexIndices.length; i += 3) {
            int n = this.vertexIndices[i];
            int n2 = this.vertexIndices[i + 1];
            int n3 = this.vertexIndices[i + 2];
            if (RayTriangleIntersection.intersectRayWithTriangle(vec3f, vec3f2, this.curVertices[n], this.curVertices[n2], this.curVertices[n3], intersectionPoint) != 2 || !(intersectionPoint.getT() >= 0.0f)) continue;
            hitPoint.rayStart = vec3f;
            hitPoint.rayDirection = vec3f2;
            hitPoint.intPt = intersectionPoint;
            list.add(hitPoint);
        }
    }

    public void setTransform(Mat4f mat4f) {
        this.xform.set(mat4f);
        this.recalcVertices();
    }

    public void highlight() {
        this.highlighted = true;
    }

    public void clearHighlight() {
        this.highlighted = false;
    }

    public void setPickable(boolean bl) {
        this.pickable = bl;
    }

    public boolean getPickable() {
        return this.pickable;
    }

    public void setVisible(boolean bl) {
        this.visible = bl;
    }

    public boolean getVisible() {
        return this.visible;
    }

    public void render(GL gL) {
        if (!this.visible) {
            return;
        }
        boolean bl = true;
        if (bl) {
            gL.glEnable(2903);
            gL.glColorMaterial(1032, 5634);
        }
        gL.glBegin(4);
        if (this.highlighted) {
            gL.glColor3f(this.highlightColor.x(), this.highlightColor.y(), this.highlightColor.z());
        } else {
            gL.glColor3f(this.color.x(), this.color.y(), this.color.z());
        }
        for (int i = 0; i < this.vertexIndices.length; ++i) {
            Vec3f vec3f = this.curNormals[this.normalIndices[i]];
            Vec3f vec3f2 = this.curVertices[this.vertexIndices[i]];
            gL.glNormal3f(vec3f.x(), vec3f.y(), vec3f.z());
            gL.glVertex3f(vec3f2.x(), vec3f2.y(), vec3f2.z());
            Vec3f vec3f3 = this.curNormals[this.normalIndices[++i]];
            Vec3f vec3f4 = this.curVertices[this.vertexIndices[i]];
            gL.glNormal3f(vec3f3.x(), vec3f3.y(), vec3f3.z());
            gL.glVertex3f(vec3f4.x(), vec3f4.y(), vec3f4.z());
            Vec3f vec3f5 = this.curNormals[this.normalIndices[++i]];
            Vec3f vec3f6 = this.curVertices[this.vertexIndices[i]];
            gL.glNormal3f(vec3f5.x(), vec3f5.y(), vec3f5.z());
            gL.glVertex3f(vec3f6.x(), vec3f6.y(), vec3f6.z());
        }
        gL.glEnd();
        if (bl) {
            gL.glDisable(2903);
        }
    }

    protected void setVertices(Vec3f[] vec3fArray) {
        this.vertices = vec3fArray;
    }

    protected Vec3f[] getVertices() {
        return this.vertices;
    }

    protected void setNormals(Vec3f[] vec3fArray) {
        this.normals = vec3fArray;
    }

    protected Vec3f[] getNormals() {
        return this.normals;
    }

    protected void setVertexIndices(int[] nArray) {
        this.vertexIndices = nArray;
    }

    protected int[] getVertexIndices() {
        return this.vertexIndices;
    }

    protected void setNormalIndices(int[] nArray) {
        this.normalIndices = nArray;
    }

    protected int[] getNormalIndices() {
        return this.normalIndices;
    }

    private void consistencyCheck() {
        if (this.vertexIndices.length != this.normalIndices.length) {
            throw new RuntimeException("vertexIndices.length != normalIndices.length");
        }
        if (this.vertexIndices.length % 3 != 0) {
            throw new RuntimeException("(vertexIndices % 3) != 0");
        }
        if (this.curVertices != null && this.vertices.length != this.curVertices.length) {
            throw new RuntimeException("vertices.length != curVertices.length");
        }
    }

    private void recalcVertices() {
        int n;
        if (this.curVertices == null || this.curVertices.length != this.vertices.length) {
            this.curVertices = new Vec3f[this.vertices.length];
            for (n = 0; n < this.vertices.length; ++n) {
                this.curVertices[n] = new Vec3f();
            }
        }
        for (n = 0; n < this.vertices.length; ++n) {
            this.xform.xformPt(this.vertices[n], this.curVertices[n]);
        }
        if (this.curNormals == null || this.curNormals.length != this.normals.length) {
            this.curNormals = new Vec3f[this.normals.length];
            for (n = 0; n < this.normals.length; ++n) {
                this.curNormals[n] = new Vec3f();
            }
        }
        for (n = 0; n < this.normals.length; ++n) {
            this.xform.xformDir(this.normals[n], this.curNormals[n]);
            this.curNormals[n].normalize();
        }
    }
}

