/*
 * Decompiled with CFR 0.152.
 */
package gleem;

import gleem.linalg.IntersectionPoint;
import gleem.linalg.Mat3f;
import gleem.linalg.MathUtil;
import gleem.linalg.Vec2f;
import gleem.linalg.Vec3f;

public class RayTriangleIntersection {
    public static final int ERROR = 0;
    public static final int NO_INTERSECTION = 1;
    public static final int INTERSECTION = 2;
    private static final float epsilon = 0.001f;

    public static int intersectRayWithTriangle(Vec3f vec3f, Vec3f vec3f2, Vec3f vec3f3, Vec3f vec3f4, Vec3f vec3f5, IntersectionPoint intersectionPoint) {
        Vec3f vec3f6 = new Vec3f(vec3f3);
        Vec3f vec3f7 = new Vec3f();
        vec3f7.sub(vec3f4, vec3f6);
        Vec3f vec3f8 = new Vec3f();
        vec3f8.sub(vec3f5, vec3f6);
        Vec3f vec3f9 = new Vec3f(vec3f7);
        Vec3f vec3f10 = new Vec3f(vec3f8);
        if (vec3f9.length() < 0.001f) {
            return 0;
        }
        vec3f9.normalize();
        Vec3f vec3f11 = new Vec3f(vec3f9);
        vec3f11.scale(vec3f9.dot(vec3f10));
        vec3f10.sub(vec3f11);
        if (vec3f10.length() < 0.001f) {
            return 0;
        }
        vec3f10.normalize();
        Vec3f vec3f12 = new Vec3f();
        vec3f12.sub(vec3f, vec3f6);
        Mat3f mat3f = new Mat3f();
        mat3f.setCol(0, vec3f9);
        mat3f.setCol(1, vec3f10);
        Vec3f vec3f13 = new Vec3f(vec3f2);
        vec3f13.scale(-1.0f);
        mat3f.setCol(2, vec3f13);
        if (!mat3f.invert()) {
            return 0;
        }
        Vec3f vec3f14 = new Vec3f();
        mat3f.xformVec(vec3f12, vec3f14);
        Vec2f vec2f = new Vec2f(vec3f14.x(), vec3f14.y());
        Vec2f[] vec2fArray = new Vec2f[]{new Vec2f(0.0f, 0.0f), new Vec2f(vec3f7.dot(vec3f9), vec3f7.dot(vec3f10)), new Vec2f(vec3f8.dot(vec3f9), vec3f8.dot(vec3f10))};
        if (!(Math.abs(vec2fArray[1].y()) < 0.001f)) {
            throw new RuntimeException("Math.abs(uv[1].y()) >= epsilon");
        }
        for (int i = 0; i < 3; ++i) {
            if (RayTriangleIntersection.approxOnSameSide(vec2fArray[i], vec2fArray[(i + 1) % 3], vec2fArray[(i + 2) % 3], vec2f)) continue;
            return 1;
        }
        if (!(Math.abs(vec2fArray[2].y()) > 0.001f)) {
            throw new RuntimeException("Math.abs(uv[2].y()) <= epsilon");
        }
        if (!(Math.abs(vec2fArray[1].x()) > 0.001f)) {
            throw new RuntimeException("Math.abs(uv[1].x()) <= epsilon");
        }
        float f = vec2f.y() / vec2fArray[2].y();
        float f2 = (vec2f.x() - f * vec2fArray[2].x()) / vec2fArray[1].x();
        vec3f7.scale(f2);
        vec3f8.scale(f);
        vec3f6.add(vec3f7);
        vec3f6.add(vec3f8);
        intersectionPoint.setIntersectionPoint(vec3f6);
        intersectionPoint.setT(vec3f14.z());
        return 2;
    }

    private static boolean approxOnSameSide(Vec2f vec2f, Vec2f vec2f2, Vec2f vec2f3, Vec2f vec2f4) {
        float f = vec2f2.y() - vec2f.y();
        float f2 = vec2f2.x() - vec2f.x();
        float f3 = vec2f.y() - vec2f3.y();
        float f4 = vec2f.x() - vec2f3.x();
        float f5 = vec2f.y() - vec2f4.y();
        float f6 = vec2f.x() - vec2f4.x();
        if (Math.abs(f2) < 0.001f) {
            if (Math.abs(f4) < 0.001f || Math.abs(f6) < 0.001f) {
                return true;
            }
            return MathUtil.sgn(f4) == MathUtil.sgn(f6);
        }
        float f7 = f / f2;
        float f8 = vec2f3.y() - vec2f.y() - f7 * (vec2f3.x() - vec2f.x());
        float f9 = vec2f4.y() - vec2f.y() - f7 * (vec2f4.x() - vec2f.x());
        if (Math.abs(f8) < 0.001f || Math.abs(f9) < 0.001f) {
            return true;
        }
        return MathUtil.sgn(f8) == MathUtil.sgn(f9);
    }
}

