/*
 * Decompiled with CFR 0.152.
 */
package gleem;

import gleem.CameraParameters;
import gleem.HandleBoxManip;
import gleem.ManipManager;
import gleem.linalg.Vec3f;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Frame;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import javax.media.opengl.GL;
import javax.media.opengl.GLAutoDrawable;
import javax.media.opengl.GLCanvas;
import javax.media.opengl.GLEventListener;
import javax.media.opengl.glu.GLU;

public class TestHandleBox {
    private static final int X_SIZE = 400;
    private static final int Y_SIZE = 400;

    public static void main(String[] stringArray) {
        Frame frame = new Frame("HandleBox Test");
        frame.addWindowListener(new WindowAdapter(){

            public void windowClosing(WindowEvent windowEvent) {
                System.exit(0);
            }
        });
        frame.setLayout(new BorderLayout());
        GLCanvas gLCanvas = new GLCanvas();
        gLCanvas.setSize(400, 400);
        gLCanvas.addGLEventListener((GLEventListener)new Listener());
        frame.add((Component)gLCanvas, "Center");
        frame.pack();
        frame.show();
    }

    static class Listener
    implements GLEventListener {
        private GLU glu = new GLU();
        private CameraParameters params = new CameraParameters();

        Listener() {
        }

        public void init(GLAutoDrawable gLAutoDrawable) {
            GL gL = gLAutoDrawable.getGL();
            gL.glClearColor(0.0f, 0.0f, 0.0f, 0.0f);
            float[] fArray = new float[]{1.0f, 1.0f, 1.0f, 0.0f};
            float[] fArray2 = new float[]{0.0f, 0.0f, 0.0f, 1.0f};
            float[] fArray3 = new float[]{1.0f, 1.0f, 1.0f, 1.0f};
            gL.glLightfv(16384, 4608, fArray2, 0);
            gL.glLightfv(16384, 4609, fArray3, 0);
            gL.glLightfv(16384, 4611, fArray, 0);
            gL.glEnable(2896);
            gL.glEnable(16384);
            gL.glEnable(2929);
            this.params.setPosition(new Vec3f(0.0f, 0.0f, 0.0f));
            this.params.setForwardDirection(Vec3f.NEG_Z_AXIS);
            this.params.setUpDirection(Vec3f.Y_AXIS);
            this.params.setVertFOV(0.3926991f);
            this.params.setImagePlaneAspectRatio(1.0f);
            this.params.xSize = 400;
            this.params.ySize = 400;
            gL.glMatrixMode(5889);
            gL.glLoadIdentity();
            this.glu.gluPerspective(45.0, 1.0, 1.0, 100.0);
            gL.glMatrixMode(5888);
            gL.glLoadIdentity();
            ManipManager manipManager = ManipManager.getManipManager();
            manipManager.registerWindow(gLAutoDrawable);
            HandleBoxManip handleBoxManip = new HandleBoxManip();
            handleBoxManip.setTranslation(new Vec3f(0.0f, 0.0f, -10.0f));
            manipManager.showManipInWindow(handleBoxManip, gLAutoDrawable);
        }

        public void display(GLAutoDrawable gLAutoDrawable) {
            GL gL = gLAutoDrawable.getGL();
            gL.glClear(16640);
            ManipManager.getManipManager().updateCameraParameters(gLAutoDrawable, this.params);
            ManipManager.getManipManager().render(gLAutoDrawable, gL);
        }

        public void reshape(GLAutoDrawable gLAutoDrawable, int n, int n2, int n3, int n4) {
            GL gL = gLAutoDrawable.getGL();
            float f = (float)n3 / (float)n4;
            float f2 = n3 >= n4 ? 45.0f : (float)Math.toDegrees(Math.atan(1.0f / f));
            this.params.setVertFOV((float)Math.toRadians(f2) / 2.0f);
            this.params.setImagePlaneAspectRatio(f);
            this.params.setXSize(n3);
            this.params.setYSize(n4);
            gL.glMatrixMode(5889);
            gL.glLoadIdentity();
            this.glu.gluPerspective((double)f2, (double)f, 1.0, 100.0);
            gL.glMatrixMode(5888);
            gL.glLoadIdentity();
        }

        public void displayChanged(GLAutoDrawable gLAutoDrawable, boolean bl, boolean bl2) {
        }
    }
}

