/*
 * Decompiled with CFR 0.152.
 */
package gleem;

import gleem.BSphere;
import gleem.BSphereProvider;
import gleem.CameraParameters;
import gleem.ExaminerViewer;
import gleem.HandleBoxManip;
import gleem.ManipManager;
import gleem.MouseButtonHelper;
import gleem.linalg.Vec3f;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Frame;
import java.awt.Point;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import javax.media.opengl.GL;
import javax.media.opengl.GLAutoDrawable;
import javax.media.opengl.GLCanvas;
import javax.media.opengl.GLEventListener;
import javax.media.opengl.glu.GLU;

public class TestMultiWin {
    private static final int X_SIZE = 400;
    private static final int Y_SIZE = 400;
    private static HandleBoxManip manip;

    private static void showFrame(String string, Point point) {
        Frame frame = new Frame(string);
        frame.addWindowListener(new WindowAdapter(){

            public void windowClosing(WindowEvent windowEvent) {
                System.exit(0);
            }
        });
        frame.setLayout(new BorderLayout());
        GLCanvas gLCanvas = new GLCanvas();
        gLCanvas.setSize(400, 400);
        gLCanvas.addGLEventListener((GLEventListener)new Listener());
        frame.add((Component)gLCanvas, "Center");
        frame.pack();
        frame.setLocation(point);
        frame.show();
    }

    public static void main(String[] stringArray) {
        manip = new HandleBoxManip();
        manip.setTranslation(new Vec3f(0.0f, 0.0f, -10.0f));
        TestMultiWin.showFrame("MultiWin Test 1/2", new Point(0, 0));
        TestMultiWin.showFrame("MultiWin Test 2/2", new Point(400, 0));
    }

    static class Listener
    implements GLEventListener {
        private GLU glu = new GLU();
        private CameraParameters params = new CameraParameters();
        private ExaminerViewer viewer;

        Listener() {
        }

        public void init(GLAutoDrawable gLAutoDrawable) {
            GL gL = gLAutoDrawable.getGL();
            gL.glClearColor(0.0f, 0.0f, 0.0f, 0.0f);
            float[] fArray = new float[]{1.0f, 1.0f, 1.0f, 0.0f};
            float[] fArray2 = new float[]{0.0f, 0.0f, 0.0f, 1.0f};
            float[] fArray3 = new float[]{1.0f, 1.0f, 1.0f, 1.0f};
            gL.glLightfv(16384, 4608, fArray2, 0);
            gL.glLightfv(16384, 4609, fArray3, 0);
            gL.glLightfv(16384, 4611, fArray, 0);
            gL.glEnable(2896);
            gL.glEnable(16384);
            gL.glEnable(2929);
            this.params.setPosition(new Vec3f(0.0f, 0.0f, 0.0f));
            this.params.setForwardDirection(Vec3f.NEG_Z_AXIS);
            this.params.setUpDirection(Vec3f.Y_AXIS);
            this.params.setVertFOV(0.3926991f);
            this.params.setImagePlaneAspectRatio(1.0f);
            this.params.xSize = 400;
            this.params.ySize = 400;
            gL.glMatrixMode(5889);
            gL.glLoadIdentity();
            this.glu.gluPerspective(45.0, 1.0, 1.0, 100.0);
            gL.glMatrixMode(5888);
            gL.glLoadIdentity();
            ManipManager manipManager = ManipManager.getManipManager();
            manipManager.registerWindow(gLAutoDrawable);
            manipManager.showManipInWindow(manip, gLAutoDrawable);
            this.viewer = new ExaminerViewer(MouseButtonHelper.numMouseButtons());
            this.viewer.attach(gLAutoDrawable, new HandleBoxManipBSphereProvider(manip));
            this.viewer.viewAll(gL);
        }

        public void display(GLAutoDrawable gLAutoDrawable) {
            GL gL = gLAutoDrawable.getGL();
            gL.glClear(16640);
            this.viewer.update(gL);
            ManipManager.getManipManager().updateCameraParameters(gLAutoDrawable, this.viewer.getCameraParameters());
            ManipManager.getManipManager().render(gLAutoDrawable, gL);
        }

        public void reshape(GLAutoDrawable gLAutoDrawable, int n, int n2, int n3, int n4) {
        }

        public void displayChanged(GLAutoDrawable gLAutoDrawable, boolean bl, boolean bl2) {
        }
    }

    static class HandleBoxManipBSphereProvider
    implements BSphereProvider {
        private HandleBoxManip manip;

        private HandleBoxManipBSphereProvider(HandleBoxManip handleBoxManip) {
            this.manip = handleBoxManip;
        }

        public BSphere getBoundingSphere() {
            BSphere bSphere = new BSphere();
            bSphere.setCenter(this.manip.getTranslation());
            Vec3f vec3f = this.manip.getScale();
            Vec3f vec3f2 = this.manip.getGeometryScale();
            Vec3f vec3f3 = new Vec3f();
            vec3f3.setX(2.0f * vec3f.x() * vec3f2.x());
            vec3f3.setY(2.0f * vec3f.y() * vec3f2.y());
            vec3f3.setZ(2.0f * vec3f.z() * vec3f2.z());
            bSphere.setRadius(vec3f3.length());
            return bSphere;
        }
    }
}

