/*
 * Decompiled with CFR 0.152.
 */
package gleem;

import gleem.HitPoint;
import gleem.Manip;
import gleem.ManipPart;
import gleem.ManipPartTwoWayArrow;
import gleem.linalg.Line;
import gleem.linalg.Mat4f;
import gleem.linalg.MathUtil;
import gleem.linalg.Vec3f;
import java.util.List;
import javax.media.opengl.GL;

public class Translate1Manip
extends Manip {
    private ManipPart parts = new ManipPartTwoWayArrow();
    private Vec3f translation = new Vec3f(0.0f, 0.0f, 0.0f);
    private Vec3f axis = new Vec3f(1.0f, 0.0f, 0.0f);
    private Vec3f scale = new Vec3f(1.0f, 1.0f, 1.0f);
    private Mat4f xform = new Mat4f();
    private Line dragLine = new Line();
    private Vec3f dragOffset = new Vec3f();

    public Translate1Manip() {
        this.recalc();
    }

    public void setTranslation(Vec3f vec3f) {
        this.translation.set(vec3f);
        this.recalc();
    }

    public Vec3f getTranslation() {
        return new Vec3f(this.translation);
    }

    public void setAxis(Vec3f vec3f) {
        this.axis.set(vec3f);
        this.recalc();
    }

    public Vec3f getAxis() {
        return new Vec3f(this.axis);
    }

    public void setScale(Vec3f vec3f) {
        this.scale.set(vec3f);
        this.recalc();
    }

    public Vec3f getScale() {
        return new Vec3f(this.scale);
    }

    public void replaceGeometry(ManipPart manipPart) {
        this.parts = manipPart;
    }

    public void intersectRay(Vec3f vec3f, Vec3f vec3f2, List list) {
        this.parts.intersectRay(vec3f, vec3f2, list, this);
    }

    public void highlight(HitPoint hitPoint) {
        if (hitPoint.manipPart != this.parts) {
            throw new RuntimeException("My old geometry disappeared; how did this happen?");
        }
        this.parts.highlight();
    }

    public void clearHighlight() {
        this.parts.clearHighlight();
    }

    public void makeActive(HitPoint hitPoint) {
        this.parts.highlight();
        this.dragLine.setDirection(this.axis);
        this.dragLine.setPoint(hitPoint.intPt.getIntersectionPoint());
        this.dragOffset.sub(this.translation, hitPoint.intPt.getIntersectionPoint());
    }

    public void drag(Vec3f vec3f, Vec3f vec3f2) {
        Vec3f vec3f3 = new Vec3f();
        if (!this.dragLine.closestPointToRay(vec3f, vec3f2, vec3f3)) {
            return;
        }
        this.translation.set(vec3f3);
        this.translation.add(this.dragOffset);
        this.recalc();
        super.drag(vec3f, vec3f2);
    }

    public void makeInactive() {
        this.parts.clearHighlight();
    }

    public void render(GL gL) {
        this.parts.render(gL);
    }

    private void recalc() {
        Mat4f mat4f = new Mat4f();
        Mat4f mat4f2 = new Mat4f();
        Mat4f mat4f3 = new Mat4f();
        Mat4f mat4f4 = new Mat4f();
        mat4f.makeIdent();
        mat4f.set(0, 0, this.scale.x());
        mat4f.set(1, 1, this.scale.y());
        mat4f.set(2, 2, this.scale.z());
        Vec3f vec3f = new Vec3f();
        Vec3f vec3f2 = new Vec3f();
        MathUtil.makePerpendicular(this.axis, vec3f);
        vec3f2.cross(this.axis, vec3f);
        vec3f.normalize();
        vec3f2.normalize();
        mat4f2.makeIdent();
        mat4f2.set(0, 0, this.axis.x());
        mat4f2.set(1, 0, this.axis.y());
        mat4f2.set(2, 0, this.axis.z());
        mat4f2.set(0, 1, vec3f.x());
        mat4f2.set(1, 1, vec3f.y());
        mat4f2.set(2, 1, vec3f.z());
        mat4f2.set(0, 2, vec3f2.x());
        mat4f2.set(1, 2, vec3f2.y());
        mat4f2.set(2, 2, vec3f2.z());
        mat4f3.makeIdent();
        mat4f3.set(0, 3, this.translation.x());
        mat4f3.set(1, 3, this.translation.y());
        mat4f3.set(2, 3, this.translation.z());
        mat4f4.mul(mat4f3, mat4f2);
        this.xform.mul(mat4f4, mat4f);
        this.parts.setTransform(this.xform);
    }
}

