/*
 * Decompiled with CFR 0.152.
 */
package gleem.linalg;

import gleem.linalg.Mat2f;
import gleem.linalg.Vec2f;
import gleem.linalg.Vec3f;

public class Line {
    private Vec3f point;
    private Vec3f direction;
    private Vec3f alongVec;

    public Line() {
        this.point = new Vec3f(0.0f, 0.0f, 0.0f);
        this.direction = new Vec3f(1.0f, 0.0f, 0.0f);
        this.alongVec = new Vec3f();
        this.recalc();
    }

    public Line(Vec3f vec3f, Vec3f vec3f2) {
        vec3f = new Vec3f(vec3f);
        vec3f.normalize();
        vec3f2 = new Vec3f(vec3f2);
        this.alongVec = new Vec3f();
        this.recalc();
    }

    public void setDirection(Vec3f vec3f) {
        this.direction.set(vec3f);
        this.direction.normalize();
        this.recalc();
    }

    public Vec3f getDirection() {
        return this.direction;
    }

    public void setPoint(Vec3f vec3f) {
        this.point.set(vec3f);
        this.recalc();
    }

    public Vec3f getPoint() {
        return this.point;
    }

    public void projectPoint(Vec3f vec3f, Vec3f vec3f2) {
        float f = this.direction.dot(vec3f);
        vec3f2.set(this.direction);
        vec3f2.scale(f);
        vec3f2.add(this.alongVec);
    }

    public boolean closestPointToRay(Vec3f vec3f, Vec3f vec3f2, Vec3f vec3f3) {
        Mat2f mat2f = new Mat2f();
        mat2f.set(0, 0, -this.direction.lengthSquared());
        mat2f.set(1, 1, -vec3f2.lengthSquared());
        mat2f.set(0, 1, this.direction.dot(vec3f2));
        mat2f.set(1, 0, mat2f.get(0, 1));
        if (Math.abs(mat2f.determinant()) == 0.0f) {
            return false;
        }
        if (!mat2f.invert()) {
            return false;
        }
        Vec2f vec2f = new Vec2f();
        vec2f.setX(this.point.dot(this.direction) - vec3f.dot(this.direction));
        vec2f.setY(vec3f.dot(vec3f2) - this.point.dot(vec3f2));
        Vec2f vec2f2 = new Vec2f();
        mat2f.xformVec(vec2f, vec2f2);
        if (vec2f2.y() < 0.0f) {
            vec3f3.set(vec3f);
        } else {
            vec3f3.set(this.direction);
            vec3f3.scale(vec2f2.x());
            vec3f3.add(this.point);
        }
        return true;
    }

    private void recalc() {
        float f = this.direction.lengthSquared();
        if (f == 0.0f) {
            throw new RuntimeException("Line.recalc: ERROR: direction was the zero vector (not allowed)");
        }
        this.alongVec.set(this.point.minus(this.direction.times(this.point.dot(this.direction))));
    }
}

