/*
 * Decompiled with CFR 0.152.
 */
package gleem.linalg;

import gleem.linalg.DimensionMismatchException;
import gleem.linalg.Mat2f;
import gleem.linalg.Mat3f;
import gleem.linalg.Mat4f;
import gleem.linalg.Vecf;

public class Matf {
    private float[] data;
    private int nCol;
    private int nRow;

    public Matf(int n, int n2) {
        this.data = new float[n * n2];
        this.nCol = n2;
        this.nRow = n;
    }

    public Matf(Matf matf) {
        this.nRow = matf.nRow;
        this.nCol = matf.nCol;
        this.data = new float[this.nRow * this.nCol];
        System.arraycopy(matf.data, 0, this.data, 0, this.data.length);
    }

    public int nRow() {
        return this.nRow;
    }

    public int nCol() {
        return this.nCol;
    }

    public float get(int n, int n2) {
        return this.data[this.nCol * n + n2];
    }

    public void set(int n, int n2, float f) {
        this.data[this.nCol * n + n2] = f;
    }

    public Matf transpose() {
        Matf matf = new Matf(this.nCol, this.nRow);
        for (int i = 0; i < this.nRow; ++i) {
            for (int j = 0; j < this.nCol; ++j) {
                matf.set(j, i, this.get(i, j));
            }
        }
        return matf;
    }

    public Matf mul(Matf matf) throws DimensionMismatchException {
        if (this.nCol() != matf.nRow()) {
            throw new DimensionMismatchException();
        }
        Matf matf2 = new Matf(this.nRow(), matf.nCol());
        for (int i = 0; i < this.nRow(); ++i) {
            for (int j = 0; j < matf.nCol(); ++j) {
                float f = 0.0f;
                for (int k = 0; k < this.nCol(); ++k) {
                    f += this.get(i, k) * matf.get(k, j);
                }
                matf2.set(i, j, f);
            }
        }
        return matf2;
    }

    public Vecf mul(Vecf vecf) throws DimensionMismatchException {
        if (this.nCol() != vecf.length()) {
            throw new DimensionMismatchException();
        }
        Vecf vecf2 = new Vecf(this.nRow());
        for (int i = 0; i < this.nRow(); ++i) {
            float f = 0.0f;
            for (int j = 0; j < this.nCol(); ++j) {
                f += this.get(i, j) * vecf.get(j);
            }
            vecf2.set(i, f);
        }
        return vecf2;
    }

    public Mat2f toMat2f() throws DimensionMismatchException {
        if (this.nRow() != 2 || this.nCol() != 2) {
            throw new DimensionMismatchException();
        }
        Mat2f mat2f = new Mat2f();
        for (int i = 0; i < 2; ++i) {
            for (int j = 0; j < 2; ++j) {
                mat2f.set(i, j, this.get(i, j));
            }
        }
        return mat2f;
    }

    public Mat3f toMat3f() throws DimensionMismatchException {
        if (this.nRow() != 3 || this.nCol() != 3) {
            throw new DimensionMismatchException();
        }
        Mat3f mat3f = new Mat3f();
        for (int i = 0; i < 3; ++i) {
            for (int j = 0; j < 3; ++j) {
                mat3f.set(i, j, this.get(i, j));
            }
        }
        return mat3f;
    }

    public Mat4f toMat4f() throws DimensionMismatchException {
        if (this.nRow() != 4 || this.nCol() != 4) {
            throw new DimensionMismatchException();
        }
        Mat4f mat4f = new Mat4f();
        for (int i = 0; i < 4; ++i) {
            for (int j = 0; j < 4; ++j) {
                mat4f.set(i, j, this.get(i, j));
            }
        }
        return mat4f;
    }
}

