/*
 * Decompiled with CFR 0.152.
 */
package gleem.linalg;

import gleem.linalg.IntersectionPoint;
import gleem.linalg.MathUtil;
import gleem.linalg.Vec2f;
import gleem.linalg.Vec3f;

public class PlaneUV {
    private Vec3f origin = new Vec3f();
    private Vec3f normal = new Vec3f();
    private Vec3f uAxis = new Vec3f();
    private Vec3f vAxis = new Vec3f();

    public PlaneUV() {
        this.setEverything(new Vec3f(0.0f, 1.0f, 0.0f), new Vec3f(0.0f, 0.0f, 0.0f), new Vec3f(1.0f, 0.0f, 0.0f), new Vec3f(0.0f, 0.0f, -1.0f));
    }

    public PlaneUV(Vec3f vec3f, Vec3f vec3f2) {
        this.setOrigin(vec3f2);
        this.setNormal(vec3f);
    }

    public PlaneUV(Vec3f vec3f, Vec3f vec3f2, Vec3f vec3f3) {
        this.setOrigin(vec3f2);
        this.setNormalAndU(vec3f, vec3f3);
    }

    public PlaneUV(Vec3f vec3f, Vec3f vec3f2, Vec3f vec3f3, Vec3f vec3f4) {
        this.setEverything(vec3f, vec3f2, vec3f3, vec3f4);
    }

    public void setOrigin(Vec3f vec3f) {
        this.origin.set(vec3f);
    }

    public Vec3f getOrigin() {
        return new Vec3f(this.origin);
    }

    public void setNormalAndUV(Vec3f vec3f, Vec3f vec3f2, Vec3f vec3f3) {
        this.setEverything(vec3f, this.origin, vec3f2, vec3f3);
    }

    public void setNormal(Vec3f vec3f) {
        Vec3f vec3f2 = new Vec3f();
        MathUtil.makePerpendicular(vec3f, vec3f2);
        Vec3f vec3f3 = vec3f.cross(vec3f2);
        this.setEverything(vec3f, this.origin, vec3f2, vec3f3);
    }

    public void setNormalAndU(Vec3f vec3f, Vec3f vec3f2) {
        Vec3f vec3f3 = vec3f.cross(vec3f2);
        this.setEverything(vec3f, this.origin, vec3f2, vec3f3);
    }

    public Vec3f getNormal() {
        return this.normal;
    }

    public Vec3f getUAxis() {
        return this.uAxis;
    }

    public Vec3f getVAxis() {
        return this.vAxis;
    }

    public void projectPoint(Vec3f vec3f, Vec3f vec3f2, Vec2f vec2f) {
        vec3f2.sub(vec3f, this.origin);
        float f = this.normal.dot(vec3f2);
        Vec3f vec3f3 = new Vec3f();
        vec3f3.set(this.normal);
        vec3f3.scale(f);
        vec3f2.sub(vec3f2, vec3f3);
        vec2f.set(vec3f2.dot(this.uAxis), vec3f2.dot(this.vAxis));
        vec3f2.add(this.origin);
    }

    public boolean intersectRay(Vec3f vec3f, Vec3f vec3f2, IntersectionPoint intersectionPoint, Vec2f vec2f) {
        float f = vec3f2.dot(this.normal);
        if (f == 0.0f) {
            return false;
        }
        Vec3f vec3f3 = new Vec3f();
        vec3f3.sub(this.origin, vec3f);
        float f2 = vec3f3.dot(this.normal) / f;
        Vec3f vec3f4 = new Vec3f();
        vec3f4.set(vec3f2);
        vec3f4.scale(f2);
        vec3f4.add(vec3f);
        intersectionPoint.setIntersectionPoint(vec3f4);
        intersectionPoint.setT(f2);
        vec3f3.sub(intersectionPoint.getIntersectionPoint(), this.origin);
        vec2f.set(vec3f3.dot(this.uAxis), vec3f3.dot(this.vAxis));
        return true;
    }

    private void setEverything(Vec3f vec3f, Vec3f vec3f2, Vec3f vec3f3, Vec3f vec3f4) {
        this.normal.set(vec3f);
        this.origin.set(vec3f2);
        this.uAxis.set(vec3f3);
        this.vAxis.set(vec3f4);
        this.normal.normalize();
        this.uAxis.normalize();
        this.vAxis.normalize();
    }
}

