/*
 * Decompiled with CFR 0.152.
 */
package gleem.linalg;

import gleem.linalg.Mat4f;
import gleem.linalg.Vec3f;

public class Rotf {
    private static float EPSILON = 1.0E-7f;
    private float q0;
    private float q1;
    private float q2;
    private float q3;

    public Rotf() {
        this.init();
    }

    public Rotf(Rotf rotf) {
        this.set(rotf);
    }

    public Rotf(Vec3f vec3f, float f) {
        this.set(vec3f, f);
    }

    public Rotf(Vec3f vec3f, Vec3f vec3f2) {
        this.set(vec3f, vec3f2);
    }

    public void init() {
        this.q0 = 1.0f;
        this.q3 = 0.0f;
        this.q2 = 0.0f;
        this.q1 = 0.0f;
    }

    public boolean withinEpsilon(Rotf rotf, float f) {
        return Math.abs(this.q0 - rotf.q0) < f && Math.abs(this.q1 - rotf.q1) < f && Math.abs(this.q2 - rotf.q2) < f && Math.abs(this.q3 - rotf.q3) < f;
    }

    public void set(Vec3f vec3f, float f) {
        float f2 = f / 2.0f;
        this.q0 = (float)Math.cos(f2);
        float f3 = (float)Math.sin(f2);
        Vec3f vec3f2 = new Vec3f(vec3f);
        vec3f2.normalize();
        this.q1 = vec3f2.x() * f3;
        this.q2 = vec3f2.y() * f3;
        this.q3 = vec3f2.z() * f3;
    }

    public void set(Rotf rotf) {
        this.q0 = rotf.q0;
        this.q1 = rotf.q1;
        this.q2 = rotf.q2;
        this.q3 = rotf.q3;
    }

    public void set(Vec3f vec3f, Vec3f vec3f2) {
        Vec3f vec3f3 = vec3f.cross(vec3f2);
        if (vec3f3.lengthSquared() < EPSILON) {
            this.init();
            return;
        }
        float f = vec3f.dot(vec3f2);
        float f2 = vec3f.length() * vec3f2.length();
        if (f2 < EPSILON) {
            this.init();
            return;
        }
        this.set(vec3f3, (float)Math.acos(f /= f2));
    }

    public float get(Vec3f vec3f) {
        float f = (float)(2.0 * Math.acos(this.q0));
        vec3f.set(this.q1, this.q2, this.q3);
        float f2 = vec3f.length();
        if (f2 == 0.0f) {
            vec3f.set(0.0f, 0.0f, 1.0f);
        } else {
            vec3f.scale(1.0f / f2);
        }
        return f;
    }

    public Rotf inverse() {
        Rotf rotf = new Rotf(this);
        rotf.invert();
        return rotf;
    }

    public void invert() {
        this.q1 = -this.q1;
        this.q2 = -this.q2;
        this.q3 = -this.q3;
    }

    public float length() {
        return (float)Math.sqrt(this.lengthSquared());
    }

    public float lengthSquared() {
        return this.q0 * this.q0 + this.q1 * this.q1 + this.q2 * this.q2 + this.q3 * this.q3;
    }

    public void normalize() {
        float f = this.length();
        this.q0 /= f;
        this.q1 /= f;
        this.q2 /= f;
        this.q3 /= f;
    }

    public Rotf times(Rotf rotf) {
        Rotf rotf2 = new Rotf();
        rotf2.mul(this, rotf);
        return rotf2;
    }

    public void mul(Rotf rotf, Rotf rotf2) {
        this.q0 = rotf.q0 * rotf2.q0 - rotf.q1 * rotf2.q1 - rotf.q2 * rotf2.q2 - rotf.q3 * rotf2.q3;
        this.q1 = rotf.q0 * rotf2.q1 + rotf.q1 * rotf2.q0 + rotf.q2 * rotf2.q3 - rotf.q3 * rotf2.q2;
        this.q2 = rotf.q0 * rotf2.q2 + rotf.q2 * rotf2.q0 - rotf.q1 * rotf2.q3 + rotf.q3 * rotf2.q1;
        this.q3 = rotf.q0 * rotf2.q3 + rotf.q3 * rotf2.q0 + rotf.q1 * rotf2.q2 - rotf.q2 * rotf2.q1;
    }

    public void toMatrix(Mat4f mat4f) {
        float f = this.q0 * this.q0;
        float f2 = this.q1 * this.q1;
        float f3 = this.q2 * this.q2;
        float f4 = this.q3 * this.q3;
        mat4f.set(0, 0, f + f2 - f3 - f4);
        mat4f.set(1, 1, f - f2 + f3 - f4);
        mat4f.set(2, 2, f - f2 - f3 + f4);
        float f5 = this.q0 * this.q3;
        float f6 = this.q1 * this.q2;
        mat4f.set(0, 1, 2.0f * (f6 - f5));
        mat4f.set(1, 0, 2.0f * (f5 + f6));
        float f7 = this.q0 * this.q2;
        float f8 = this.q1 * this.q3;
        mat4f.set(0, 2, 2.0f * (f7 + f8));
        mat4f.set(2, 0, 2.0f * (f8 - f7));
        float f9 = this.q0 * this.q1;
        float f10 = this.q2 * this.q3;
        mat4f.set(1, 2, 2.0f * (f10 - f9));
        mat4f.set(2, 1, 2.0f * (f9 + f10));
    }

    public void fromMatrix(Mat4f mat4f) {
        float f = mat4f.get(0, 0) + mat4f.get(1, 1) + mat4f.get(2, 2);
        if ((double)f > 0.0) {
            float f2 = (float)Math.sqrt(f + 1.0f);
            this.q0 = f2 * 0.5f;
            f2 = 0.5f / f2;
            this.q1 = (mat4f.get(2, 1) - mat4f.get(1, 2)) * f2;
            this.q2 = (mat4f.get(0, 2) - mat4f.get(2, 0)) * f2;
            this.q3 = (mat4f.get(1, 0) - mat4f.get(0, 1)) * f2;
        } else {
            int n = 0;
            if (mat4f.get(1, 1) > mat4f.get(0, 0)) {
                n = 1;
            }
            if (mat4f.get(2, 2) > mat4f.get(n, n)) {
                n = 2;
            }
            int n2 = (n + 1) % 3;
            int n3 = (n2 + 1) % 3;
            float f3 = (float)Math.sqrt(mat4f.get(n, n) - (mat4f.get(n2, n2) + mat4f.get(n3, n3)) + 1.0f);
            this.setQ(n + 1, f3 * 0.5f);
            f3 = 0.5f / f3;
            this.q0 = (mat4f.get(n3, n2) - mat4f.get(n2, n3)) * f3;
            this.setQ(n2 + 1, (mat4f.get(n2, n) + mat4f.get(n, n2)) * f3);
            this.setQ(n3 + 1, (mat4f.get(n3, n) + mat4f.get(n, n3)) * f3);
        }
    }

    public void rotateVector(Vec3f vec3f, Vec3f vec3f2) {
        Vec3f vec3f3 = new Vec3f(this.q1, this.q2, this.q3);
        Vec3f vec3f4 = vec3f3.cross(vec3f);
        Vec3f vec3f5 = vec3f4.cross(vec3f3);
        vec3f4.scale(2.0f * this.q0);
        vec3f5.scale(-2.0f);
        vec3f2.add(vec3f, vec3f4);
        vec3f2.add(vec3f2, vec3f5);
    }

    public Vec3f rotateVector(Vec3f vec3f) {
        Vec3f vec3f2 = new Vec3f();
        this.rotateVector(vec3f, vec3f2);
        return vec3f2;
    }

    public String toString() {
        return "(" + this.q0 + ", " + this.q1 + ", " + this.q2 + ", " + this.q3 + ")";
    }

    private void setQ(int n, float f) {
        switch (n) {
            case 0: {
                this.q0 = f;
                break;
            }
            case 1: {
                this.q1 = f;
                break;
            }
            case 2: {
                this.q2 = f;
                break;
            }
            case 3: {
                this.q3 = f;
                break;
            }
            default: {
                throw new IndexOutOfBoundsException();
            }
        }
    }
}

