/*
 * Decompiled with CFR 0.152.
 */
package gleem.linalg;

import gleem.linalg.Vec3f;

public class Vec3d {
    private double x;
    private double y;
    private double z;

    public Vec3d() {
    }

    public Vec3d(Vec3d vec3d) {
        this.set(vec3d);
    }

    public Vec3d(double d, double d2, double d3) {
        this.set(d, d2, d3);
    }

    public Vec3d copy() {
        return new Vec3d(this);
    }

    public Vec3f toFloat() {
        return new Vec3f((float)this.x, (float)this.y, (float)this.z);
    }

    public void set(Vec3d vec3d) {
        this.set(vec3d.x, vec3d.y, vec3d.z);
    }

    public void set(double d, double d2, double d3) {
        this.x = d;
        this.y = d2;
        this.z = d3;
    }

    public void set(int n, double d) {
        switch (n) {
            case 0: {
                this.x = d;
                break;
            }
            case 1: {
                this.y = d;
                break;
            }
            case 2: {
                this.z = d;
                break;
            }
            default: {
                throw new IndexOutOfBoundsException();
            }
        }
    }

    public double get(int n) {
        switch (n) {
            case 0: {
                return this.x;
            }
            case 1: {
                return this.y;
            }
            case 2: {
                return this.z;
            }
        }
        throw new IndexOutOfBoundsException();
    }

    public double x() {
        return this.x;
    }

    public double y() {
        return this.y;
    }

    public double z() {
        return this.z;
    }

    public void setX(double d) {
        this.x = d;
    }

    public void setY(double d) {
        this.y = d;
    }

    public void setZ(double d) {
        this.z = d;
    }

    public double dot(Vec3d vec3d) {
        return this.x * vec3d.x + this.y * vec3d.y + this.z * vec3d.z;
    }

    public double length() {
        return Math.sqrt(this.lengthSquared());
    }

    public double lengthSquared() {
        return this.dot(this);
    }

    public void normalize() {
        double d = this.length();
        if (d == 0.0) {
            return;
        }
        this.scale(1.0 / d);
    }

    public Vec3d times(double d) {
        Vec3d vec3d = new Vec3d(this);
        vec3d.scale(d);
        return vec3d;
    }

    public void scale(double d) {
        this.x *= d;
        this.y *= d;
        this.z *= d;
    }

    public Vec3d plus(Vec3d vec3d) {
        Vec3d vec3d2 = new Vec3d();
        vec3d2.add(this, vec3d);
        return vec3d2;
    }

    public void add(Vec3d vec3d) {
        this.add(this, vec3d);
    }

    public void add(Vec3d vec3d, Vec3d vec3d2) {
        this.x = vec3d.x + vec3d2.x;
        this.y = vec3d.y + vec3d2.y;
        this.z = vec3d.z + vec3d2.z;
    }

    public Vec3d addScaled(double d, Vec3d vec3d) {
        Vec3d vec3d2 = new Vec3d();
        vec3d2.addScaled(this, d, vec3d);
        return vec3d2;
    }

    public void addScaled(Vec3d vec3d, double d, Vec3d vec3d2) {
        this.x = vec3d.x + d * vec3d2.x;
        this.y = vec3d.y + d * vec3d2.y;
        this.z = vec3d.z + d * vec3d2.z;
    }

    public Vec3d minus(Vec3d vec3d) {
        Vec3d vec3d2 = new Vec3d();
        vec3d2.sub(this, vec3d);
        return vec3d2;
    }

    public void sub(Vec3d vec3d) {
        this.sub(this, vec3d);
    }

    public void sub(Vec3d vec3d, Vec3d vec3d2) {
        this.x = vec3d.x - vec3d2.x;
        this.y = vec3d.y - vec3d2.y;
        this.z = vec3d.z - vec3d2.z;
    }

    public Vec3d cross(Vec3d vec3d) {
        Vec3d vec3d2 = new Vec3d();
        vec3d2.cross(this, vec3d);
        return vec3d2;
    }

    public void cross(Vec3d vec3d, Vec3d vec3d2) {
        this.x = vec3d.y * vec3d2.z - vec3d.z * vec3d2.y;
        this.y = vec3d.z * vec3d2.x - vec3d.x * vec3d2.z;
        this.z = vec3d.x * vec3d2.y - vec3d.y * vec3d2.x;
    }

    public String toString() {
        return "(" + this.x + ", " + this.y + ", " + this.z + ")";
    }
}

