/*
 * Decompiled with CFR 0.152.
 */
package gleem.linalg;

import gleem.linalg.Vec3d;
import gleem.linalg.Vecf;

public class Vec3f {
    public static final Vec3f X_AXIS = new Vec3f(1.0f, 0.0f, 0.0f);
    public static final Vec3f Y_AXIS = new Vec3f(0.0f, 1.0f, 0.0f);
    public static final Vec3f Z_AXIS = new Vec3f(0.0f, 0.0f, 1.0f);
    public static final Vec3f NEG_X_AXIS = new Vec3f(-1.0f, 0.0f, 0.0f);
    public static final Vec3f NEG_Y_AXIS = new Vec3f(0.0f, -1.0f, 0.0f);
    public static final Vec3f NEG_Z_AXIS = new Vec3f(0.0f, 0.0f, -1.0f);
    private float x;
    private float y;
    private float z;

    public Vec3f() {
    }

    public Vec3f(Vec3f vec3f) {
        this.set(vec3f);
    }

    public Vec3f(float f, float f2, float f3) {
        this.set(f, f2, f3);
    }

    public Vec3f copy() {
        return new Vec3f(this);
    }

    public Vec3d toDouble() {
        return new Vec3d(this.x, this.y, this.z);
    }

    public void set(Vec3f vec3f) {
        this.set(vec3f.x, vec3f.y, vec3f.z);
    }

    public void set(float f, float f2, float f3) {
        this.x = f;
        this.y = f2;
        this.z = f3;
    }

    public void set(int n, float f) {
        switch (n) {
            case 0: {
                this.x = f;
                break;
            }
            case 1: {
                this.y = f;
                break;
            }
            case 2: {
                this.z = f;
                break;
            }
            default: {
                throw new IndexOutOfBoundsException();
            }
        }
    }

    public float get(int n) {
        switch (n) {
            case 0: {
                return this.x;
            }
            case 1: {
                return this.y;
            }
            case 2: {
                return this.z;
            }
        }
        throw new IndexOutOfBoundsException();
    }

    public float x() {
        return this.x;
    }

    public float y() {
        return this.y;
    }

    public float z() {
        return this.z;
    }

    public void setX(float f) {
        this.x = f;
    }

    public void setY(float f) {
        this.y = f;
    }

    public void setZ(float f) {
        this.z = f;
    }

    public float dot(Vec3f vec3f) {
        return this.x * vec3f.x + this.y * vec3f.y + this.z * vec3f.z;
    }

    public float length() {
        return (float)Math.sqrt(this.lengthSquared());
    }

    public float lengthSquared() {
        return this.dot(this);
    }

    public void normalize() {
        float f = this.length();
        if (f == 0.0f) {
            return;
        }
        this.scale(1.0f / f);
    }

    public Vec3f times(float f) {
        Vec3f vec3f = new Vec3f(this);
        vec3f.scale(f);
        return vec3f;
    }

    public void scale(float f) {
        this.x *= f;
        this.y *= f;
        this.z *= f;
    }

    public Vec3f plus(Vec3f vec3f) {
        Vec3f vec3f2 = new Vec3f();
        vec3f2.add(this, vec3f);
        return vec3f2;
    }

    public void add(Vec3f vec3f) {
        this.add(this, vec3f);
    }

    public void add(Vec3f vec3f, Vec3f vec3f2) {
        this.x = vec3f.x + vec3f2.x;
        this.y = vec3f.y + vec3f2.y;
        this.z = vec3f.z + vec3f2.z;
    }

    public Vec3f addScaled(float f, Vec3f vec3f) {
        Vec3f vec3f2 = new Vec3f();
        vec3f2.addScaled(this, f, vec3f);
        return vec3f2;
    }

    public void addScaled(Vec3f vec3f, float f, Vec3f vec3f2) {
        this.x = vec3f.x + f * vec3f2.x;
        this.y = vec3f.y + f * vec3f2.y;
        this.z = vec3f.z + f * vec3f2.z;
    }

    public Vec3f minus(Vec3f vec3f) {
        Vec3f vec3f2 = new Vec3f();
        vec3f2.sub(this, vec3f);
        return vec3f2;
    }

    public void sub(Vec3f vec3f) {
        this.sub(this, vec3f);
    }

    public void sub(Vec3f vec3f, Vec3f vec3f2) {
        this.x = vec3f.x - vec3f2.x;
        this.y = vec3f.y - vec3f2.y;
        this.z = vec3f.z - vec3f2.z;
    }

    public Vec3f cross(Vec3f vec3f) {
        Vec3f vec3f2 = new Vec3f();
        vec3f2.cross(this, vec3f);
        return vec3f2;
    }

    public void cross(Vec3f vec3f, Vec3f vec3f2) {
        this.x = vec3f.y * vec3f2.z - vec3f.z * vec3f2.y;
        this.y = vec3f.z * vec3f2.x - vec3f.x * vec3f2.z;
        this.z = vec3f.x * vec3f2.y - vec3f.y * vec3f2.x;
    }

    public void componentMul(Vec3f vec3f) {
        this.x *= vec3f.x;
        this.y *= vec3f.y;
        this.z *= vec3f.z;
    }

    public Vecf toVecf() {
        Vecf vecf = new Vecf(3);
        for (int i = 0; i < 3; ++i) {
            vecf.set(i, this.get(i));
        }
        return vecf;
    }

    public String toString() {
        return "(" + this.x + ", " + this.y + ", " + this.z + ")";
    }
}

