/*
 * Decompiled with CFR 0.152.
 */
package gleem.linalg;

import gleem.linalg.Vecf;

public class Vec4f {
    private float x;
    private float y;
    private float z;
    private float w;

    public Vec4f() {
    }

    public Vec4f(Vec4f vec4f) {
        this.set(vec4f);
    }

    public Vec4f(float f, float f2, float f3, float f4) {
        this.set(f, f2, f3, f4);
    }

    public Vec4f copy() {
        return new Vec4f(this);
    }

    public void set(Vec4f vec4f) {
        this.set(vec4f.x, vec4f.y, vec4f.z, vec4f.w);
    }

    public void set(float f, float f2, float f3, float f4) {
        this.x = f;
        this.y = f2;
        this.z = f3;
        this.w = f4;
    }

    public void set(int n, float f) {
        switch (n) {
            case 0: {
                this.x = f;
                break;
            }
            case 1: {
                this.y = f;
                break;
            }
            case 2: {
                this.z = f;
                break;
            }
            case 3: {
                this.w = f;
                break;
            }
            default: {
                throw new IndexOutOfBoundsException();
            }
        }
    }

    public float get(int n) {
        switch (n) {
            case 0: {
                return this.x;
            }
            case 1: {
                return this.y;
            }
            case 2: {
                return this.z;
            }
            case 3: {
                return this.w;
            }
        }
        throw new IndexOutOfBoundsException();
    }

    public float x() {
        return this.x;
    }

    public float y() {
        return this.y;
    }

    public float z() {
        return this.z;
    }

    public float w() {
        return this.w;
    }

    public void setX(float f) {
        this.x = f;
    }

    public void setY(float f) {
        this.y = f;
    }

    public void setZ(float f) {
        this.z = f;
    }

    public void setW(float f) {
        this.w = f;
    }

    public float dot(Vec4f vec4f) {
        return this.x * vec4f.x + this.y * vec4f.y + this.z * vec4f.z + this.w * vec4f.w;
    }

    public float length() {
        return (float)Math.sqrt(this.lengthSquared());
    }

    public float lengthSquared() {
        return this.dot(this);
    }

    public void normalize() {
        float f = this.length();
        if (f == 0.0f) {
            return;
        }
        this.scale(1.0f / f);
    }

    public Vec4f times(float f) {
        Vec4f vec4f = new Vec4f(this);
        vec4f.scale(f);
        return vec4f;
    }

    public void scale(float f) {
        this.x *= f;
        this.y *= f;
        this.z *= f;
        this.w *= f;
    }

    public Vec4f plus(Vec4f vec4f) {
        Vec4f vec4f2 = new Vec4f();
        vec4f2.add(this, vec4f);
        return vec4f2;
    }

    public void add(Vec4f vec4f) {
        this.add(this, vec4f);
    }

    public void add(Vec4f vec4f, Vec4f vec4f2) {
        this.x = vec4f.x + vec4f2.x;
        this.y = vec4f.y + vec4f2.y;
        this.z = vec4f.z + vec4f2.z;
        this.w = vec4f.w + vec4f2.w;
    }

    public Vec4f addScaled(float f, Vec4f vec4f) {
        Vec4f vec4f2 = new Vec4f();
        vec4f2.addScaled(this, f, vec4f);
        return vec4f2;
    }

    public void addScaled(Vec4f vec4f, float f, Vec4f vec4f2) {
        this.x = vec4f.x + f * vec4f2.x;
        this.y = vec4f.y + f * vec4f2.y;
        this.z = vec4f.z + f * vec4f2.z;
        this.w = vec4f.w + f * vec4f2.w;
    }

    public Vec4f minus(Vec4f vec4f) {
        Vec4f vec4f2 = new Vec4f();
        vec4f2.sub(this, vec4f);
        return vec4f2;
    }

    public void sub(Vec4f vec4f) {
        this.sub(this, vec4f);
    }

    public void sub(Vec4f vec4f, Vec4f vec4f2) {
        this.x = vec4f.x - vec4f2.x;
        this.y = vec4f.y - vec4f2.y;
        this.z = vec4f.z - vec4f2.z;
        this.w = vec4f.w - vec4f2.w;
    }

    public void componentMul(Vec4f vec4f) {
        this.x *= vec4f.x;
        this.y *= vec4f.y;
        this.z *= vec4f.z;
        this.w *= vec4f.w;
    }

    public Vecf toVecf() {
        Vecf vecf = new Vecf(4);
        for (int i = 0; i < 4; ++i) {
            vecf.set(i, this.get(i));
        }
        return vecf;
    }

    public String toString() {
        return "(" + this.x + ", " + this.y + ", " + this.z + ")";
    }
}

