/*
 * Decompiled with CFR 0.152.
 */
package gleem.linalg;

import gleem.linalg.DimensionMismatchException;
import gleem.linalg.Vec2f;
import gleem.linalg.Vec3f;
import gleem.linalg.Veci;

public class Vecf {
    private float[] data;

    public Vecf(int n) {
        this.data = new float[n];
    }

    public Vecf(Vecf vecf) {
        this.data = new float[vecf.data.length];
        System.arraycopy(vecf.data, 0, this.data, 0, this.data.length);
    }

    public int length() {
        return this.data.length;
    }

    public float get(int n) {
        return this.data[n];
    }

    public void set(int n, float f) {
        this.data[n] = f;
    }

    public Vec2f toVec2f() throws DimensionMismatchException {
        if (this.length() != 2) {
            throw new DimensionMismatchException();
        }
        Vec2f vec2f = new Vec2f();
        for (int i = 0; i < 2; ++i) {
            vec2f.set(i, this.get(i));
        }
        return vec2f;
    }

    public Vec3f toVec3f() throws DimensionMismatchException {
        if (this.length() != 3) {
            throw new DimensionMismatchException();
        }
        Vec3f vec3f = new Vec3f();
        for (int i = 0; i < 3; ++i) {
            vec3f.set(i, this.get(i));
        }
        return vec3f;
    }

    public Veci toInt() {
        Veci veci = new Veci(this.length());
        for (int i = 0; i < this.length(); ++i) {
            veci.set(i, (int)this.get(i));
        }
        return veci;
    }
}

