/*
 * Decompiled with CFR 0.152.
 */
package gleem.linalg;

import gleem.linalg.DimensionMismatchException;
import gleem.linalg.Vec2f;
import gleem.linalg.Vec3f;
import gleem.linalg.Vecf;

public class Veci {
    private int[] data;

    public Veci(int n) {
        this.data = new int[n];
    }

    public Veci(Veci veci) {
        this.data = new int[veci.data.length];
        System.arraycopy(veci.data, 0, this.data, 0, this.data.length);
    }

    public int length() {
        return this.data.length;
    }

    public int get(int n) {
        return this.data[n];
    }

    public void set(int n, int n2) {
        this.data[n] = n2;
    }

    public Vec2f toVec2f() throws DimensionMismatchException {
        if (this.length() != 2) {
            throw new DimensionMismatchException();
        }
        Vec2f vec2f = new Vec2f();
        for (int i = 0; i < 2; ++i) {
            vec2f.set(i, (float)this.get(i));
        }
        return vec2f;
    }

    public Vec3f toVec3f() throws DimensionMismatchException {
        if (this.length() != 3) {
            throw new DimensionMismatchException();
        }
        Vec3f vec3f = new Vec3f();
        for (int i = 0; i < 3; ++i) {
            vec3f.set(i, this.get(i));
        }
        return vec3f;
    }

    public Vecf toVecf() {
        Vecf vecf = new Vecf(this.length());
        for (int i = 0; i < this.length(); ++i) {
            vecf.set(i, this.get(i));
        }
        return vecf;
    }
}

