/*
 * Decompiled with CFR 0.152.
 */
package demos.context;

import com.sun.opengl.util.GLUT;
import java.awt.Canvas;
import java.awt.Component;
import java.awt.Graphics;
import java.awt.GraphicsConfiguration;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.media.opengl.AWTGraphicsConfiguration;
import javax.media.opengl.GL;
import javax.media.opengl.GLCapabilities;
import javax.media.opengl.GLContext;
import javax.media.opengl.GLDrawable;
import javax.media.opengl.GLDrawableFactory;
import javax.media.opengl.glu.GLU;
import javax.swing.JButton;
import javax.swing.JFrame;

public class DualContext
extends Canvas {
    private GLDrawable drawable;
    private GLContext context1;
    private GLContext context2;
    private GLU glu;
    private GLUT glut;
    private int repaintNum;

    public DualContext(GLCapabilities gLCapabilities) {
        super(DualContext.unwrap((AWTGraphicsConfiguration)GLDrawableFactory.getFactory().chooseGraphicsConfiguration(gLCapabilities, null, null)));
        this.drawable = GLDrawableFactory.getFactory().getGLDrawable((Object)this, gLCapabilities, null);
        this.context1 = this.drawable.createContext(null);
        this.context2 = this.drawable.createContext(null);
        this.glu = new GLU();
        this.glut = new GLUT();
    }

    public void addNotify() {
        super.addNotify();
        this.drawable.setRealized(true);
    }

    public void removeNotify() {
        this.context1.destroy();
        this.context2.destroy();
        this.drawable.setRealized(false);
    }

    public void paint(Graphics graphics) {
        int n = this.getWidth();
        int n2 = this.getHeight();
        int n3 = n / 2;
        String string = "" + ++this.repaintNum;
        int n4 = this.context1.makeCurrent();
        if (n4 != 0) {
            this.clearAndDraw(this.context1.getGL(), 1.0f, 0.0f, 0.0f, 0, 0, n3, n2, string);
            this.context1.release();
        }
        if ((n4 = this.context2.makeCurrent()) != 0) {
            this.clearAndDraw(this.context2.getGL(), 0.0f, 0.0f, 1.0f, n3, 0, n - n3, n2, string);
            this.context2.release();
        }
        this.drawable.swapBuffers();
    }

    private void clearAndDraw(GL gL, float f, float f2, float f3, int n, int n2, int n3, int n4, String string) {
        gL.glViewport(n, n2, n3, n4);
        gL.glScissor(n, n2, n3, n4);
        gL.glEnable(3089);
        gL.glClearColor(f, f2, f3, 1.0f);
        gL.glClear(16640);
        float f4 = this.glut.glutStrokeLengthf(0, string);
        gL.glMatrixMode(5889);
        gL.glLoadIdentity();
        this.glu.gluOrtho2D((double)n, (double)(n + n3), (double)n2, (double)(n2 + n4));
        gL.glTranslatef((float)n + ((float)n3 - f4) / 2.0f, (float)(n2 + n4 / 2), 0.0f);
        this.glut.glutStrokeString(0, string);
    }

    public static void main(String[] stringArray) {
        JFrame jFrame = new JFrame("Dual OpenGL Context Test");
        final DualContext dualContext = new DualContext(new GLCapabilities());
        jFrame.getContentPane().add((Component)dualContext, "Center");
        JButton jButton = new JButton("Repaint");
        jButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                dualContext.repaint();
            }
        });
        jFrame.setDefaultCloseOperation(3);
        jFrame.getContentPane().add((Component)jButton, "South");
        jFrame.setSize(800, 400);
        jFrame.setVisible(true);
    }

    private static GraphicsConfiguration unwrap(AWTGraphicsConfiguration aWTGraphicsConfiguration) {
        if (aWTGraphicsConfiguration == null) {
            return null;
        }
        return aWTGraphicsConfiguration.getGraphicsConfiguration();
    }
}

