/*
 * Decompiled with CFR 0.152.
 */
package demos.fullscreen;

import com.sun.opengl.util.Animator;
import demos.fullscreen.FullscreenWorkaround;
import demos.gears.Gears;
import demos.util.ScreenResSelector;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.DisplayMode;
import java.awt.EventQueue;
import java.awt.GraphicsDevice;
import java.awt.GraphicsEnvironment;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import javax.media.opengl.GLAutoDrawable;
import javax.media.opengl.GLCanvas;
import javax.media.opengl.GLEventListener;
import javax.swing.JButton;
import javax.swing.JFrame;
import javax.swing.ToolTipManager;

public class GearsFullscreen2 {
    private GraphicsDevice dev;
    private DisplayMode origMode;
    private boolean fullScreen;
    private JFrame frame;
    private Animator animator;
    private int initWidth = 300;
    private int initHeight = 300;

    public static void main(String[] stringArray) {
        new GearsFullscreen2().run(stringArray);
    }

    public void run(String[] stringArray) {
        this.dev = GraphicsEnvironment.getLocalGraphicsEnvironment().getDefaultScreenDevice();
        this.origMode = this.dev.getDisplayMode();
        DisplayMode displayMode = null;
        if (this.dev.isFullScreenSupported()) {
            displayMode = ScreenResSelector.showSelectionDialog();
            if (displayMode != null) {
                this.initWidth = displayMode.getWidth();
                this.initHeight = displayMode.getHeight();
            }
        } else {
            System.err.println("NOTE: full-screen mode not supported; running in window instead");
        }
        this.frame = new JFrame("Gear Demo");
        if (displayMode != null) {
            this.frame.setUndecorated(true);
        }
        GLCanvas gLCanvas = new GLCanvas();
        gLCanvas.addGLEventListener((GLEventListener)new Gears());
        gLCanvas.addGLEventListener((GLEventListener)new FullscreenWorkaround(this.initWidth, this.initHeight));
        this.frame.getContentPane().setLayout(new BorderLayout());
        ToolTipManager.sharedInstance().setLightWeightPopupEnabled(false);
        JButton jButton = new JButton("West");
        jButton.setToolTipText("West ToolTip");
        this.frame.getContentPane().add((Component)jButton, "West");
        jButton = new JButton("East");
        jButton.setToolTipText("East ToolTip");
        this.frame.getContentPane().add((Component)jButton, "East");
        jButton = new JButton("North");
        jButton.setToolTipText("North ToolTip");
        this.frame.getContentPane().add((Component)jButton, "North");
        jButton = new JButton("South");
        jButton.setToolTipText("South ToolTip");
        this.frame.getContentPane().add((Component)jButton, "South");
        this.frame.getContentPane().add((Component)gLCanvas, "Center");
        this.frame.setSize(this.initWidth, this.initHeight);
        this.animator = new Animator((GLAutoDrawable)gLCanvas);
        this.frame.addWindowListener(new WindowAdapter(){

            public void windowClosing(WindowEvent windowEvent) {
                GearsFullscreen2.this.runExit();
            }
        });
        this.frame.setVisible(true);
        if (this.dev.isFullScreenSupported() && displayMode != null) {
            this.dev.setFullScreenWindow(this.frame);
            if (this.dev.isDisplayChangeSupported()) {
                this.dev.setDisplayMode(displayMode);
                this.fullScreen = true;
            } else {
                this.dev.setFullScreenWindow(null);
                final JFrame jFrame = this.frame;
                try {
                    EventQueue.invokeAndWait(new Runnable(){

                        public void run() {
                            jFrame.setVisible(false);
                            jFrame.setUndecorated(false);
                            jFrame.setVisible(true);
                            jFrame.setSize(GearsFullscreen2.this.initWidth, GearsFullscreen2.this.initHeight);
                        }
                    });
                }
                catch (Exception exception) {
                    exception.printStackTrace();
                }
                System.err.println("NOTE: was not able to change display mode; full-screen disabled");
            }
        }
        this.animator.start();
    }

    public void runExit() {
        new Thread(new Runnable(){

            public void run() {
                GearsFullscreen2.this.animator.stop();
                try {
                    EventQueue.invokeAndWait(new Runnable(this){
                        private final /* synthetic */ 3 this$1;
                        {
                            this.this$1 = var1_1;
                        }

                        public void run() {
                            if (GearsFullscreen2.access$400(3.access$300(this.this$1))) {
                                try {
                                    GearsFullscreen2.access$600(3.access$300(this.this$1)).setDisplayMode(GearsFullscreen2.access$500(3.access$300(this.this$1)));
                                }
                                catch (Exception exception) {
                                    // empty catch block
                                }
                                try {
                                    GearsFullscreen2.access$600(3.access$300(this.this$1)).setFullScreenWindow(null);
                                }
                                catch (Exception exception) {
                                    // empty catch block
                                }
                                GearsFullscreen2.access$402(3.access$300(this.this$1), false);
                            }
                        }
                    });
                }
                catch (Exception exception) {
                    exception.printStackTrace();
                }
                System.exit(0);
            }

            static /* synthetic */ GearsFullscreen2 access$300(3 var0) {
                return var0.GearsFullscreen2.this;
            }
        }).start();
    }

    static /* synthetic */ boolean access$400(GearsFullscreen2 gearsFullscreen2) {
        return gearsFullscreen2.fullScreen;
    }

    static /* synthetic */ DisplayMode access$500(GearsFullscreen2 gearsFullscreen2) {
        return gearsFullscreen2.origMode;
    }

    static /* synthetic */ GraphicsDevice access$600(GearsFullscreen2 gearsFullscreen2) {
        return gearsFullscreen2.dev;
    }

    static /* synthetic */ boolean access$402(GearsFullscreen2 gearsFullscreen2, boolean bl) {
        gearsFullscreen2.fullScreen = bl;
        return gearsFullscreen2.fullScreen;
    }
}

