/*
 * Decompiled with CFR 0.152.
 */
package demos.hdr;

import demos.hdr.Pipeline;
import demos.util.FileUtils;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.List;
import javax.media.opengl.GL;
import javax.media.opengl.GLException;

public class ARBFPPipeline
implements Pipeline {
    private int textureFormat;
    private List programs = new ArrayList();

    public ARBFPPipeline(int n) {
        this.textureFormat = n;
    }

    public void init() {
    }

    public void initFloatingPointTexture(GL gL, int n, int n2, int n3) {
        gL.glBindTexture(34037, n);
        gL.glCopyTexImage2D(34037, 0, this.textureFormat, 0, 0, n2, n3, 0);
    }

    public void initTexture(GL gL, int n, int n2, int n3) {
        gL.glBindTexture(34037, n);
        gL.glCopyTexImage2D(34037, 0, 6408, 0, 0, n2, n3, 0);
    }

    public void copyToTexture(GL gL, int n, int n2, int n3) {
        gL.glBindTexture(34037, n);
        gL.glCopyTexSubImage2D(34037, 0, 0, 0, 0, 0, n2, n3);
    }

    public void bindTexture(GL gL, int n) {
        gL.glBindTexture(34037, n);
    }

    public int loadVertexProgram(GL gL, String string) throws IOException {
        return this.loadProgram(gL, string, 34336);
    }

    public int loadFragmentProgram(GL gL, String string) throws IOException {
        return this.loadProgram(gL, string, 34820);
    }

    private int loadProgram(GL gL, String string, int n) throws IOException {
        String string2 = FileUtils.loadStreamIntoString((InputStream)this.getClass().getClassLoader().getResourceAsStream(string));
        int[] nArray = new int[1];
        gL.glGenProgramsARB(1, nArray, 0);
        int n2 = nArray[0];
        gL.glBindProgramARB(n, n2);
        gL.glProgramStringARB(n, 34933, string2.length(), string2);
        int[] nArray2 = new int[1];
        gL.glGetIntegerv(34379, nArray2, 0);
        if (nArray2[0] >= 0) {
            int n3;
            String string3 = "Program";
            if (n == 34336) {
                string3 = "Vertex program";
            } else if (n == 34820) {
                string3 = "Fragment program";
            }
            System.out.println(string3 + " failed to load:");
            String string4 = gL.glGetString(34932);
            if (string4 == null) {
                System.out.println("[No error message available]");
            } else {
                System.out.println("Error message: \"" + string4 + "\"");
            }
            System.out.println("Error occurred at position " + nArray2[0] + " in program:");
            for (n3 = nArray2[0]; n3 < string2.length() && string2.charAt(n3) != '\n'; ++n3) {
            }
            System.out.println(string2.substring(nArray2[0], n3));
            throw new GLException("Error loading " + string3);
        }
        if (n == 34820) {
            int[] nArray3 = new int[1];
            gL.glGetProgramivARB(34820, 34998, nArray3, 0);
            if (nArray3[0] != 1) {
                System.out.println("WARNING: fragment program is over native resource limits");
                Thread.dumpStack();
            }
        }
        return n2;
    }

    public void enableVertexProgram(GL gL, int n) {
        gL.glBindProgramARB(34336, n);
        gL.glEnable(34336);
    }

    public void enableFragmentProgram(GL gL, int n) {
        gL.glBindProgramARB(34820, n);
        gL.glEnable(34820);
    }

    public void disableVertexProgram(GL gL) {
        gL.glDisable(34336);
    }

    public void disableFragmentProgram(GL gL) {
        gL.glDisable(34820);
    }

    public int getNamedParameter(int n, String string) {
        throw new RuntimeException("Not supported");
    }

    public void setVertexProgramParameter1f(GL gL, int n, float f) {
        if (n < 0) {
            return;
        }
        gL.glProgramLocalParameter4fARB(34336, n, f, 0.0f, 0.0f, 0.0f);
    }

    public void setVertexProgramParameter3f(GL gL, int n, float f, float f2, float f3) {
        if (n < 0) {
            return;
        }
        gL.glProgramLocalParameter4fARB(34336, n, f, f2, f3, 0.0f);
    }

    public void setVertexProgramParameter4f(GL gL, int n, float f, float f2, float f3, float f4) {
        if (n < 0) {
            return;
        }
        gL.glProgramLocalParameter4fARB(34336, n, f, f2, f3, f4);
    }

    public void setFragmentProgramParameter1f(GL gL, int n, float f) {
        if (n < 0) {
            return;
        }
        gL.glProgramLocalParameter4fARB(34820, n, f, 0.0f, 0.0f, 0.0f);
    }

    public void setFragmentProgramParameter3f(GL gL, int n, float f, float f2, float f3) {
        if (n < 0) {
            return;
        }
        gL.glProgramLocalParameter4fARB(34820, n, f, f2, f3, 0.0f);
    }

    public void setFragmentProgramParameter4f(GL gL, int n, float f, float f2, float f3, float f4) {
        if (n < 0) {
            return;
        }
        gL.glProgramLocalParameter4fARB(34820, n, f, f2, f3, f4);
    }

    public void trackModelViewProjectionMatrix(GL gL, int n) {
        float[] fArray = new float[16];
        float[] fArray2 = new float[16];
        float[] fArray3 = new float[16];
        gL.glGetFloatv(2983, fArray2, 0);
        gL.glGetFloatv(2982, fArray, 0);
        for (int i = 0; i < 4; ++i) {
            for (int j = 0; j < 4; ++j) {
                float f = 0.0f;
                for (int k = 0; k < 4; ++k) {
                    f += fArray[4 * i + k] * fArray2[4 * k + j];
                }
                fArray3[4 * i + j] = f;
            }
        }
        this.setMatrixParameterfc(gL, n, fArray3);
    }

    public void setMatrixParameterfc(GL gL, int n, float[] fArray) {
        for (int i = 0; i < 4; ++i) {
            gL.glProgramLocalParameter4fARB(34336, n + i, fArray[i], fArray[4 + i], fArray[8 + i], fArray[12 + i]);
        }
    }
}

