/*
 * Decompiled with CFR 0.152.
 */
package demos.hwShadowmapsSimple;

import com.sun.opengl.util.GLUT;
import com.sun.opengl.util.texture.Texture;
import com.sun.opengl.util.texture.TextureIO;
import demos.common.Demo;
import demos.common.DemoListener;
import gleem.BSphere;
import gleem.BSphereProvider;
import gleem.CameraParameters;
import gleem.ExaminerViewer;
import gleem.HandleBoxManip;
import gleem.Manip;
import gleem.ManipManager;
import gleem.MouseButtonHelper;
import gleem.linalg.Mat4f;
import gleem.linalg.Rotf;
import gleem.linalg.Vec3f;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Frame;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.List;
import javax.media.opengl.GL;
import javax.media.opengl.GLAutoDrawable;
import javax.media.opengl.GLCanvas;
import javax.media.opengl.GLCapabilities;
import javax.media.opengl.GLDrawableFactory;
import javax.media.opengl.GLEventListener;
import javax.media.opengl.GLException;
import javax.media.opengl.GLPbuffer;
import javax.media.opengl.glu.GLU;
import javax.swing.JOptionPane;

public class HWShadowmapsSimple
extends Demo {
    private GLPbuffer pbuffer;
    private GLU glu;
    private GLUT glut;
    private float[] light_ambient = new float[]{0.0f, 0.0f, 0.0f, 0.0f};
    private float[] light_intensity = new float[]{1.0f, 1.0f, 1.0f, 1.0f};
    private float[] light_pos = new float[]{0.0f, 0.0f, 0.0f, 1.0f};
    private List tweaks = new ArrayList();
    private static final int R_COORDINATE_SCALE = 0;
    private static final int R_COORDINATE_BIAS = 1;
    private static final int POLYGON_OFFSET_SCALE = 2;
    private static final int POLYGON_OFFSET_BIAS = 3;
    private int curr_tweak;
    private static final int TEX_SIZE = 1024;
    private Texture decal;
    private Texture light_image;
    private int light_view_depth;
    private int depth_format;
    private boolean fullyInitialized;
    private static final int RENDER_SCENE_FROM_CAMERA_VIEW = 0;
    private static final int RENDER_SCENE_FROM_CAMERA_VIEW_SHADOWED = 1;
    private static final int RENDER_SCENE_FROM_LIGHT_VIEW = 2;
    private static final int NUM_DISPLAY_MODES = 3;
    private int displayMode = 1;
    private int quad;
    private int wirecube;
    private int geometry;
    private float lightshaper_fovy = 60.0f;
    private float lightshaper_zNear = 0.5f;
    private float lightshaper_zFar = 5.0f;
    private GLAutoDrawable drawable;
    private ExaminerViewer viewer;
    private boolean doViewAll = true;
    private float zNear = 0.5f;
    private float zFar = 50.0f;
    private HandleBoxManip object;
    private HandleBoxManip spotlight;
    private Mat4f cameraPerspective = new Mat4f();
    private Mat4f cameraTransform = new Mat4f();
    private Mat4f cameraInverseTransform = new Mat4f();
    private Mat4f spotlightTransform = new Mat4f();
    private Mat4f spotlightInverseTransform = new Mat4f();
    private Mat4f objectTransform = new Mat4f();
    private int viewportX;
    private int viewportY;

    public static void main(String[] stringArray) {
        final GLCanvas gLCanvas = new GLCanvas();
        HWShadowmapsSimple hWShadowmapsSimple = new HWShadowmapsSimple();
        gLCanvas.addGLEventListener((GLEventListener)hWShadowmapsSimple);
        hWShadowmapsSimple.setDemoListener(new DemoListener(){

            public void shutdownDemo() {
                HWShadowmapsSimple.runExit();
            }

            public void repaint() {
                gLCanvas.repaint();
            }
        });
        Frame frame = new Frame("ARB_shadow Shadows");
        frame.setLayout(new BorderLayout());
        gLCanvas.setSize(512, 512);
        frame.add((Component)gLCanvas, "Center");
        frame.pack();
        frame.show();
        gLCanvas.requestFocus();
        frame.addWindowListener(new WindowAdapter(){

            public void windowClosing(WindowEvent windowEvent) {
                HWShadowmapsSimple.runExit();
            }
        });
    }

    public void shutdownDemo() {
        ManipManager.getManipManager().unregisterWindow(this.drawable);
        this.drawable.removeGLEventListener((GLEventListener)this);
        super.shutdownDemo();
    }

    public void init(GLAutoDrawable gLAutoDrawable) {
        GL gL = gLAutoDrawable.getGL();
        this.glu = new GLU();
        this.glut = new GLUT();
        try {
            this.checkExtension(gL, "GL_VERSION_1_3");
            this.checkExtension(gL, "GL_ARB_depth_texture");
            this.checkExtension(gL, "GL_ARB_shadow");
            this.checkExtension(gL, "GL_ARB_pbuffer");
            this.checkExtension(gL, "GL_ARB_pixel_format");
        }
        catch (GLException gLException) {
            gLException.printStackTrace();
            throw gLException;
        }
        gL.glClearColor(0.5f, 0.5f, 0.5f, 0.5f);
        try {
            this.decal = TextureIO.newTexture((InputStream)this.getClass().getClassLoader().getResourceAsStream("demos/data/images/decal_image.png"), (boolean)true, (String)"png");
            this.decal.setTexParameteri(10242, 10497);
            this.decal.setTexParameteri(10243, 10497);
            this.light_image = TextureIO.newTexture((InputStream)this.getClass().getClassLoader().getResourceAsStream("demos/data/images/nvlogo_spot.png"), (boolean)true, (String)"png");
        }
        catch (IOException iOException) {
            throw new GLException((Throwable)iOException);
        }
        this.quad = gL.glGenLists(1);
        gL.glNewList(this.quad, 4864);
        gL.glPushMatrix();
        gL.glRotatef(-90.0f, 1.0f, 0.0f, 0.0f);
        gL.glScalef(4.0f, 4.0f, 4.0f);
        gL.glBegin(7);
        gL.glNormal3f(0.0f, 0.0f, 1.0f);
        gL.glVertex2f(-1.0f, -1.0f);
        gL.glVertex2f(-1.0f, 1.0f);
        gL.glVertex2f(1.0f, 1.0f);
        gL.glVertex2f(1.0f, -1.0f);
        gL.glEnd();
        gL.glPopMatrix();
        gL.glEndList();
        this.wirecube = gL.glGenLists(1);
        gL.glNewList(this.wirecube, 4864);
        this.glut.glutWireCube(2.0f);
        gL.glEndList();
        this.geometry = gL.glGenLists(1);
        gL.glNewList(this.geometry, 4864);
        gL.glPushMatrix();
        this.glut.glutSolidTeapot((double)0.8f);
        gL.glPopMatrix();
        gL.glEndList();
        gL.glEnable(16384);
        gL.glLightfv(16384, 4608, this.light_ambient, 0);
        gL.glLightfv(16384, 4609, this.light_intensity, 0);
        gL.glLightfv(16384, 4610, this.light_intensity, 0);
        gL.glEnable(2929);
        GLCapabilities gLCapabilities = new GLCapabilities();
        gLCapabilities.setDoubleBuffered(false);
        if (!GLDrawableFactory.getFactory().canCreateGLPbuffer()) {
            this.unavailableExtension("Can not create pbuffer");
        }
        if (this.pbuffer != null) {
            this.pbuffer.destroy();
            this.pbuffer = null;
        }
        this.pbuffer = GLDrawableFactory.getFactory().createGLPbuffer(gLCapabilities, null, 1024, 1024, gLAutoDrawable.getContext());
        this.pbuffer.addGLEventListener((GLEventListener)new PbufferListener());
        this.doViewAll = true;
        ManipManager manipManager = ManipManager.getManipManager();
        manipManager.registerWindow(gLAutoDrawable);
        this.drawable = gLAutoDrawable;
        this.object = new HandleBoxManip();
        this.object.setTranslation(new Vec3f(0.0f, 0.7f, 1.8f));
        this.object.setGeometryScale(new Vec3f(0.7f, 0.7f, 0.7f));
        manipManager.showManipInWindow((Manip)this.object, gLAutoDrawable);
        this.spotlight = new HandleBoxManip();
        this.spotlight.setScale(new Vec3f(0.5f, 0.5f, 0.5f));
        this.spotlight.setTranslation(new Vec3f(-0.25f, 2.35f, 5.0f));
        this.spotlight.setRotation(new Rotf(Vec3f.X_AXIS, (float)Math.toRadians(-30.0)));
        manipManager.showManipInWindow((Manip)this.spotlight, gLAutoDrawable);
        this.viewer = new ExaminerViewer(MouseButtonHelper.numMouseButtons());
        this.viewer.attach(gLAutoDrawable, new BSphereProvider(){

            public BSphere getBoundingSphere() {
                return new BSphere(HWShadowmapsSimple.this.object.getTranslation(), 2.0f);
            }
        });
        this.viewer.setOrientation(new Rotf(Vec3f.Y_AXIS, (float)Math.toRadians(45.0)).times(new Rotf(Vec3f.X_AXIS, (float)Math.toRadians(-15.0))));
        this.viewer.setVertFOV((float)Math.toRadians(this.lightshaper_fovy / 2.0f));
        this.viewer.setZNear(this.zNear);
        this.viewer.setZFar(this.zFar);
        float f = 1.0f / ((float)Math.pow(2.0, 16.0) - 1.0f);
        this.tweaks.add(new Tweak("r coordinate scale", 0.5f, f));
        this.tweaks.add(new Tweak("r coordinate bias", 0.5f, f));
        this.tweaks.add(new Tweak("polygon offset scale", 2.5f, 0.5f));
        this.tweaks.add(new Tweak("polygon offset bias", 10.0f, 1.0f));
        gLAutoDrawable.addKeyListener((KeyListener)new KeyAdapter(){

            public void keyPressed(KeyEvent keyEvent) {
                HWShadowmapsSimple.this.dispatchKey(keyEvent.getKeyChar());
                HWShadowmapsSimple.this.demoListener.repaint();
            }
        });
    }

    public void display(GLAutoDrawable gLAutoDrawable) {
        this.viewer.update();
        CameraParameters cameraParameters = this.viewer.getCameraParameters();
        this.cameraPerspective.set(cameraParameters.getProjectionMatrix());
        this.cameraInverseTransform.set(cameraParameters.getModelviewMatrix());
        this.cameraTransform.set(this.cameraInverseTransform);
        this.cameraTransform.invertRigid();
        this.spotlightTransform.set(this.spotlight.getTransform());
        this.spotlightInverseTransform.set(this.spotlightTransform);
        this.spotlightInverseTransform.invertRigid();
        this.objectTransform.set(this.object.getTransform());
        if (!(this.displayMode != 1 && this.fullyInitialized || this.pbuffer == null)) {
            this.pbuffer.display();
        }
        if (!this.fullyInitialized) {
            this.demoListener.repaint();
            return;
        }
        GL gL = gLAutoDrawable.getGL();
        gL.glClear(16640);
        if (this.doViewAll) {
            this.viewer.viewAll(gL);
            this.doViewAll = false;
            gL.glMatrixMode(5889);
            gL.glLoadIdentity();
            gL.glMatrixMode(5888);
            gL.glLoadIdentity();
            this.demoListener.repaint();
        }
        switch (this.displayMode) {
            case 0: {
                this.render_scene_from_camera_view(gL, gLAutoDrawable, cameraParameters);
                break;
            }
            case 1: {
                this.render_scene_from_camera_view_shadowed(gL, gLAutoDrawable, cameraParameters);
                break;
            }
            case 2: {
                this.render_scene_from_light_view(gL, gLAutoDrawable, this.viewportX, this.viewportY);
                break;
            }
            default: {
                throw new RuntimeException("Illegal display mode " + this.displayMode);
            }
        }
    }

    public void reshape(GLAutoDrawable gLAutoDrawable, int n, int n2, int n3, int n4) {
        this.viewportX = n;
        this.viewportY = n2;
    }

    public void displayChanged(GLAutoDrawable gLAutoDrawable, boolean bl, boolean bl2) {
    }

    private void checkExtension(GL gL, String string) {
        if (!gL.isExtensionAvailable(string)) {
            String string2 = "Unable to initialize " + string + " OpenGL extension";
            this.unavailableExtension(string2);
        }
    }

    private void unavailableExtension(String string) {
        JOptionPane.showMessageDialog(null, string, "Unavailable extension", 0);
        throw new GLException(string);
    }

    private void dispatchKey(char c) {
        switch (c) {
            case '\u001b': 
            case 'q': {
                this.shutdownDemo();
                break;
            }
            case 'v': {
                this.doViewAll = true;
                System.err.println("Forcing viewAll()");
                break;
            }
            case ' ': {
                this.displayMode = (this.displayMode + 1) % 3;
                System.err.println("Switching to display mode " + this.displayMode);
                break;
            }
        }
    }

    private void set_light_view_texture_parameters(GL gL) {
        gL.glBindTexture(3553, this.light_view_depth);
        gL.glTexParameteri(3553, 10241, 9729);
        gL.glTexParameteri(3553, 10240, 9729);
        gL.glTexParameteri(3553, 10242, 33071);
        gL.glTexParameteri(3553, 10243, 33071);
        gL.glTexParameteri(3553, 34892, 34894);
        gL.glTexParameteri(3553, 34893, 515);
    }

    private int genTexture(GL gL) {
        int[] nArray = new int[1];
        gL.glGenTextures(1, nArray, 0);
        return nArray[0];
    }

    private void eye_linear_texgen(GL gL) {
        Mat4f mat4f = new Mat4f();
        mat4f.makeIdent();
        this.set_texgen_planes(gL, 9474, mat4f);
        gL.glTexGeni(8192, 9472, 9216);
        gL.glTexGeni(8193, 9472, 9216);
        gL.glTexGeni(8194, 9472, 9216);
        gL.glTexGeni(8195, 9472, 9216);
    }

    private void obj_linear_texgen(GL gL) {
        Mat4f mat4f = new Mat4f();
        mat4f.makeIdent();
        this.set_texgen_planes(gL, 9473, mat4f);
        gL.glTexGeni(8192, 9472, 9217);
        gL.glTexGeni(8193, 9472, 9217);
        gL.glTexGeni(8194, 9472, 9217);
        gL.glTexGeni(8195, 9472, 9217);
    }

    private void set_texgen_planes(GL gL, int n, Mat4f mat4f) {
        int[] nArray = new int[]{8192, 8193, 8194, 8195};
        float[] fArray = new float[4];
        for (int i = 0; i < 4; ++i) {
            HWShadowmapsSimple.getRow(mat4f, i, fArray);
            gL.glTexGenfv(nArray[i], n, fArray, 0);
        }
    }

    private void texgen(GL gL, boolean bl) {
        if (bl) {
            gL.glEnable(3168);
            gL.glEnable(3169);
            gL.glEnable(3170);
            gL.glEnable(3171);
        } else {
            gL.glDisable(3168);
            gL.glDisable(3169);
            gL.glDisable(3170);
            gL.glDisable(3171);
        }
    }

    private void render_light_frustum(GL gL) {
        gL.glPushMatrix();
        HWShadowmapsSimple.applyTransform(gL, this.cameraInverseTransform);
        HWShadowmapsSimple.applyTransform(gL, this.spotlightTransform);
        HWShadowmapsSimple.applyTransform(gL, HWShadowmapsSimple.perspectiveInverse(this.lightshaper_fovy, 1.0f, this.lightshaper_zNear, this.lightshaper_zFar));
        gL.glDisable(2896);
        gL.glColor3f(1.0f, 1.0f, 0.0f);
        gL.glCallList(this.wirecube);
        gL.glColor3f(1.0f, 1.0f, 1.0f);
        gL.glEnable(2896);
        gL.glPopMatrix();
    }

    private void render_quad(GL gL) {
        gL.glActiveTexture(33984);
        this.obj_linear_texgen(gL);
        this.texgen(gL, true);
        gL.glMatrixMode(5890);
        gL.glLoadIdentity();
        gL.glScalef(4.0f, 4.0f, 1.0f);
        gL.glMatrixMode(5888);
        gL.glDisable(2896);
        this.decal.bind();
        this.decal.enable();
        gL.glCallList(this.quad);
        this.decal.disable();
        gL.glEnable(2896);
        this.texgen(gL, false);
        gL.glMatrixMode(5890);
        gL.glLoadIdentity();
        gL.glMatrixMode(5888);
    }

    private void render_scene(GL gL, Mat4f mat4f, GLAutoDrawable gLAutoDrawable, CameraParameters cameraParameters) {
        gL.glColor3f(1.0f, 1.0f, 1.0f);
        gL.glPushMatrix();
        Mat4f mat4f2 = new Mat4f(mat4f);
        mat4f2.invertRigid();
        HWShadowmapsSimple.applyTransform(gL, mat4f2);
        gL.glPushMatrix();
        this.render_quad(gL);
        HWShadowmapsSimple.applyTransform(gL, this.objectTransform);
        gL.glEnable(2896);
        gL.glCallList(this.geometry);
        gL.glDisable(2896);
        gL.glPopMatrix();
        gL.glPopMatrix();
    }

    private void render_manipulators(GL gL, Mat4f mat4f, GLAutoDrawable gLAutoDrawable, CameraParameters cameraParameters) {
        gL.glColor3f(1.0f, 1.0f, 1.0f);
        gL.glPushMatrix();
        Mat4f mat4f2 = new Mat4f(mat4f);
        mat4f2.invertRigid();
        HWShadowmapsSimple.applyTransform(gL, mat4f2);
        if (cameraParameters != null) {
            ManipManager.getManipManager().updateCameraParameters(gLAutoDrawable, cameraParameters);
            ManipManager.getManipManager().render(gLAutoDrawable, gL);
        }
        gL.glPopMatrix();
    }

    private void render_scene_from_camera_view(GL gL, GLAutoDrawable gLAutoDrawable, CameraParameters cameraParameters) {
        gL.glPushMatrix();
        gL.glLoadIdentity();
        HWShadowmapsSimple.applyTransform(gL, this.cameraInverseTransform);
        HWShadowmapsSimple.applyTransform(gL, this.spotlightTransform);
        gL.glLightfv(16384, 4611, this.light_pos, 0);
        gL.glPopMatrix();
        gL.glActiveTexture(33985);
        gL.glPushMatrix();
        HWShadowmapsSimple.applyTransform(gL, this.cameraInverseTransform);
        this.eye_linear_texgen(gL);
        this.texgen(gL, true);
        gL.glPopMatrix();
        gL.glMatrixMode(5890);
        gL.glLoadIdentity();
        gL.glTranslatef(0.5f, 0.5f, 0.5f);
        gL.glScalef(0.5f, -0.5f, 0.5f);
        this.glu.gluPerspective((double)this.lightshaper_fovy, 1.0, (double)this.lightshaper_zNear, (double)this.lightshaper_zFar);
        HWShadowmapsSimple.applyTransform(gL, this.spotlightInverseTransform);
        gL.glMatrixMode(5888);
        this.light_image.bind();
        this.light_image.enable();
        gL.glTexEnvi(8960, 8704, 8448);
        gL.glActiveTexture(33984);
        gL.glMatrixMode(5889);
        gL.glLoadIdentity();
        gL.glViewport(this.viewportX, this.viewportY, gLAutoDrawable.getWidth(), gLAutoDrawable.getHeight());
        HWShadowmapsSimple.applyTransform(gL, this.cameraPerspective);
        gL.glMatrixMode(5888);
        this.render_scene(gL, this.cameraTransform, gLAutoDrawable, cameraParameters);
        gL.glActiveTexture(33985);
        this.light_image.disable();
        gL.glActiveTexture(33984);
        this.render_manipulators(gL, this.cameraTransform, gLAutoDrawable, cameraParameters);
        this.render_light_frustum(gL);
    }

    private void render_scene_from_camera_view_shadowed(GL gL, GLAutoDrawable gLAutoDrawable, CameraParameters cameraParameters) {
        gL.glPushMatrix();
        gL.glLoadIdentity();
        HWShadowmapsSimple.applyTransform(gL, this.cameraInverseTransform);
        HWShadowmapsSimple.applyTransform(gL, this.spotlightTransform);
        gL.glLightfv(16384, 4611, this.light_pos, 0);
        gL.glPopMatrix();
        gL.glActiveTexture(33985);
        gL.glPushMatrix();
        HWShadowmapsSimple.applyTransform(gL, this.cameraInverseTransform);
        this.eye_linear_texgen(gL);
        this.texgen(gL, true);
        gL.glPopMatrix();
        gL.glMatrixMode(5890);
        gL.glLoadIdentity();
        gL.glTranslatef(0.5f, 0.5f, 0.5f);
        gL.glScalef(0.5f, -0.5f, 0.5f);
        this.glu.gluPerspective((double)this.lightshaper_fovy, 1.0, (double)this.lightshaper_zNear, (double)this.lightshaper_zFar);
        HWShadowmapsSimple.applyTransform(gL, this.spotlightInverseTransform);
        gL.glMatrixMode(5888);
        this.light_image.bind();
        this.light_image.enable();
        gL.glTexEnvi(8960, 8704, 8448);
        gL.glActiveTexture(33986);
        gL.glPushMatrix();
        HWShadowmapsSimple.applyTransform(gL, this.cameraInverseTransform);
        this.eye_linear_texgen(gL);
        this.texgen(gL, true);
        gL.glPopMatrix();
        gL.glMatrixMode(5890);
        gL.glLoadIdentity();
        gL.glTranslatef(0.5f, 0.5f, ((Tweak)this.tweaks.get((int)0)).val);
        gL.glScalef(0.5f, 0.5f, ((Tweak)this.tweaks.get((int)1)).val);
        this.glu.gluPerspective((double)this.lightshaper_fovy, 1.0, (double)this.lightshaper_zNear, (double)this.lightshaper_zFar);
        HWShadowmapsSimple.applyTransform(gL, this.spotlightInverseTransform);
        gL.glMatrixMode(5888);
        gL.glBindTexture(3553, this.light_view_depth);
        gL.glEnable(3553);
        gL.glTexEnvi(8960, 8704, 8448);
        gL.glActiveTexture(33984);
        gL.glMatrixMode(5889);
        gL.glLoadIdentity();
        gL.glViewport(this.viewportX, this.viewportY, gLAutoDrawable.getWidth(), gLAutoDrawable.getHeight());
        HWShadowmapsSimple.applyTransform(gL, this.cameraPerspective);
        gL.glMatrixMode(5888);
        this.render_scene(gL, this.cameraTransform, gLAutoDrawable, cameraParameters);
        gL.glActiveTexture(33985);
        this.light_image.disable();
        gL.glActiveTexture(33986);
        gL.glDisable(3553);
        gL.glActiveTexture(33984);
        this.render_manipulators(gL, this.cameraTransform, gLAutoDrawable, cameraParameters);
        this.render_light_frustum(gL);
    }

    private void largest_square_power_of_two_viewport(GL gL, GLAutoDrawable gLAutoDrawable, int n, int n2) {
        float f = Math.min(gLAutoDrawable.getWidth(), gLAutoDrawable.getHeight());
        float f2 = (float)Math.log(f) / (float)Math.log(2.0);
        float f3 = (float)Math.floor(f2);
        int n3 = 1 << (int)f3;
        gL.glViewport(n, n2, n3, n3);
    }

    private void render_scene_from_light_view(GL gL, GLAutoDrawable gLAutoDrawable, int n, int n2) {
        gL.glPushMatrix();
        gL.glLoadIdentity();
        gL.glLightfv(16384, 4611, this.light_pos, 0);
        gL.glPopMatrix();
        gL.glActiveTexture(33985);
        gL.glPushMatrix();
        this.eye_linear_texgen(gL);
        this.texgen(gL, true);
        gL.glPopMatrix();
        gL.glMatrixMode(5890);
        gL.glLoadIdentity();
        gL.glTranslatef(0.5f, 0.5f, 0.5f);
        gL.glScalef(0.5f, 0.5f, 0.5f);
        this.glu.gluPerspective((double)this.lightshaper_fovy, 1.0, (double)this.lightshaper_zNear, (double)this.lightshaper_zFar);
        gL.glMatrixMode(5888);
        this.light_image.bind();
        this.light_image.enable();
        gL.glTexEnvi(8960, 8704, 8448);
        gL.glActiveTexture(33984);
        gL.glViewport(0, 0, 1024, 1024);
        gL.glMatrixMode(5889);
        gL.glLoadIdentity();
        this.glu.gluPerspective((double)this.lightshaper_fovy, 1.0, (double)this.lightshaper_zNear, (double)this.lightshaper_zFar);
        gL.glMatrixMode(5888);
        if (this.displayMode == 2) {
            this.largest_square_power_of_two_viewport(gL, gLAutoDrawable, n, n2);
        }
        this.render_scene(gL, this.spotlightTransform, null, null);
        gL.glActiveTexture(33985);
        this.light_image.disable();
        gL.glActiveTexture(33984);
    }

    private static void getRow(Mat4f mat4f, int n, float[] fArray) {
        fArray[0] = mat4f.get(n, 0);
        fArray[1] = mat4f.get(n, 1);
        fArray[2] = mat4f.get(n, 2);
        fArray[3] = mat4f.get(n, 3);
    }

    private static void applyTransform(GL gL, Mat4f mat4f) {
        float[] fArray = new float[16];
        mat4f.getColumnMajorData(fArray);
        gL.glMultMatrixf(fArray, 0);
    }

    private static Mat4f perspectiveInverse(float f, float f2, float f3, float f4) {
        float f5 = (float)Math.tan(Math.toRadians((double)f / 2.0));
        float f6 = f5 * f3;
        float f7 = f2 * f6;
        return HWShadowmapsSimple.frustumInverse(-f7, f7, -f6, f6, f3, f4);
    }

    private static Mat4f frustumInverse(float f, float f2, float f3, float f4, float f5, float f6) {
        Mat4f mat4f = new Mat4f();
        mat4f.makeIdent();
        mat4f.set(0, 0, (f2 - f) / (2.0f * f5));
        mat4f.set(0, 3, (f2 + f) / (2.0f * f5));
        mat4f.set(1, 1, (f4 - f3) / (2.0f * f5));
        mat4f.set(1, 3, (f4 + f3) / (2.0f * f5));
        mat4f.set(2, 2, 0.0f);
        mat4f.set(2, 3, -1.0f);
        mat4f.set(3, 2, -(f6 - f5) / (2.0f * f6 * f5));
        mat4f.set(3, 3, (f6 + f5) / (2.0f * f6 * f5));
        return mat4f;
    }

    private static void runExit() {
        new Thread(new Runnable(){

            public void run() {
                System.exit(0);
            }
        }).start();
    }

    class PbufferListener
    implements GLEventListener {
        PbufferListener() {
        }

        public void init(GLAutoDrawable gLAutoDrawable) {
            GL gL = gLAutoDrawable.getGL();
            gL.glEnable(2929);
            int[] nArray = new int[1];
            gL.glGetIntegerv(3414, nArray, 0);
            if (nArray[0] == 16) {
                HWShadowmapsSimple.this.depth_format = 33189;
            } else {
                HWShadowmapsSimple.this.depth_format = 33190;
            }
            HWShadowmapsSimple.this.light_view_depth = HWShadowmapsSimple.this.genTexture(gL);
            gL.glBindTexture(3553, HWShadowmapsSimple.this.light_view_depth);
            gL.glTexImage2D(3553, 0, HWShadowmapsSimple.this.depth_format, 1024, 1024, 0, 6402, 5125, null);
            HWShadowmapsSimple.this.set_light_view_texture_parameters(gL);
            HWShadowmapsSimple.this.fullyInitialized = true;
        }

        public void display(GLAutoDrawable gLAutoDrawable) {
            GL gL = gLAutoDrawable.getGL();
            gL.glClear(16640);
            gL.glPolygonOffset(((Tweak)((HWShadowmapsSimple)HWShadowmapsSimple.this).tweaks.get((int)2)).val, ((Tweak)((HWShadowmapsSimple)HWShadowmapsSimple.this).tweaks.get((int)3)).val);
            gL.glEnable(32823);
            HWShadowmapsSimple.this.render_scene_from_light_view(gL, gLAutoDrawable, 0, 0);
            gL.glDisable(32823);
            gL.glBindTexture(3553, HWShadowmapsSimple.this.light_view_depth);
            gL.glCopyTexSubImage2D(3553, 0, 0, 0, 0, 0, 1024, 1024);
        }

        public void reshape(GLAutoDrawable gLAutoDrawable, int n, int n2, int n3, int n4) {
        }

        public void displayChanged(GLAutoDrawable gLAutoDrawable, boolean bl, boolean bl2) {
        }
    }

    static class Tweak {
        String name;
        float val;
        float incr;

        Tweak(String string, float f, float f2) {
            this.name = string;
            this.val = f;
            this.incr = f2;
        }
    }
}

