/*
 * Decompiled with CFR 0.152.
 */
package demos.j2d;

import com.sun.opengl.util.Animator;
import com.sun.opengl.util.j2d.TextRenderer;
import com.sun.opengl.util.texture.Texture;
import com.sun.opengl.util.texture.TextureIO;
import demos.common.Demo;
import demos.util.FPSCounter;
import demos.util.SystemTime;
import demos.util.Time;
import gleem.linalg.Vec2f;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.DisplayMode;
import java.awt.Font;
import java.awt.GradientPaint;
import java.awt.Graphics2D;
import java.awt.GraphicsEnvironment;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.awt.font.FontRenderContext;
import java.awt.font.GlyphVector;
import java.awt.geom.Rectangle2D;
import java.awt.geom.RectangularShape;
import java.awt.image.BufferedImage;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Random;
import javax.media.opengl.GL;
import javax.media.opengl.GLAutoDrawable;
import javax.media.opengl.GLCanvas;
import javax.media.opengl.GLDrawable;
import javax.media.opengl.GLEventListener;
import javax.media.opengl.glu.GLU;
import javax.swing.JButton;
import javax.swing.JFrame;
import javax.swing.JPanel;

public class CustomText
extends Demo {
    private static final float INIT_ANG_VEL_MAG = 0.3f;
    private static final float INIT_VEL_MAG = 400.0f;
    private static final int DEFAULT_DROP_SHADOW_DIST = 20;
    private List textInfo = new ArrayList();
    private Time time;
    private Texture backgroundTexture;
    private TextRenderer renderer;
    private Random random = new Random();
    private GLU glu = new GLU();
    private int width;
    private int height;
    private int maxTextWidth;
    private FPSCounter fps;
    private static final Color DROP_SHADOW_COLOR = new Color(0.0f, 0.0f, 0.0f, 0.5f);

    public static void main(String[] stringArray) {
        JFrame jFrame = new JFrame("Custom Text");
        jFrame.getContentPane().setLayout(new BorderLayout());
        GLCanvas gLCanvas = new GLCanvas();
        CustomText customText = new CustomText();
        gLCanvas.addGLEventListener((GLEventListener)customText);
        jFrame.getContentPane().add((Component)gLCanvas, "Center");
        jFrame.getContentPane().add((Component)customText.buildGUI(), "North");
        DisplayMode displayMode = GraphicsEnvironment.getLocalGraphicsEnvironment().getDefaultScreenDevice().getDisplayMode();
        jFrame.setSize((int)(0.75f * (float)displayMode.getWidth()), (int)(0.75f * (float)displayMode.getHeight()));
        final Animator animator = new Animator((GLAutoDrawable)gLCanvas);
        jFrame.addWindowListener(new WindowAdapter(){

            public void windowClosing(WindowEvent windowEvent) {
                new Thread(new Runnable(this){
                    private final /* synthetic */ 1 this$0;
                    {
                        this.this$0 = var1_1;
                    }

                    public void run() {
                        1.access$000(this.this$0).stop();
                        System.exit(0);
                    }
                }).start();
            }

            static /* synthetic */ Animator access$000(1 var0) {
                return var0.animator;
            }
        });
        jFrame.show();
        animator.start();
    }

    public Container buildGUI() {
        JPanel jPanel = new JPanel();
        JButton jButton = new JButton("Less Text");
        jButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                CustomText.this.lessText();
            }
        });
        jPanel.add(jButton);
        jButton = new JButton("More Text");
        jButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                CustomText.this.moreText();
            }
        });
        jPanel.add(jButton);
        return jPanel;
    }

    public void moreText() {
        int n = (int)((float)this.textInfo.size() * 0.5f);
        if (n == 0) {
            n = 1;
        }
        for (int i = 0; i < n; ++i) {
            this.textInfo.add(this.randomTextInfo());
        }
    }

    public void lessText() {
        if (this.textInfo.size() == 1) {
            return;
        }
        int n = this.textInfo.size() / 3;
        if (n == 0) {
            n = 1;
        }
        for (int i = 0; i < n; ++i) {
            this.textInfo.remove(this.textInfo.size() - 1);
        }
    }

    public void init(GLAutoDrawable gLAutoDrawable) {
        BufferedImage bufferedImage = new BufferedImage(2, 2, 10);
        Graphics2D graphics2D = bufferedImage.createGraphics();
        graphics2D.setColor(new Color(0.3f, 0.3f, 0.3f));
        graphics2D.fillRect(0, 0, 2, 2);
        graphics2D.setColor(new Color(0.7f, 0.7f, 0.7f));
        graphics2D.fillRect(0, 0, 1, 1);
        graphics2D.fillRect(1, 1, 1, 1);
        graphics2D.dispose();
        this.backgroundTexture = TextureIO.newTexture((BufferedImage)bufferedImage, (boolean)false);
        this.backgroundTexture.bind();
        this.backgroundTexture.setTexParameteri(10241, 9728);
        this.backgroundTexture.setTexParameteri(10240, 9728);
        this.backgroundTexture.setTexParameteri(10242, 10497);
        this.backgroundTexture.setTexParameteri(10243, 10497);
        this.renderer = new TextRenderer(new Font("Serif", 0, 72), true, true, (TextRenderer.RenderDelegate)new CustomRenderDelegate(52.0f, 10, Color.BLUE, Color.CYAN));
        this.fps = new FPSCounter((GLDrawable)gLAutoDrawable, 36);
        this.width = gLAutoDrawable.getWidth();
        this.height = gLAutoDrawable.getWidth();
        this.maxTextWidth = (int)this.renderer.getBounds("Java 2D").getWidth();
        this.maxTextWidth = Math.max(this.maxTextWidth, (int)this.renderer.getBounds("OpenGL").getWidth());
        this.textInfo.clear();
        for (int i = 0; i < 100; ++i) {
            this.textInfo.add(this.randomTextInfo());
        }
        this.time = new SystemTime();
        ((SystemTime)this.time).rebase();
        GL gL = gLAutoDrawable.getGL();
        gL.glDisable(2929);
        gL.setSwapInterval(0);
    }

    public void display(GLAutoDrawable gLAutoDrawable) {
        TextInfo textInfo;
        this.time.update();
        float f = (float)this.time.deltaT();
        Vec2f vec2f = new Vec2f();
        GL gL = this.textInfo.iterator();
        while (gL.hasNext()) {
            textInfo = (TextInfo)gL.next();
            if (this.random.nextInt(1000) == 0) {
                textInfo.angularVelocity = 0.3f * (this.randomAngle() - 180.0f);
                textInfo.velocity = this.randomVelocityVec2f(400.0f, 400.0f);
            }
            textInfo.angle += textInfo.angularVelocity * f;
            vec2f.set(textInfo.velocity);
            vec2f.scale(f);
            textInfo.position.add(vec2f);
            if (textInfo.angle < 0.0f) {
                textInfo.angle += 360.0f;
            } else if (textInfo.angle > 360.0f) {
                textInfo.angle -= 360.0f;
            }
            if (textInfo.position.x() < (float)(-this.maxTextWidth)) {
                textInfo.position.setX(textInfo.position.x() + (float)gLAutoDrawable.getWidth() + (float)(2 * this.maxTextWidth));
            } else if (textInfo.position.x() > (float)(gLAutoDrawable.getWidth() + this.maxTextWidth)) {
                textInfo.position.setX(textInfo.position.x() - (float)gLAutoDrawable.getWidth() - (float)(2 * this.maxTextWidth));
            }
            if (textInfo.position.y() < (float)(-this.maxTextWidth)) {
                textInfo.position.setY(textInfo.position.y() + (float)gLAutoDrawable.getHeight() + (float)(2 * this.maxTextWidth));
                continue;
            }
            if (!(textInfo.position.y() > (float)(gLAutoDrawable.getHeight() + this.maxTextWidth))) continue;
            textInfo.position.setY(textInfo.position.y() - (float)gLAutoDrawable.getHeight() - (float)(2 * this.maxTextWidth));
        }
        gL = gLAutoDrawable.getGL();
        gL.glClear(16384);
        gL.glMatrixMode(5889);
        gL.glLoadIdentity();
        this.glu.gluOrtho2D(0.0, (double)gLAutoDrawable.getWidth(), 0.0, (double)gLAutoDrawable.getHeight());
        gL.glMatrixMode(5888);
        gL.glLoadIdentity();
        this.backgroundTexture.enable();
        this.backgroundTexture.bind();
        textInfo = this.backgroundTexture.getImageTexCoords();
        int n = gLAutoDrawable.getWidth();
        int n2 = gLAutoDrawable.getHeight();
        float f2 = (float)n / 100.0f;
        float f3 = (float)n2 / 100.0f;
        gL.glTexEnvi(8960, 8704, 7681);
        gL.glBegin(7);
        gL.glTexCoord2f(f2 * textInfo.left(), f3 * textInfo.bottom());
        gL.glVertex3f(0.0f, 0.0f, 0.0f);
        gL.glTexCoord2f(f2 * textInfo.right(), f3 * textInfo.bottom());
        gL.glVertex3f((float)n, 0.0f, 0.0f);
        gL.glTexCoord2f(f2 * textInfo.right(), f3 * textInfo.top());
        gL.glVertex3f((float)n, (float)n2, 0.0f);
        gL.glTexCoord2f(f2 * textInfo.left(), f3 * textInfo.top());
        gL.glVertex3f(0.0f, (float)n2, 0.0f);
        gL.glEnd();
        this.backgroundTexture.disable();
        this.renderer.beginRendering(gLAutoDrawable.getWidth(), gLAutoDrawable.getHeight());
        gL.glMatrixMode(5888);
        Iterator iterator = this.textInfo.iterator();
        while (iterator.hasNext()) {
            TextInfo textInfo2 = (TextInfo)iterator.next();
            gL.glLoadIdentity();
            gL.glTranslatef(textInfo2.position.x(), textInfo2.position.y(), 0.0f);
            gL.glRotatef(textInfo2.angle, 0.0f, 0.0f, 1.0f);
            this.renderer.draw(textInfo2.text, 0, 0);
            this.renderer.flush();
        }
        this.renderer.endRendering();
        this.fps.draw();
    }

    public void reshape(GLAutoDrawable gLAutoDrawable, int n, int n2, int n3, int n4) {
        this.width = n3;
        this.height = n4;
    }

    public void displayChanged(GLAutoDrawable gLAutoDrawable, boolean bl, boolean bl2) {
    }

    private TextInfo randomTextInfo() {
        TextInfo textInfo = new TextInfo();
        textInfo.text = this.randomString();
        textInfo.angle = this.randomAngle();
        textInfo.position = this.randomVec2f(this.width, this.height);
        textInfo.angularVelocity = 0.3f * (this.randomAngle() - 180.0f);
        textInfo.velocity = this.randomVelocityVec2f(400.0f, 400.0f);
        return textInfo;
    }

    private String randomString() {
        switch (this.random.nextInt(3)) {
            case 0: {
                return "OpenGL";
            }
            case 1: {
                return "Java 2D";
            }
        }
        return "Text";
    }

    private float randomAngle() {
        return 360.0f * this.random.nextFloat();
    }

    private Vec2f randomVec2f(float f, float f2) {
        return new Vec2f(f * this.random.nextFloat(), f2 * this.random.nextFloat());
    }

    private Vec2f randomVelocityVec2f(float f, float f2) {
        return new Vec2f(f * (this.random.nextFloat() - 0.5f), f2 * (this.random.nextFloat() - 0.5f));
    }

    class CustomRenderDelegate
    implements TextRenderer.RenderDelegate {
        private float gradientSize;
        private int dropShadowDepth;
        private Color color1;
        private Color color2;

        CustomRenderDelegate(float f, int n, Color color, Color color2) {
            this.gradientSize = f;
            this.dropShadowDepth = n;
            this.color1 = color;
            this.color2 = color2;
        }

        public boolean intensityOnly() {
            return false;
        }

        public Rectangle2D getBounds(CharSequence charSequence, Font font, FontRenderContext fontRenderContext) {
            return this.getBounds(((Object)charSequence).toString(), font, fontRenderContext);
        }

        public Rectangle2D getBounds(String string, Font font, FontRenderContext fontRenderContext) {
            return this.getBounds(font.createGlyphVector(fontRenderContext, string), fontRenderContext);
        }

        public Rectangle2D getBounds(GlyphVector glyphVector, FontRenderContext fontRenderContext) {
            Rectangle rectangle = glyphVector.getPixelBounds(fontRenderContext, 0.0f, 0.0f);
            return new Rectangle2D.Double(((RectangularShape)rectangle).getX(), ((RectangularShape)rectangle).getY(), ((RectangularShape)rectangle).getWidth() + (double)this.dropShadowDepth, ((RectangularShape)rectangle).getHeight() + (double)this.dropShadowDepth);
        }

        public void drawGlyphVector(Graphics2D graphics2D, GlyphVector glyphVector, int n, int n2) {
            graphics2D.setColor(DROP_SHADOW_COLOR);
            graphics2D.drawGlyphVector(glyphVector, n + this.dropShadowDepth, n2 + this.dropShadowDepth);
            graphics2D.setColor(Color.WHITE);
            graphics2D.setPaint(new GradientPaint(n, n2, this.color1, n, (float)n2 + this.gradientSize / 2.0f, this.color2, true));
            graphics2D.drawGlyphVector(glyphVector, n, n2);
        }

        public void draw(Graphics2D graphics2D, String string, int n, int n2) {
            graphics2D.setColor(DROP_SHADOW_COLOR);
            graphics2D.drawString(string, n + this.dropShadowDepth, n2 + this.dropShadowDepth);
            graphics2D.setColor(Color.WHITE);
            graphics2D.setPaint(new GradientPaint(n, n2, this.color1, n, (float)n2 + this.gradientSize / 2.0f, this.color2, true));
            graphics2D.drawString(string, n, n2);
        }
    }

    private static class TextInfo {
        float angularVelocity;
        Vec2f velocity;
        float angle;
        Vec2f position;
        String text;

        private TextInfo() {
        }
    }
}

