/*
 * Decompiled with CFR 0.152.
 */
package demos.j2d;

import com.sun.opengl.util.Animator;
import com.sun.opengl.util.j2d.Overlay;
import demos.gears.Gears;
import demos.util.SystemTime;
import demos.util.Time;
import gleem.linalg.Vec2f;
import java.awt.AlphaComposite;
import java.awt.Color;
import java.awt.Component;
import java.awt.Font;
import java.awt.Frame;
import java.awt.Graphics2D;
import java.awt.Rectangle;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.awt.font.FontRenderContext;
import java.awt.font.GlyphVector;
import java.text.DecimalFormat;
import javax.media.opengl.GL;
import javax.media.opengl.GLAutoDrawable;
import javax.media.opengl.GLCanvas;
import javax.media.opengl.GLCapabilities;
import javax.media.opengl.GLDrawable;
import javax.media.opengl.GLEventListener;

public class TestOverlay
implements GLEventListener {
    private Overlay overlay;
    private Time time;
    private Font font;
    private Color TRANSPARENT_BLACK = new Color(0.0f, 0.0f, 0.0f, 0.0f);
    private FontRenderContext frc;
    private GlyphVector gv;
    private Vec2f velocity = new Vec2f(100.0f, 150.0f);
    private Vec2f position;
    private Rectangle textBounds;
    private Rectangle lastTextBounds;
    private String TEST_STRING = "Java 2D Text";
    private long startTime;
    private int frameCount;
    private DecimalFormat format = new DecimalFormat("####.00");
    private Rectangle fpsBounds;

    public static void main(String[] stringArray) {
        Frame frame = new Frame("Java 2D Overlay Test");
        GLCapabilities gLCapabilities = new GLCapabilities();
        gLCapabilities.setAlphaBits(8);
        GLCanvas gLCanvas = new GLCanvas(gLCapabilities);
        gLCanvas.addGLEventListener((GLEventListener)new Gears());
        gLCanvas.addGLEventListener((GLEventListener)new TestOverlay());
        frame.add((Component)gLCanvas);
        frame.setSize(512, 512);
        final Animator animator = new Animator((GLAutoDrawable)gLCanvas);
        frame.addWindowListener(new WindowAdapter(){

            public void windowClosing(WindowEvent windowEvent) {
                new Thread(new Runnable(this){
                    private final /* synthetic */ 1 this$0;
                    {
                        this.this$0 = var1_1;
                    }

                    public void run() {
                        1.access$000(this.this$0).stop();
                        System.exit(0);
                    }
                }).start();
            }

            static /* synthetic */ Animator access$000(1 var0) {
                return var0.animator;
            }
        });
        frame.show();
        animator.start();
    }

    public void init(GLAutoDrawable gLAutoDrawable) {
        GL gL = gLAutoDrawable.getGL();
        gL.setSwapInterval(0);
        this.overlay = new Overlay((GLDrawable)gLAutoDrawable);
        this.time = new SystemTime();
        ((SystemTime)this.time).rebase();
        this.position = new Vec2f(0.0f, (float)(gLAutoDrawable.getHeight() / 2));
        this.font = new Font("SansSerif", 1, 36);
    }

    public void display(GLAutoDrawable gLAutoDrawable) {
        if (this.startTime == 0L) {
            this.startTime = System.currentTimeMillis();
        }
        Graphics2D graphics2D = this.overlay.createGraphics();
        if (++this.frameCount == 30) {
            long l = System.currentTimeMillis();
            float f = 30.0f / (float)(l - this.startTime) * 1000.0f;
            this.frameCount = 0;
            this.startTime = System.currentTimeMillis();
            FontRenderContext fontRenderContext = graphics2D.getFontRenderContext();
            String string = "FPS: " + this.format.format(f);
            GlyphVector glyphVector = this.font.createGlyphVector(fontRenderContext, this.TEST_STRING);
            this.fpsBounds = glyphVector.getPixelBounds(fontRenderContext, 0.0f, 0.0f);
            int n = gLAutoDrawable.getWidth() - this.fpsBounds.width - 20;
            int n2 = gLAutoDrawable.getHeight() - 20;
            graphics2D.setFont(this.font);
            graphics2D.setComposite(AlphaComposite.Src);
            graphics2D.setColor(this.TRANSPARENT_BLACK);
            graphics2D.fillRect(n + this.fpsBounds.x, n2 + this.fpsBounds.y, this.fpsBounds.width, this.fpsBounds.height);
            graphics2D.setColor(Color.WHITE);
            graphics2D.drawString(string, n, n2);
            this.overlay.markDirty(n + this.fpsBounds.x, n2 + this.fpsBounds.y, this.fpsBounds.width, this.fpsBounds.height);
        }
        this.time.update();
        graphics2D.setFont(this.font);
        graphics2D.setComposite(AlphaComposite.Src);
        if (this.overlay.contentsLost()) {
            this.frc = graphics2D.getFontRenderContext();
            this.gv = this.font.createGlyphVector(this.frc, this.TEST_STRING);
        }
        this.position = this.position.plus(this.velocity.times((float)this.time.deltaT()));
        this.textBounds = this.gv.getPixelBounds(this.frc, this.position.x(), this.position.y());
        if (this.textBounds.getMinX() < 0.0) {
            this.velocity.setX(Math.abs(this.velocity.x()));
        } else if (this.textBounds.getMaxX() > (double)gLAutoDrawable.getWidth()) {
            this.velocity.setX(-1.0f * Math.abs(this.velocity.x()));
        }
        if (this.textBounds.getMinY() < 0.0) {
            this.velocity.setY(Math.abs(this.velocity.y()));
        } else if (this.textBounds.getMaxY() > (double)gLAutoDrawable.getHeight()) {
            this.velocity.setY(-1.0f * Math.abs(this.velocity.y()));
        }
        if (this.lastTextBounds != null) {
            graphics2D.setColor(this.TRANSPARENT_BLACK);
            graphics2D.fillRect((int)this.lastTextBounds.getMinX(), (int)this.lastTextBounds.getMinY(), (int)(this.lastTextBounds.getWidth() + 1.0), (int)(this.lastTextBounds.getHeight() + 1.0));
        } else if (this.overlay.contentsLost()) {
            graphics2D.setColor(this.TRANSPARENT_BLACK);
            graphics2D.fillRect(0, 0, gLAutoDrawable.getWidth(), gLAutoDrawable.getHeight());
        }
        graphics2D.setColor(Color.WHITE);
        graphics2D.drawString(this.TEST_STRING, this.position.x(), this.position.y());
        Rectangle rectangle = new Rectangle(this.textBounds);
        if (this.lastTextBounds != null) {
            rectangle.add(this.lastTextBounds);
        }
        this.overlay.markDirty(rectangle.x, rectangle.y, rectangle.width + 10, rectangle.height + 10);
        this.lastTextBounds = this.textBounds;
        this.overlay.drawAll();
        graphics2D.dispose();
    }

    public void reshape(GLAutoDrawable gLAutoDrawable, int n, int n2, int n3, int n4) {
    }

    public void displayChanged(GLAutoDrawable gLAutoDrawable, boolean bl, boolean bl2) {
    }
}

