/*
 * Decompiled with CFR 0.152.
 */
package demos.j2d;

import com.sun.opengl.util.Animator;
import com.sun.opengl.util.j2d.TextRenderer;
import demos.gears.Gears;
import demos.util.FPSCounter;
import demos.util.SystemTime;
import demos.util.Time;
import gleem.linalg.Vec2f;
import java.awt.Component;
import java.awt.Font;
import java.awt.Frame;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.awt.geom.Rectangle2D;
import javax.media.opengl.GL;
import javax.media.opengl.GLAutoDrawable;
import javax.media.opengl.GLCanvas;
import javax.media.opengl.GLCapabilities;
import javax.media.opengl.GLDrawable;
import javax.media.opengl.GLEventListener;

public class TestTextRenderer
implements GLEventListener {
    private TextRenderer renderer;
    private Time time;
    private Font font;
    private Vec2f velocity = new Vec2f(100.0f, 150.0f);
    private Vec2f position;
    private String TEST_STRING = "Java 2D Text";
    private int textWidth;
    private int textHeight;
    private FPSCounter fps;

    public static void main(String[] stringArray) {
        Frame frame = new Frame("Text Renderer Test");
        GLCapabilities gLCapabilities = new GLCapabilities();
        gLCapabilities.setAlphaBits(8);
        GLCanvas gLCanvas = new GLCanvas(gLCapabilities);
        gLCanvas.addGLEventListener((GLEventListener)new Gears());
        gLCanvas.addGLEventListener((GLEventListener)new TestTextRenderer());
        frame.add((Component)gLCanvas);
        frame.setSize(512, 512);
        final Animator animator = new Animator((GLAutoDrawable)gLCanvas);
        frame.addWindowListener(new WindowAdapter(){

            public void windowClosing(WindowEvent windowEvent) {
                new Thread(new Runnable(this){
                    private final /* synthetic */ 1 this$0;
                    {
                        this.this$0 = var1_1;
                    }

                    public void run() {
                        1.access$000(this.this$0).stop();
                        System.exit(0);
                    }
                }).start();
            }

            static /* synthetic */ Animator access$000(1 var0) {
                return var0.animator;
            }
        });
        frame.show();
        animator.start();
    }

    public void init(GLAutoDrawable gLAutoDrawable) {
        GL gL = gLAutoDrawable.getGL();
        gL.setSwapInterval(0);
        this.renderer = new TextRenderer(new Font("SansSerif", 1, 36));
        this.time = new SystemTime();
        ((SystemTime)this.time).rebase();
        this.position = new Vec2f(0.0f, (float)(gLAutoDrawable.getHeight() / 2));
        Rectangle2D rectangle2D = this.renderer.getBounds(this.TEST_STRING);
        this.textWidth = (int)rectangle2D.getWidth();
        this.textHeight = (int)rectangle2D.getHeight();
        this.fps = new FPSCounter((GLDrawable)gLAutoDrawable, 36);
    }

    public void display(GLAutoDrawable gLAutoDrawable) {
        this.time.update();
        this.position = this.position.plus(this.velocity.times((float)this.time.deltaT()));
        if (this.position.x() < 0.0f) {
            this.velocity.setX(Math.abs(this.velocity.x()));
        } else if (this.position.x() + (float)this.textWidth > (float)gLAutoDrawable.getWidth()) {
            this.velocity.setX(-1.0f * Math.abs(this.velocity.x()));
        }
        if (this.position.y() < 0.0f) {
            this.velocity.setY(Math.abs(this.velocity.y()));
        } else if (this.position.y() + (float)this.textHeight > (float)gLAutoDrawable.getHeight()) {
            this.velocity.setY(-1.0f * Math.abs(this.velocity.y()));
        }
        GL gL = gLAutoDrawable.getGL();
        this.renderer.beginRendering(gLAutoDrawable.getWidth(), gLAutoDrawable.getHeight());
        this.renderer.draw(this.TEST_STRING, (int)this.position.x(), (int)this.position.y());
        this.fps.draw();
        this.renderer.endRendering();
    }

    public void reshape(GLAutoDrawable gLAutoDrawable, int n, int n2, int n3, int n4) {
    }

    public void displayChanged(GLAutoDrawable gLAutoDrawable, boolean bl, boolean bl2) {
    }
}

