/*
 * Decompiled with CFR 0.152.
 */
package demos.j2d;

import com.sun.opengl.util.Animator;
import com.sun.opengl.util.j2d.TextRenderer;
import demos.common.Demo;
import demos.util.FPSCounter;
import demos.util.SystemTime;
import demos.util.Time;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Font;
import java.awt.Frame;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.awt.geom.Rectangle2D;
import javax.media.opengl.GL;
import javax.media.opengl.GLAutoDrawable;
import javax.media.opengl.GLCanvas;
import javax.media.opengl.GLDrawable;
import javax.media.opengl.GLEventListener;
import javax.media.opengl.glu.GLU;

public class TextCube
extends Demo {
    private float xAng;
    private float yAng;
    private GLU glu = new GLU();
    private Time time;
    private TextRenderer renderer;
    private FPSCounter fps;
    private float textScaleFactor;

    public static void main(String[] stringArray) {
        Frame frame = new Frame("Text Cube");
        frame.setLayout(new BorderLayout());
        GLCanvas gLCanvas = new GLCanvas();
        TextCube textCube = new TextCube();
        gLCanvas.addGLEventListener((GLEventListener)textCube);
        frame.add((Component)gLCanvas, "Center");
        frame.setSize(512, 512);
        final Animator animator = new Animator((GLAutoDrawable)gLCanvas);
        frame.addWindowListener(new WindowAdapter(){

            public void windowClosing(WindowEvent windowEvent) {
                new Thread(new Runnable(this){
                    private final /* synthetic */ 1 this$0;
                    {
                        this.this$0 = var1_1;
                    }

                    public void run() {
                        1.access$000(this.this$0).stop();
                        System.exit(0);
                    }
                }).start();
            }

            static /* synthetic */ Animator access$000(1 var0) {
                return var0.animator;
            }
        });
        frame.show();
        animator.start();
    }

    public void init(GLAutoDrawable gLAutoDrawable) {
        this.renderer = new TextRenderer(new Font("SansSerif", 0, 72));
        GL gL = gLAutoDrawable.getGL();
        gL.glEnable(2929);
        Rectangle2D rectangle2D = this.renderer.getBounds("Bottom");
        float f = (float)rectangle2D.getWidth();
        float f2 = (float)rectangle2D.getHeight();
        this.textScaleFactor = 1.0f / (f * 1.1f);
        this.fps = new FPSCounter((GLDrawable)gLAutoDrawable, 36);
        this.time = new SystemTime();
        ((SystemTime)this.time).rebase();
        gL.setSwapInterval(0);
    }

    public void display(GLAutoDrawable gLAutoDrawable) {
        GL gL = gLAutoDrawable.getGL();
        gL.glClear(16640);
        gL.glMatrixMode(5888);
        gL.glLoadIdentity();
        this.glu.gluLookAt(0.0, 0.0, 10.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0);
        gL.glRotatef(this.xAng, 1.0f, 0.0f, 0.0f);
        gL.glRotatef(this.yAng, 0.0f, 1.0f, 0.0f);
        gL.glPushMatrix();
        gL.glRotatef(-90.0f, 1.0f, 0.0f, 0.0f);
        this.drawFace(gL, 1.0f, 0.2f, 0.2f, 0.8f, "Top");
        gL.glPopMatrix();
        this.drawFace(gL, 1.0f, 0.8f, 0.2f, 0.2f, "Front");
        gL.glPushMatrix();
        gL.glRotatef(90.0f, 0.0f, 1.0f, 0.0f);
        this.drawFace(gL, 1.0f, 0.2f, 0.8f, 0.2f, "Right");
        gL.glRotatef(90.0f, 0.0f, 1.0f, 0.0f);
        this.drawFace(gL, 1.0f, 0.8f, 0.8f, 0.2f, "Back");
        gL.glRotatef(90.0f, 0.0f, 1.0f, 0.0f);
        this.drawFace(gL, 1.0f, 0.2f, 0.8f, 0.8f, "Left");
        gL.glPopMatrix();
        gL.glPushMatrix();
        gL.glRotatef(90.0f, 1.0f, 0.0f, 0.0f);
        this.drawFace(gL, 1.0f, 0.8f, 0.2f, 0.8f, "Bottom");
        gL.glPopMatrix();
        this.fps.draw();
        this.time.update();
        this.xAng += 200.0f * (float)this.time.deltaT();
        this.yAng += 150.0f * (float)this.time.deltaT();
    }

    public void reshape(GLAutoDrawable gLAutoDrawable, int n, int n2, int n3, int n4) {
        GL gL = gLAutoDrawable.getGL();
        gL.glMatrixMode(5889);
        gL.glLoadIdentity();
        this.glu.gluPerspective(15.0, (double)((float)n3 / (float)n4), 5.0, 15.0);
    }

    public void displayChanged(GLAutoDrawable gLAutoDrawable, boolean bl, boolean bl2) {
    }

    private void drawFace(GL gL, float f, float f2, float f3, float f4, String string) {
        float f5 = f / 2.0f;
        gL.glColor3f(f2, f3, f4);
        gL.glBegin(7);
        gL.glVertex3f(-f5, -f5, f5);
        gL.glVertex3f(f5, -f5, f5);
        gL.glVertex3f(f5, f5, f5);
        gL.glVertex3f(-f5, f5, f5);
        gL.glEnd();
        this.renderer.begin3DRendering();
        gL.glDisable(2929);
        gL.glEnable(2884);
        Rectangle2D rectangle2D = this.renderer.getBounds(string);
        float f6 = (float)rectangle2D.getWidth();
        float f7 = (float)rectangle2D.getHeight();
        this.renderer.draw3D(string, f6 / -2.0f * this.textScaleFactor, f7 / -2.0f * this.textScaleFactor, f5, this.textScaleFactor);
        this.renderer.end3DRendering();
    }
}

