/*
 * Decompiled with CFR 0.152.
 */
package demos.j2d;

import com.sun.opengl.util.Animator;
import com.sun.opengl.util.j2d.TextRenderer;
import demos.common.Demo;
import demos.util.SystemTime;
import demos.util.Time;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Font;
import java.awt.Frame;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.awt.font.FontRenderContext;
import java.awt.font.LineBreakMeasurer;
import java.awt.font.TextAttribute;
import java.awt.geom.Rectangle2D;
import java.text.AttributedString;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import javax.media.opengl.GL;
import javax.media.opengl.GLAutoDrawable;
import javax.media.opengl.GLCanvas;
import javax.media.opengl.GLEventListener;

public class TextFlow
extends Demo {
    private List lines = new ArrayList();
    private Time time;
    private TextRenderer renderer;
    private int curParagraph;
    private float x = 30.0f;
    private float y;
    private float velocity = 100.0f;
    private int lineSpacing;
    private int EXTRA_LINE_SPACING = 5;
    private static final String[] text = new String[]{"Lorem ipsum dolor sit amet, consectetuer adipiscing elit. Nulla in mi ut augue laoreet gravida. Quisque sodales vehicula ligula. Donec posuere. Morbi aliquet, odio vitae tempus mattis, odio dolor vestibulum leo, congue laoreet risus felis vitae dolor. Nulla arcu. Morbi non quam. Vestibulum pretium dolor fermentum erat. Proin dictum volutpat nibh. Morbi egestas mauris a diam. Vestibulum mauris eros, porttitor at, fermentum a, varius eu, mauris. Cras rutrum felis ut diam. Aenean porttitor risus a nunc. Aliquam et ante eu dolor pretium adipiscing. Sed fermentum, eros in dapibus lacinia, augue nunc fermentum tellus, eu egestas justo elit at mauris. Sed leo nisl, fermentum in, pretium vitae, tincidunt at, lacus. Curabitur non diam.", "Etiam varius sagittis lorem. Vivamus iaculis condimentum tortor. Nunc sollicitudin scelerisque dolor. Nunc condimentum fringilla nisl. Fusce purus mauris, blandit eu, lacinia eget, vestibulum nec, massa. Nulla vitae libero. Suspendisse potenti. Aliquam iaculis, lorem eu adipiscing tempor, ipsum dui aliquam sem, eu vehicula leo leo eu ipsum. Pellentesque faucibus. Nullam porttitor ligula eget nibh. Cras elementum mi ac libero. Praesent pellentesque pede vitae quam. Sed nec arcu id ante cursus mollis. Suspendisse quis ipsum. Maecenas feugiat interdum neque. Nullam dui diam, convallis at, condimentum vitae, mattis vitae, metus. Integer sollicitudin, diam id lacinia posuere, quam velit fringilla dolor, eu semper sapien felis ac elit.", "Ut a magna vitae lectus euismod hendrerit. Quisque varius consectetuer sapien. Suspendisse ligula. Nullam feugiat venenatis mauris. In consequat lorem at neque. Pellentesque libero. In eget lectus in velit auctor facilisis. Donec nec metus. Aliquam facilisis eros vel dui. Integer a diam. Donec interdum, eros faucibus blandit venenatis, ante ante ornare enim, a gravida ante lectus id metus. Ut sem.", "Duis consectetuer leo quis elit. Suspendisse pretium nunc ac dolor. Quisque eleifend fringilla nisl. Suspendisse potenti. Duis vel ipsum at enim tincidunt consectetuer. Aliquam tempor justo nec metus. Nunc ac velit id nibh consequat vulputate. Cras vel dolor eu massa lacinia volutpat. Curabitur nibh nisi, auctor et, tincidunt eget, molestie vel, neque. Sed semper viverra neque. Nullam rhoncus hendrerit libero. Nulla adipiscing. Fusce pede nibh, lacinia a, malesuada a, dictum nec, pede. Etiam ut lorem. Donec quis massa vitae est pharetra mattis.", "Nullam dui. Morbi nulla quam, imperdiet iaculis, consectetuer a, porttitor eu, sem. Donec id ipsum vitae nisi viverra porta. In hac habitasse platea dictumst. In ligula libero, dapibus eleifend, eleifend vel, accumsan sit amet, felis. Morbi tortor. Donec mattis ultricies arcu. Ut eget leo. Sed vel quam at ipsum sodales semper. Curabitur tincidunt quam id odio. Quisque porta, magna vel nonummy pulvinar, ligula tellus fringilla tellus, ut pharetra turpis velit ac eros. Cras eu enim vel mi suscipit malesuada. Phasellus ut orci. Aenean vitae turpis vitae lectus malesuada aliquet."};

    public static void main(String[] stringArray) {
        Frame frame = new Frame("Text Flow");
        frame.setLayout(new BorderLayout());
        GLCanvas gLCanvas = new GLCanvas();
        TextFlow textFlow = new TextFlow();
        gLCanvas.addGLEventListener((GLEventListener)textFlow);
        frame.add((Component)gLCanvas, "Center");
        frame.setSize(512, 512);
        final Animator animator = new Animator((GLAutoDrawable)gLCanvas);
        frame.addWindowListener(new WindowAdapter(){

            public void windowClosing(WindowEvent windowEvent) {
                new Thread(new Runnable(this){
                    private final /* synthetic */ 1 this$0;
                    {
                        this.this$0 = var1_1;
                    }

                    public void run() {
                        1.access$000(this.this$0).stop();
                        System.exit(0);
                    }
                }).start();
            }

            static /* synthetic */ Animator access$000(1 var0) {
                return var0.animator;
            }
        });
        frame.show();
        animator.start();
    }

    private void reflow(float f) {
        this.lines.clear();
        this.lineSpacing = 0;
        int n = 0;
        FontRenderContext fontRenderContext = this.renderer.getFontRenderContext();
        for (int i = 0; i < text.length; ++i) {
            String string = text[i];
            HashMap<TextAttribute, Font> hashMap = new HashMap<TextAttribute, Font>();
            hashMap.put(TextAttribute.FONT, this.renderer.getFont());
            AttributedString attributedString = new AttributedString(string, hashMap);
            LineBreakMeasurer lineBreakMeasurer = new LineBreakMeasurer(attributedString.getIterator(), fontRenderContext);
            int n2 = 0;
            while (lineBreakMeasurer.getPosition() < string.length()) {
                int n3 = lineBreakMeasurer.nextOffset(f);
                String string2 = string.substring(n2, n3);
                Rectangle2D rectangle2D = this.renderer.getBounds(string2);
                this.lines.add(string2);
                this.lineSpacing += (int)rectangle2D.getHeight();
                ++n;
                n2 = n3;
                lineBreakMeasurer.setPosition(n2);
            }
            this.lines.add(null);
        }
        this.lineSpacing = (int)((float)this.lineSpacing / (float)n) + this.EXTRA_LINE_SPACING;
    }

    public void init(GLAutoDrawable gLAutoDrawable) {
        this.renderer = new TextRenderer(new Font("SansSerif", 0, 36));
        this.time = new SystemTime();
        ((SystemTime)this.time).rebase();
    }

    public void display(GLAutoDrawable gLAutoDrawable) {
        this.time.update();
        GL gL = gLAutoDrawable.getGL();
        gL.glClear(16384);
        float f = (float)this.time.deltaT();
        this.y += this.velocity * f;
        int n = 0;
        float f2 = this.y;
        this.renderer.beginRendering(gLAutoDrawable.getWidth(), gLAutoDrawable.getHeight());
        boolean bl = false;
        for (int i = 0; i < this.lines.size(); ++i) {
            String string = (String)this.lines.get(i);
            if (string == null) {
                if (++n < this.curParagraph) continue;
                if (n > this.curParagraph && f2 > (float)gLAutoDrawable.getHeight()) {
                    ++this.curParagraph;
                    this.y = f2;
                }
                f2 -= (float)(2 * this.lineSpacing);
                continue;
            }
            if (n < this.curParagraph) continue;
            if ((f2 -= (float)this.lineSpacing) < (float)(gLAutoDrawable.getHeight() + this.lineSpacing)) {
                this.renderer.draw(string, (int)this.x, (int)f2);
                bl = true;
            }
            if (f2 < 0.0f) break;
        }
        this.renderer.endRendering();
        if (!bl) {
            this.curParagraph = 0;
            this.y = 0.0f;
        }
    }

    public void reshape(GLAutoDrawable gLAutoDrawable, int n, int n2, int n3, int n4) {
        this.reflow(Math.max(100, n3 - 60));
    }

    public void displayChanged(GLAutoDrawable gLAutoDrawable, boolean bl, boolean bl2) {
    }
}

