/*
 * Decompiled with CFR 0.152.
 */
package demos.misc;

import com.sun.opengl.util.Animator;
import com.sun.opengl.util.BufferUtil;
import java.awt.Component;
import java.awt.Frame;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.nio.IntBuffer;
import javax.media.opengl.GL;
import javax.media.opengl.GLAutoDrawable;
import javax.media.opengl.GLCanvas;
import javax.media.opengl.GLCapabilities;
import javax.media.opengl.GLDrawableFactory;
import javax.media.opengl.GLEventListener;
import javax.media.opengl.glu.GLU;

public class Picking {
    public static void main(String[] stringArray) {
        new Picking();
    }

    Picking() {
        Frame frame = new Frame("Picking Example");
        GLDrawableFactory gLDrawableFactory = GLDrawableFactory.getFactory();
        GLCapabilities gLCapabilities = new GLCapabilities();
        GLCanvas gLCanvas = new GLCanvas(gLCapabilities);
        gLCanvas.addGLEventListener((GLEventListener)new Renderer());
        frame.add((Component)gLCanvas);
        frame.setSize(400, 400);
        final Animator animator = new Animator((GLAutoDrawable)gLCanvas);
        frame.addWindowListener(new WindowAdapter(){

            public void windowClosing(WindowEvent windowEvent) {
                animator.stop();
                System.exit(0);
            }
        });
        frame.show();
        animator.start();
    }

    static class Renderer
    implements GLEventListener,
    MouseListener,
    MouseMotionListener {
        static final int NOTHING = 0;
        static final int UPDATE = 1;
        static final int SELECT = 2;
        int cmd = 1;
        int mouse_x;
        int mouse_y;
        private GLU glu = new GLU();
        private GLAutoDrawable gldrawable;

        Renderer() {
        }

        public void init(GLAutoDrawable gLAutoDrawable) {
            GL gL = gLAutoDrawable.getGL();
            this.gldrawable = gLAutoDrawable;
            gL.glEnable(2884);
            gL.glEnable(2929);
            gL.glEnable(2977);
            gL.glClearColor(0.0f, 0.0f, 0.0f, 0.0f);
            gLAutoDrawable.addMouseListener((MouseListener)this);
            gLAutoDrawable.addMouseMotionListener((MouseMotionListener)this);
        }

        public void reshape(GLAutoDrawable gLAutoDrawable, int n, int n2, int n3, int n4) {
            GL gL = gLAutoDrawable.getGL();
            float f = (float)n4 / (float)n3;
            gL.glViewport(0, 0, n3, n4);
            gL.glMatrixMode(5889);
            gL.glLoadIdentity();
            this.glu.gluOrtho2D(0.0, 1.0, 0.0, 1.0);
        }

        public void display(GLAutoDrawable gLAutoDrawable) {
            GL gL = gLAutoDrawable.getGL();
            switch (this.cmd) {
                case 1: {
                    this.drawScene(gL);
                    break;
                }
                case 2: {
                    int n = 512;
                    double d = this.mouse_x;
                    double d2 = this.mouse_y;
                    int[] nArray = new int[4];
                    IntBuffer intBuffer = BufferUtil.newIntBuffer((int)n);
                    int n2 = 0;
                    gL.glGetIntegerv(2978, nArray, 0);
                    gL.glSelectBuffer(n, intBuffer);
                    gL.glRenderMode(7170);
                    gL.glInitNames();
                    gL.glMatrixMode(5889);
                    gL.glPushMatrix();
                    gL.glLoadIdentity();
                    this.glu.gluPickMatrix(d, (double)nArray[3] - d2, 5.0, 5.0, nArray, 0);
                    this.glu.gluOrtho2D(0.0, 1.0, 0.0, 1.0);
                    this.drawScene(gL);
                    gL.glMatrixMode(5889);
                    gL.glPopMatrix();
                    gL.glFlush();
                    n2 = gL.glRenderMode(7168);
                    this.processHits(n2, intBuffer);
                    this.cmd = 1;
                }
            }
        }

        public void processHits(int n, IntBuffer intBuffer) {
            System.out.println("---------------------------------");
            System.out.println(" HITS: " + n);
            int n2 = 0;
            for (int i = 0; i < n; ++i) {
                System.out.println("- - - - - - - - - - - -");
                System.out.println(" hit: " + (i + 1));
                int n3 = intBuffer.get(n2);
                float f = (float)intBuffer.get(++n2) / 2.1474836E9f;
                float f2 = (float)intBuffer.get(++n2) / 2.1474836E9f;
                ++n2;
                System.out.println(" number of names: " + n3);
                System.out.println(" z1: " + f);
                System.out.println(" z2: " + f2);
                System.out.println(" names: ");
                for (int j = 0; j < n3; ++j) {
                    System.out.print("       " + intBuffer.get(n2));
                    if (j == n3 - 1) {
                        System.out.println("<-");
                    } else {
                        System.out.println();
                    }
                    ++n2;
                }
                System.out.println("- - - - - - - - - - - -");
            }
            System.out.println("---------------------------------");
        }

        public int viewPortWidth(GL gL) {
            int[] nArray = new int[4];
            gL.glGetIntegerv(2978, nArray, 0);
            return nArray[2];
        }

        public int viewPortHeight(GL gL) {
            int[] nArray = new int[4];
            gL.glGetIntegerv(2978, nArray, 0);
            return nArray[3];
        }

        public void drawScene(GL gL) {
            gL.glClear(16640);
            float[] fArray = new float[]{1.0f, 0.0f, 0.0f, 1.0f};
            float[] fArray2 = new float[]{0.0f, 1.0f, 0.0f, 1.0f};
            float[] fArray3 = new float[]{0.0f, 0.0f, 1.0f, 1.0f};
            GLRectangleEntity gLRectangleEntity = new GLRectangleEntity(gL, this.glu);
            gLRectangleEntity.x = 0.15f;
            gLRectangleEntity.y = 0.25f;
            gLRectangleEntity.z = 0.75f;
            gLRectangleEntity.w = 0.4f;
            gLRectangleEntity.h = 0.4f;
            gLRectangleEntity.c = fArray;
            gLRectangleEntity.id = 10;
            gLRectangleEntity.draw();
            GLRectangleEntity gLRectangleEntity2 = new GLRectangleEntity(gL, this.glu);
            gLRectangleEntity2.x = 0.35f;
            gLRectangleEntity2.y = 0.45f;
            gLRectangleEntity2.z = 0.5f;
            gLRectangleEntity2.w = 0.4f;
            gLRectangleEntity2.h = 0.4f;
            gLRectangleEntity2.c = fArray2;
            gLRectangleEntity2.id = 20;
            gLRectangleEntity2.draw();
            GLRectangleEntity gLRectangleEntity3 = new GLRectangleEntity(gL, this.glu);
            gLRectangleEntity3.x = 0.45f;
            gLRectangleEntity3.y = 0.15f;
            gLRectangleEntity3.z = 0.25f;
            gLRectangleEntity3.w = 0.4f;
            gLRectangleEntity3.h = 0.4f;
            gLRectangleEntity3.c = fArray3;
            gLRectangleEntity3.id = 30;
            gLRectangleEntity3.draw();
            gL.glFlush();
        }

        public void displayChanged(GLAutoDrawable gLAutoDrawable, boolean bl, boolean bl2) {
        }

        public void mousePressed(MouseEvent mouseEvent) {
            this.cmd = 2;
            this.mouse_x = mouseEvent.getX();
            this.mouse_y = mouseEvent.getY();
        }

        public void mouseEntered(MouseEvent mouseEvent) {
        }

        public void mouseExited(MouseEvent mouseEvent) {
        }

        public void mouseReleased(MouseEvent mouseEvent) {
        }

        public void mouseClicked(MouseEvent mouseEvent) {
        }

        public void mouseDragged(MouseEvent mouseEvent) {
        }

        public void mouseMoved(MouseEvent mouseEvent) {
        }

        public class GLRectangleEntity
        extends GLEntity {
            float w;
            float h;

            public GLRectangleEntity(GL gL, GLU gLU) {
                super(gL, gLU);
                this.w = 0.1f;
                this.h = 0.1f;
            }

            public void _draw() {
                if (this.outline) {
                    this.gl.glPolygonMode(1028, 6913);
                } else {
                    this.gl.glPolygonMode(1028, 6914);
                }
                this.gl.glColor4fv(this.c, 0);
                this.gl.glBegin(9);
                this.gl.glVertex3f(this.x, this.y, this.z);
                this.gl.glVertex3f(this.x + this.w, this.y, this.z);
                this.gl.glVertex3f(this.x + this.w, this.y + this.h, this.z);
                this.gl.glVertex3f(this.x, this.y + this.h, this.z);
                this.gl.glEnd();
            }
        }

        public abstract class GLEntity {
            float x;
            float y;
            float z;
            float[] c;
            int id = 0;
            boolean outline = false;
            GL gl;
            GLU glu;

            public GLEntity(GL gL, GLU gLU) {
                this.gl = gL;
                this.glu = gLU;
            }

            public void draw() {
                this.gl.glPushName(this.id);
                this._draw();
            }

            public abstract void _draw();
        }
    }
}

