/*
 * Decompiled with CFR 0.152.
 */
package demos.misc;

import com.sun.opengl.util.FileUtil;
import com.sun.opengl.util.ImageUtil;
import com.sun.opengl.util.TGAWriter;
import com.sun.opengl.util.TileRenderer;
import demos.gears.Gears;
import java.awt.image.BufferedImage;
import java.awt.image.DataBufferByte;
import java.awt.image.RenderedImage;
import java.io.File;
import java.io.IOException;
import java.nio.Buffer;
import java.nio.ByteBuffer;
import javax.imageio.ImageIO;
import javax.media.opengl.GL;
import javax.media.opengl.GLCapabilities;
import javax.media.opengl.GLContext;
import javax.media.opengl.GLDrawableFactory;
import javax.media.opengl.GLPbuffer;

public class TiledRendering {
    public static void main(String[] stringArray) throws IOException {
        if (stringArray.length != 1) {
            System.out.println("Usage: java TiledRendering [output file name]");
            System.out.println("Writes output (a large version of the Gears demo) to");
            System.out.println("the specified file, using either ImageIO or the fast TGA writer");
            System.out.println("depending on the file extension.");
            System.exit(1);
        }
        String string = stringArray[0];
        File file = new File(string);
        if (!GLDrawableFactory.getFactory().canCreateGLPbuffer()) {
            System.out.println("Demo requires pbuffer support");
            System.exit(1);
        }
        GLCapabilities gLCapabilities = new GLCapabilities();
        gLCapabilities.setDoubleBuffered(false);
        GLPbuffer gLPbuffer = GLDrawableFactory.getFactory().createGLPbuffer(gLCapabilities, null, 256, 256, null);
        int n = 256;
        int n2 = 256;
        int n3 = n * 16;
        int n4 = n2 * 12;
        TGAWriter tGAWriter = null;
        BufferedImage bufferedImage = null;
        ByteBuffer byteBuffer = null;
        if (string.endsWith(".tga")) {
            tGAWriter = new TGAWriter();
            tGAWriter.open(file, n3, n4, false);
            byteBuffer = tGAWriter.getImageData();
        } else {
            bufferedImage = new BufferedImage(n3, n4, 5);
            byteBuffer = ByteBuffer.wrap(((DataBufferByte)bufferedImage.getRaster().getDataBuffer()).getData());
        }
        TileRenderer tileRenderer = new TileRenderer();
        tileRenderer.setTileSize(n, n2, 0);
        tileRenderer.setImageSize(n3, n4);
        tileRenderer.setImageBuffer(32992, 5121, (Buffer)byteBuffer);
        tileRenderer.trPerspective(20.0, (double)((float)n3 / (float)n4), 5.0, 60.0);
        GLContext gLContext = gLPbuffer.getContext();
        if (gLContext.makeCurrent() == 0) {
            System.out.println("Error making pbuffer's context current");
            System.exit(1);
        }
        GL gL = gLPbuffer.getGL();
        gL.glMatrixMode(5888);
        gL.glLoadIdentity();
        gL.glTranslatef(0.0f, 0.0f, -40.0f);
        do {
            tileRenderer.beginTile(gL);
            TiledRendering.drawGears(gL);
        } while (tileRenderer.endTile(gL));
        gLContext.release();
        if (tGAWriter != null) {
            tGAWriter.close();
        } else {
            ImageUtil.flipImageVertically((BufferedImage)bufferedImage);
            if (!ImageIO.write((RenderedImage)bufferedImage, FileUtil.getFileSuffix((File)file), file)) {
                System.err.println("Error writing file using ImageIO (unsupported file format?)");
            }
        }
    }

    private static void drawGears(GL gL) {
        float f = 20.0f;
        float f2 = 30.0f;
        float f3 = 0.0f;
        float f4 = 0.0f;
        float[] fArray = new float[]{5.0f, 5.0f, 10.0f, 0.0f};
        float[] fArray2 = new float[]{0.8f, 0.1f, 0.0f, 1.0f};
        float[] fArray3 = new float[]{0.0f, 0.8f, 0.2f, 1.0f};
        float[] fArray4 = new float[]{0.2f, 0.2f, 1.0f, 1.0f};
        gL.glClear(16640);
        gL.glLightfv(16384, 4611, fArray, 0);
        gL.glEnable(2884);
        gL.glEnable(2896);
        gL.glEnable(16384);
        gL.glEnable(2929);
        gL.glEnable(2977);
        gL.glPushMatrix();
        gL.glRotatef(f, 1.0f, 0.0f, 0.0f);
        gL.glRotatef(f2, 0.0f, 1.0f, 0.0f);
        gL.glRotatef(f3, 0.0f, 0.0f, 1.0f);
        gL.glPushMatrix();
        gL.glTranslatef(-3.0f, -2.0f, 0.0f);
        gL.glRotatef(f4, 0.0f, 0.0f, 1.0f);
        gL.glMaterialfv(1028, 5634, fArray2, 0);
        Gears.gear(gL, 1.0f, 4.0f, 1.0f, 20, 0.7f);
        gL.glPopMatrix();
        gL.glPushMatrix();
        gL.glTranslatef(3.1f, -2.0f, 0.0f);
        gL.glRotatef(-2.0f * f4 - 9.0f, 0.0f, 0.0f, 1.0f);
        gL.glMaterialfv(1028, 5634, fArray3, 0);
        Gears.gear(gL, 0.5f, 2.0f, 2.0f, 10, 0.7f);
        gL.glPopMatrix();
        gL.glPushMatrix();
        gL.glTranslatef(-3.1f, 4.2f, 0.0f);
        gL.glRotatef(-2.0f * f4 - 25.0f, 0.0f, 0.0f, 1.0f);
        gL.glMaterialfv(1028, 5634, fArray4, 0);
        Gears.gear(gL, 1.3f, 2.0f, 0.5f, 10, 0.7f);
        gL.glPopMatrix();
        gL.glPopMatrix();
    }
}

