/*
 * Decompiled with CFR 0.152.
 */
package demos.multisample;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Frame;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import javax.media.opengl.DefaultGLCapabilitiesChooser;
import javax.media.opengl.GL;
import javax.media.opengl.GLAutoDrawable;
import javax.media.opengl.GLCanvas;
import javax.media.opengl.GLCapabilities;
import javax.media.opengl.GLCapabilitiesChooser;
import javax.media.opengl.GLEventListener;

public class Multisample {
    private GLCanvas canvas;

    public static void main(String[] stringArray) {
        new Multisample().run(stringArray);
    }

    public void run(String[] stringArray) {
        GLCapabilities gLCapabilities = new GLCapabilities();
        MultisampleChooser multisampleChooser = new MultisampleChooser();
        gLCapabilities.setSampleBuffers(true);
        gLCapabilities.setNumSamples(4);
        this.canvas = new GLCanvas(gLCapabilities, (GLCapabilitiesChooser)multisampleChooser, null, null);
        this.canvas.addGLEventListener((GLEventListener)new Listener());
        Frame frame = new Frame("Full-scene antialiasing");
        frame.setLayout(new BorderLayout());
        this.canvas.setSize(512, 512);
        frame.add((Component)this.canvas, "Center");
        frame.pack();
        frame.show();
        frame.setLocation(0, 0);
        this.canvas.requestFocus();
        frame.addWindowListener(new WindowAdapter(){

            public void windowClosing(WindowEvent windowEvent) {
                Multisample.this.runExit();
            }
        });
        gLCapabilities.setSampleBuffers(false);
        this.canvas = new GLCanvas(gLCapabilities);
        this.canvas.addGLEventListener((GLEventListener)new Listener());
        frame = new Frame("No antialiasing");
        frame.setLayout(new BorderLayout());
        this.canvas.setSize(512, 512);
        frame.add((Component)this.canvas, "Center");
        frame.pack();
        frame.show();
        frame.setLocation(512, 0);
        this.canvas.requestFocus();
        frame.addWindowListener(new WindowAdapter(){

            public void windowClosing(WindowEvent windowEvent) {
                Multisample.this.runExit();
            }
        });
    }

    private void runExit() {
        new Thread(new Runnable(){

            public void run() {
                System.exit(0);
            }
        }).start();
    }

    class Listener
    implements GLEventListener {
        Listener() {
        }

        public void init(GLAutoDrawable gLAutoDrawable) {
            GL gL = gLAutoDrawable.getGL();
            gL.glClearColor(0.0f, 0.0f, 0.0f, 0.0f);
            gL.glMatrixMode(5888);
            gL.glLoadIdentity();
            gL.glMatrixMode(5889);
            gL.glLoadIdentity();
            gL.glOrtho(-1.0, 1.0, -1.0, 1.0, -1.0, 1.0);
        }

        public void display(GLAutoDrawable gLAutoDrawable) {
            GL gL = gLAutoDrawable.getGL();
            gL.glClear(16640);
            int n = 20;
            double d = Math.PI / (double)n;
            double d2 = 1.0;
            gL.glBegin(1);
            for (int i = n - 1; i >= 0; --i) {
                gL.glVertex3d(d2 * Math.cos((double)i * d), d2 * Math.sin((double)i * d), 0.0);
                gL.glVertex3d(-1.0 * d2 * Math.cos((double)i * d), -1.0 * d2 * Math.sin((double)i * d), 0.0);
            }
            gL.glEnd();
        }

        public void reshape(GLAutoDrawable gLAutoDrawable, int n, int n2, int n3, int n4) {
        }

        public void displayChanged(GLAutoDrawable gLAutoDrawable, boolean bl, boolean bl2) {
        }
    }

    static class MultisampleChooser
    extends DefaultGLCapabilitiesChooser {
        MultisampleChooser() {
        }

        public int chooseCapabilities(GLCapabilities gLCapabilities, GLCapabilities[] gLCapabilitiesArray, int n) {
            int n2;
            boolean bl = false;
            for (n2 = 0; n2 < gLCapabilitiesArray.length; ++n2) {
                GLCapabilities gLCapabilities2 = gLCapabilitiesArray[n2];
                if (gLCapabilities2 == null || !gLCapabilities2.getSampleBuffers()) continue;
                bl = true;
                break;
            }
            n2 = super.chooseCapabilities(gLCapabilities, gLCapabilitiesArray, n);
            if (!bl) {
                System.err.println("WARNING: antialiasing will be disabled because none of the available pixel formats had it to offer");
            } else if (!gLCapabilitiesArray[n2].getSampleBuffers()) {
                System.err.println("WARNING: antialiasing will be disabled because the DefaultGLCapabilitiesChooser didn't supply it");
            }
            return n2;
        }
    }
}

